/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.mestestutils;

import com.modelengineers.MoRe_elk.alg.layered.mestestutils.NodeLabelEdgeIntersection;
import com.modelengineers.MoRe_elk.alg.layered.mestestutils.NodeWithLabelsRectangle;
import com.modelengineers.MoRe_elk.core.util.Pair;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_elk.graph.ElkPort;
import com.modelengineers.MoRe_elk.graph.impl.ElkPortImpl;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NodeWithTopPortNotPlacedRightToSourceNode {
    private ElkNode graph;

    public NodeWithTopPortNotPlacedRightToSourceNode(ElkNode graph) {
        this.graph = graph;
    }

    public String getErrorMsg() {
        Pair<ElkNode, ElkNode> nodeWithTopPortThatIsNotPlacedCorrectlyAndItsSrcNode = this.getNodeWithTopPortThatIsNotPlacedCorrectlyAndItsSrcNode();
        if (nodeWithTopPortThatIsNotPlacedCorrectlyAndItsSrcNode == null) {
            return "";
        }
        return this.getErrorMsg(nodeWithTopPortThatIsNotPlacedCorrectlyAndItsSrcNode);
    }

    private Pair<ElkNode, ElkNode> getNodeWithTopPortThatIsNotPlacedCorrectlyAndItsSrcNode() {
        for (ElkNode srcNode : this.getSrcNodesToBePlacedLeftToTheirTargetNodesWithTopPorts()) {
            ElkNode targetNodePlacedIncorrectly = this.getTargetNodeNotPlacedRightToSourceNode(srcNode);
            if (targetNodePlacedIncorrectly == null) continue;
            return Pair.of(srcNode, targetNodePlacedIncorrectly);
        }
        return null;
    }

    private List<ElkNode> getSrcNodesToBePlacedLeftToTheirTargetNodesWithTopPorts() {
        return this.graph.getChildren().stream().filter(n -> this.hasMoreThanOneTargetNode((ElkNode)n) && this.hasTargetNodesWithTopPorts((ElkNode)n)).collect(Collectors.toList());
    }

    private boolean hasMoreThanOneTargetNode(ElkNode node) {
        return node.getTargetNodes().size() > 1;
    }

    private boolean hasTargetNodesWithTopPorts(ElkNode node) {
        return this.getTargetNodesWithTopPorts(node).count() > 0L;
    }

    private Stream<ElkNode> getTargetNodesWithTopPorts(ElkNode node) {
        return this.getTargetTopPortsThatHaveEastSrcPort(node).map(p -> p.getParent()).distinct();
    }

    private Stream<ElkPort> getTargetTopPortsThatHaveEastSrcPort(ElkNode node) {
        return node.getConnectedTargetPorts().stream().filter(p -> p.getPortSide().equals((Object)ElkPortImpl.ElkPortSide.NORTH) && p.getSourcePort().getPortSide().equals((Object)ElkPortImpl.ElkPortSide.EAST));
    }

    private ElkNode getTargetNodeNotPlacedRightToSourceNode(ElkNode srcNode) {
        return this.getTargetNodesWithTopPorts(srcNode).filter(n -> !this.isTargetNodePlacedRightToSourceNode(srcNode, (ElkNode)n)).findFirst().orElse(null);
    }

    private boolean isTargetNodePlacedRightToSourceNode(ElkNode srcNode, ElkNode targetNode) {
        return this.getNodeRectangle((ElkNode)targetNode).x > this.getNodeRectangle((ElkNode)srcNode).x + this.getNodeRectangle((ElkNode)srcNode).width;
    }

    private NodeWithLabelsRectangle getNodeRectangle(ElkNode node) {
        return NodeLabelEdgeIntersection.getNodeRectangle(node);
    }

    private String getErrorMsg(Pair<ElkNode, ElkNode> srcAndTargetNodes) {
        return String.valueOf(srcAndTargetNodes.getSecond().toString()) + " is not placed right to " + srcAndTargetNodes.getFirst().toString();
    }
}

