/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.mestestutils;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.mestestutils.NodeWithLabelsRectangle;
import com.modelengineers.MoRe_elk.core.math.ElkMath;
import com.modelengineers.MoRe_elk.core.math.ElkRectangle;
import com.modelengineers.MoRe_elk.core.math.KVector;
import com.modelengineers.MoRe_elk.core.math.KVectorChain;
import com.modelengineers.MoRe_elk.core.util.ElkUtil;
import com.modelengineers.MoRe_elk.core.util.Pair;
import com.modelengineers.MoRe_elk.graph.ElkEdge;
import com.modelengineers.MoRe_elk.graph.ElkLabel;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_elk.graph.ElkPort;
import com.modelengineers.MoRe_elk.graph.util.ElkGraphUtil;
import com.modelengineers.MoRe_emf.common.util.EList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NodeLabelEdgeIntersection {
    private ElkNode graph;
    private List<NodeWithLabelsRectangle> allRectangles;

    public NodeLabelEdgeIntersection(ElkNode graph) {
        this.graph = graph;
        this.allRectangles = this.getRectanglesForNodes();
    }

    public boolean containsIntersectingEdge() {
        return this.containsEdgeIntersectingRectangle();
    }

    public boolean containsIntersectingNode() {
        return this.intersectionBetweenRectangles();
    }

    public boolean edgeIsCrossed(ElkEdge edge) {
        List<ElkUtil.Segment> segmentsOfAllEdges = this.getAllSegmentsInGraph();
        List<ElkUtil.Segment> segmentsOfEdge = ElkUtil.getSegments(edge);
        return this.getNumCrossingsBetween(segmentsOfEdge, segmentsOfAllEdges) != 0;
    }

    public int getNumEdgeEdgeCrossings() {
        List<ElkUtil.Segment> segmentsOfAllEdges = this.getAllSegmentsInGraph();
        return this.getNumCrossingsBetween(segmentsOfAllEdges);
    }

    public boolean edgesCross(ElkEdge edge1, ElkEdge edge2) {
        List<ElkUtil.Segment> segmentsOfEdge1 = ElkUtil.getSegments(edge1);
        List<ElkUtil.Segment> segmentsOfEdge2 = ElkUtil.getSegments(edge2);
        int i = 0;
        while (i < segmentsOfEdge1.size()) {
            int j = 0;
            while (j < segmentsOfEdge2.size()) {
                if (segmentsOfEdge1.get(i).crosses(segmentsOfEdge2.get(j))) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private List<NodeWithLabelsRectangle> getRectanglesForNodes() {
        EList<ElkNode> nodes = this.graph.getChildren();
        NodeLabelEdgeIntersection.assertThatNodesDoNotHaveFurtherChildren(nodes);
        return NodeLabelEdgeIntersection.getAllNodeRectangles(nodes);
    }

    private static void assertThatNodesDoNotHaveFurtherChildren(List<ElkNode> nodes) {
        nodes.forEach(n -> NodeLabelEdgeIntersection.assertHasNoChildren(n));
    }

    private static void assertHasNoChildren(ElkNode node) {
        assert (node.getChildren().isEmpty());
    }

    private static List<NodeWithLabelsRectangle> getAllNodeRectangles(List<ElkNode> nodes) {
        ArrayList allNodesRects = Lists.newArrayList();
        nodes.forEach(n -> {
            boolean bl = allNodesRects.add(NodeLabelEdgeIntersection.getNodeRectangle(n));
        });
        return allNodesRects;
    }

    public static NodeWithLabelsRectangle getNodeRectangle(ElkNode node) {
        ElkRectangle nodeEdgeLabelRect;
        NodeWithLabelsRectangle nodeRect = new NodeWithLabelsRectangle(node);
        ElkRectangle nodeLabelRect = NodeLabelEdgeIntersection.getNodeLabelRect(node);
        if (nodeLabelRect != null) {
            nodeRect.union(nodeLabelRect);
        }
        if ((nodeEdgeLabelRect = NodeLabelEdgeIntersection.getEdgeLabelRect(node)) != null) {
            nodeRect.xUnion(nodeEdgeLabelRect);
        }
        return nodeRect;
    }

    private static ElkRectangle getNodeLabelRect(ElkNode node) {
        ElkRectangle nodeLabelRect = null;
        if (!node.getLabels().isEmpty()) {
            ElkLabel nodeLabel = (ElkLabel)node.getLabels().get(0);
            double nodeLabelAbsX = node.getX() + nodeLabel.getX();
            double nodeLabelAbsY = node.getY() + nodeLabel.getY();
            nodeLabelRect = new ElkRectangle(nodeLabelAbsX, nodeLabelAbsY, nodeLabel.getWidth(), nodeLabel.getHeight());
        }
        return nodeLabelRect;
    }

    private static ElkRectangle getEdgeLabelRect(ElkNode node) {
        ElkEdge edge = NodeLabelEdgeIntersection.getOutgoingEdgeWithLongestLabel(node);
        if (edge != null) {
            KVector startPosOfEdge = ElkUtil.getStartPosOfEdge(edge);
            ElkLabel edgeLabel = (ElkLabel)edge.getLabels().get(0);
            double edgeLabelAbsX = NodeLabelEdgeIntersection.getXPosForLabel(startPosOfEdge, edgeLabel, edge);
            double edgeLabelAbsY = startPosOfEdge.y;
            return new ElkRectangle(edgeLabelAbsX, edgeLabelAbsY, edgeLabel.getWidth(), edgeLabel.getHeight());
        }
        return null;
    }

    private static double getXPosForLabel(KVector startPosOfEdge, ElkLabel edgeLabel, ElkEdge edge) {
        double edgeLabelAbsX = startPosOfEdge.x;
        if (NodeLabelEdgeIntersection.sourcePortIsWestPort(edge)) {
            edgeLabelAbsX -= edgeLabel.getWidth();
        }
        return edgeLabelAbsX;
    }

    private static boolean sourcePortIsWestPort(ElkEdge edge) {
        ElkPort sourcePort = ElkGraphUtil.getSourcePort(edge);
        return sourcePort.getX() <= 0.0;
    }

    private static ElkEdge getOutgoingEdgeWithLongestLabel(ElkNode node) {
        ElkEdge edgeWithLongestLabel = null;
        double lenthOfLongestLabel = 0.0;
        for (ElkPort port : node.getPorts()) {
            for (ElkEdge edge : port.getOutgoingEdges()) {
                if (edge.getLabels().isEmpty() || !(((ElkLabel)edge.getLabels().get(0)).getWidth() > lenthOfLongestLabel)) continue;
                edgeWithLongestLabel = edge;
                lenthOfLongestLabel = ((ElkLabel)edge.getLabels().get(0)).getWidth();
            }
        }
        return edgeWithLongestLabel;
    }

    private boolean intersectionBetweenRectangles() {
        int numRects = this.allRectangles.size();
        int rectIx = 0;
        while (rectIx < numRects) {
            NodeWithLabelsRectangle rect = this.allRectangles.get(rectIx);
            int otherRectIx = rectIx + 1;
            while (otherRectIx < numRects) {
                if (rect.intersects(this.allRectangles.get(otherRectIx))) {
                    return true;
                }
                ++otherRectIx;
            }
            ++rectIx;
        }
        return false;
    }

    private List<ElkUtil.Segment> getAllSegmentsInGraph() {
        return this.graph.getContainedEdges().stream().flatMap(e -> ElkUtil.getSegments(e).stream()).collect(Collectors.toList());
    }

    private int getNumCrossingsBetween(List<ElkUtil.Segment> segmentsA, List<ElkUtil.Segment> segmentsB) {
        return this.getNumCrossingsBetween(segmentsA, segmentsB, true);
    }

    private int getNumCrossingsBetween(List<ElkUtil.Segment> segments) {
        return this.getNumCrossingsBetween(segments, segments, false);
    }

    private int getNumCrossingsBetween(List<ElkUtil.Segment> segmentsA, List<ElkUtil.Segment> segmentsB, boolean startAtZero) {
        int numCrossings = 0;
        int ixA = 0;
        while (ixA < segmentsA.size()) {
            int ixB = startAtZero ? 0 : ixA + 1;
            while (ixB < segmentsB.size()) {
                if (segmentsA.get(ixA).crosses(segmentsB.get(ixB))) {
                    ++numCrossings;
                }
                ++ixB;
            }
            ++ixA;
        }
        return numCrossings;
    }

    private boolean containsEdgeIntersectingRectangle() {
        for (ElkEdge edge : this.graph.getContainedEdges()) {
            if (!this.isIntersectingRectangles(edge)) continue;
            return true;
        }
        return false;
    }

    private boolean isIntersectingRectangles(ElkEdge edge) {
        KVectorChain route = ElkUtil.getPointsOfEdge(edge);
        for (NodeWithLabelsRectangle rectangle : this.allRectangles) {
            if (!NodeLabelEdgeIntersection.isIntersecting(rectangle, route, edge)) continue;
            return true;
        }
        return false;
    }

    private static boolean isIntersecting(NodeWithLabelsRectangle rectangle, KVectorChain route, ElkEdge edge) {
        Iterator points = route.iterator();
        KVector currentPoint = (KVector)points.next();
        while (points.hasNext()) {
            KVector nextPoint = (KVector)points.next();
            if (ElkMath.intersects(rectangle, currentPoint, nextPoint, true)) {
                ElkNode nodeOfIntersectedRectangle = rectangle.getNode();
                if (NodeLabelEdgeIntersection.isSourceOrTargetOfEdge(nodeOfIntersectedRectangle, edge)) {
                    if (NodeLabelEdgeIntersection.isIntersectingRealNodeOrNodeLabel(nodeOfIntersectedRectangle, currentPoint, nextPoint)) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            currentPoint = nextPoint;
        }
        return false;
    }

    private static boolean isSourceOrTargetOfEdge(ElkNode node, ElkEdge edge) {
        ElkNode sourceNode = ElkGraphUtil.getSourceNode(edge);
        ElkNode targetNode = ElkGraphUtil.getTargetNode(edge);
        return node == sourceNode || node == targetNode;
    }

    private static boolean isIntersectingRealNodeOrNodeLabel(ElkNode node, KVector currentPoint, KVector nextPoint) {
        return NodeLabelEdgeIntersection.intersectsNode(node, currentPoint, nextPoint) || NodeLabelEdgeIntersection.intersectsNodeLabel(node, currentPoint, nextPoint);
    }

    private static boolean intersectsNode(ElkNode node, KVector currentPoint, KVector nextPoint) {
        ElkRectangle rectangleOfNode = new ElkRectangle(node.getX(), node.getY(), node.getWidth(), node.getHeight());
        return ElkMath.intersects(rectangleOfNode, currentPoint, nextPoint, true);
    }

    private static boolean intersectsNodeLabel(ElkNode node, KVector currentPoint, KVector nextPoint) {
        ElkRectangle rectangleOfNodeLabel = NodeLabelEdgeIntersection.getNodeLabelRect(node);
        if (rectangleOfNodeLabel != null) {
            return ElkMath.intersects(rectangleOfNodeLabel, currentPoint, nextPoint, true);
        }
        return false;
    }

    public static Pair<ElkEdge, ElkEdge> getEdgesWithHorizontalSegmentsYCloserThan(double minYSpacing, ElkNode graph) {
        List<SpacingRect> horizontalSpacingRects = NodeLabelEdgeIntersection.getHorizontalSpacingRectsOfEdges(graph, minYSpacing);
        Pair<SpacingRect, SpacingRect> intersRects = NodeLabelEdgeIntersection.getIntersectingRects(horizontalSpacingRects);
        return NodeLabelEdgeIntersection.getCorrespondingEdges(intersRects);
    }

    private static List<SpacingRect> getHorizontalSpacingRectsOfEdges(ElkNode graph, double minYSpacing) {
        return graph.getContainedEdges().stream().flatMap(edge -> NodeLabelEdgeIntersection.createHorizontalSpacingRects(edge, minYSpacing)).collect(Collectors.toList());
    }

    private static Stream<SpacingRect> createHorizontalSpacingRects(ElkEdge edge, double minYSpacing) {
        return ElkUtil.getHorizontalSegments(edge).stream().map(s -> NodeLabelEdgeIntersection.createHorizontalSpacingRect(s, edge, minYSpacing));
    }

    private static SpacingRect createHorizontalSpacingRect(ElkUtil.Segment segment, ElkEdge edge, double minYSpacing) {
        KVector leftPoint = segment.getLeftPoint();
        KVector rightPoint = segment.getRightPoint();
        return new SpacingRect(leftPoint, rightPoint.x - leftPoint.x, minYSpacing, edge, false);
    }

    public static Pair<ElkEdge, ElkEdge> getEdgesWithVerticalSegmentsXCloserThan(double minXSpacing, ElkNode graph) {
        List<SpacingRect> verticalSpacingRects = NodeLabelEdgeIntersection.getVerticalSpacingRectsOfEdges(graph, minXSpacing);
        Pair<SpacingRect, SpacingRect> intersRects = NodeLabelEdgeIntersection.getIntersectingRects(verticalSpacingRects);
        return NodeLabelEdgeIntersection.getCorrespondingEdges(intersRects);
    }

    private static List<SpacingRect> getVerticalSpacingRectsOfEdges(ElkNode graph, double minXSpacing) {
        return graph.getContainedEdges().stream().flatMap(edge -> NodeLabelEdgeIntersection.createVerticalSpacingRects(edge, minXSpacing)).collect(Collectors.toList());
    }

    private static Stream<SpacingRect> createVerticalSpacingRects(ElkEdge edge, double minXSpacing) {
        return ElkUtil.getVerticalSegments(edge).stream().map(s -> NodeLabelEdgeIntersection.createVerticalSpacingRect(s, edge, minXSpacing));
    }

    private static SpacingRect createVerticalSpacingRect(ElkUtil.Segment segment, ElkEdge edge, double minXSpacing) {
        KVector lowerPoint = segment.getLowerPoint();
        KVector higherPoint = segment.getHigherPoint();
        return new SpacingRect(higherPoint, minXSpacing, lowerPoint.y - higherPoint.y, edge, true);
    }

    private static Pair<SpacingRect, SpacingRect> getIntersectingRects(List<SpacingRect> lineRects) {
        int thisRectIx = 0;
        while (thisRectIx < lineRects.size()) {
            SpacingRect thisRect = lineRects.get(thisRectIx);
            int otherRectIx = thisRectIx + 1;
            while (otherRectIx < lineRects.size()) {
                SpacingRect otherRect = lineRects.get(otherRectIx);
                if (thisRect.intersectsSpacingRect(otherRect)) {
                    return new Pair<SpacingRect, SpacingRect>(thisRect, otherRect);
                }
                ++otherRectIx;
            }
            ++thisRectIx;
        }
        return null;
    }

    private static Pair<ElkEdge, ElkEdge> getCorrespondingEdges(Pair<SpacingRect, SpacingRect> intersRects) {
        if (intersRects == null) {
            return null;
        }
        return new Pair<ElkEdge, ElkEdge>(intersRects.getFirst().getEdge(), intersRects.getSecond().getEdge());
    }

    private static class SpacingRect
    extends ElkRectangle {
        private ElkEdge edge;
        private boolean isVerticalSeg;

        SpacingRect(KVector startPoint, double width, double height, ElkEdge edge, boolean isVerticalSeg) {
            super(startPoint.x, startPoint.y, width, height);
            this.edge = edge;
            this.isVerticalSeg = isVerticalSeg;
        }

        public boolean intersectsSpacingRect(SpacingRect otherRect) {
            if (this.isSpacingRectWithOtherSource(otherRect)) {
                return super.intersects(otherRect);
            }
            return this.intersectsSpacingRectWithSameSource(otherRect);
        }

        public ElkEdge getEdge() {
            return this.edge;
        }

        private boolean isSpacingRectWithOtherSource(SpacingRect otherRect) {
            return this.edge.getSources().get(0) != otherRect.edge.getSources().get(0);
        }

        private boolean intersectsSpacingRectWithSameSource(SpacingRect otherRect) {
            return super.intersects(otherRect) && !this.overlaps(otherRect);
        }

        private boolean overlaps(SpacingRect otherRect) {
            if (this.isVerticalSeg) {
                return this.x == otherRect.x && (this.y <= otherRect.y + otherRect.height || otherRect.y <= this.y + this.height);
            }
            return this.y == otherRect.y && (this.x + otherRect.width <= otherRect.x || otherRect.x <= this.x + this.width);
        }
    }
}

