/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.mestestutils;

import com.modelengineers.MoRe_elk.alg.layered.mesutils.MesUtilMethods;
import com.modelengineers.MoRe_elk.core.math.KVectorChain;
import com.modelengineers.MoRe_elk.core.util.ElkUtil;
import com.modelengineers.MoRe_elk.graph.ElkEdge;
import com.modelengineers.MoRe_elk.graph.ElkGraphElement;
import com.modelengineers.MoRe_elk.graph.ElkLabel;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LargeVerticalGaps {
    private static final int MAX_Y_GAP_ALLOWED = 40;
    private ElkNode graph;
    private ElkGraphElement currentUpperElement;
    private ElkGraphElement upperElement;
    private ElkGraphElement lowerElement;
    private double maxGap;
    private boolean found;

    public LargeVerticalGaps(ElkNode graph) {
        this.graph = graph;
    }

    public String getErrorMsg() {
        return this.find() ? this.getErrorMessageForFoundGap() : "";
    }

    private boolean find() {
        this.maxGap = this.getMaxYGap();
        if (this.maxGap > 40.0) {
            this.found = true;
        }
        return this.found;
    }

    private double getMaxYGap() {
        Stream<Interval> intervals = this.getYIntervalsOfNodesAndEdges();
        List<Interval> intervalsSorted = LargeVerticalGaps.sortByStart(intervals);
        return this.getMaxGap(intervalsSorted);
    }

    private Stream<Interval> getYIntervalsOfNodesAndEdges() {
        return Stream.concat(this.getYIntervalsOfNodes(), this.getYIntervalsOfEdges());
    }

    private Stream<Interval> getYIntervalsOfNodes() {
        return this.graph.getChildren().stream().map(n -> this.getYIntervalOfNode((ElkNode)n));
    }

    private Interval getYIntervalOfNode(ElkNode node) {
        double start = node.getY();
        double end = start + node.getHeight();
        if (!node.getLabels().isEmpty()) {
            ElkLabel label = (ElkLabel)node.getLabels().get(0);
            double labelStart = start + label.getY();
            double labelEnd = labelStart + label.getHeight();
            start = Math.min(start, labelStart);
            end = Math.max(end, labelEnd);
        }
        return new Interval(start, end, node);
    }

    private Stream<Interval> getYIntervalsOfEdges() {
        return this.graph.getContainedEdges().stream().map(e -> this.getYIntervalOfEdge((ElkEdge)e));
    }

    private Interval getYIntervalOfEdge(ElkEdge edge) {
        KVectorChain points = ElkUtil.getPointsOfEdge(edge);
        List pointsY = points.stream().map(p -> p.y).collect(Collectors.toList());
        double start = (Double)Collections.min(pointsY);
        double end = (Double)Collections.max(pointsY);
        return new Interval(start, end, edge);
    }

    private static List<Interval> sortByStart(Stream<Interval> intervals) {
        return intervals.sorted(Comparator.comparingDouble(i -> ((Interval)i).start)).collect(Collectors.toList());
    }

    private double getMaxGap(List<Interval> sortedIntervals) {
        this.maxGap = 0.0;
        this.currentUpperElement = sortedIntervals.get(0).element;
        double currentEnd = sortedIntervals.get(0).end;
        int ixNext = 1;
        while (ixNext < sortedIntervals.size()) {
            Interval next = sortedIntervals.get(ixNext);
            double currentGap = next.start - currentEnd;
            if (currentGap > this.maxGap) {
                this.maxGap = currentGap;
                this.lowerElement = next.element;
                this.upperElement = this.currentUpperElement;
            }
            this.maxGap = Math.max(this.maxGap, next.start - currentEnd);
            if (next.end > currentEnd) {
                currentEnd = next.end;
                this.currentUpperElement = next.element;
            }
            currentEnd = Math.max(currentEnd, next.end);
            ++ixNext;
        }
        return this.maxGap;
    }

    private String getErrorMessageForFoundGap() {
        String upperElementString = this.getString(this.upperElement);
        String lowerElementString = this.getString(this.lowerElement);
        return "Gap of " + this.maxGap + " between " + upperElementString + " and " + lowerElementString;
    }

    private String getString(ElkGraphElement nodeOrEdge) {
        if (nodeOrEdge instanceof ElkNode) {
            return MesUtilMethods.getNameOfNode((ElkNode)nodeOrEdge);
        }
        if (nodeOrEdge instanceof ElkEdge) {
            return MesUtilMethods.getDescription((ElkEdge)nodeOrEdge);
        }
        throw new IllegalArgumentException("Unknown type!");
    }

    class Interval {
        private double start;
        private double end;
        private ElkGraphElement element;

        Interval(double start, double end, ElkGraphElement element) {
            this.start = start;
            this.end = end;
            this.element = element;
        }
    }
}

