/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.mestestutils;

import com.modelengineers.MoRe_elk.alg.layered.mestestutils.NodeLabelEdgeIntersection;
import com.modelengineers.MoRe_elk.alg.layered.mesutils.MesUtilMethods;
import com.modelengineers.MoRe_elk.core.math.ElkRectangle;
import com.modelengineers.MoRe_elk.core.util.ElkUtil;
import com.modelengineers.MoRe_elk.graph.ElkConnectableShape;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_elk.graph.ElkPort;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HorizontalSegmentsOfEdgesFromSameSourceShouldBeMerged {
    private static final int MAX_ALLOWED_X_OVERLAP_OF_EDGES_WITH_SAME_SOURCE = 400;
    private ElkNode graph;
    private List<ElkRectangle> nodeWithLabelRectangles = new ArrayList<ElkRectangle>();

    public HorizontalSegmentsOfEdgesFromSameSourceShouldBeMerged(ElkNode graph) {
        this.graph = graph;
        graph.getChildren().forEach(n -> {
            boolean bl = this.nodeWithLabelRectangles.add(NodeLabelEdgeIntersection.getNodeRectangle(n));
        });
    }

    public List<String> srcNodesOfViolations() {
        Stream<ElkPort> srcPorts = this.graph.getContainedEdges().stream().map(e -> (ElkPort)e.getSources().get(0)).distinct();
        List<String> srcNodesOfViolations = srcPorts.filter(p -> this.hasHorizontalSegmentsThatShouldBeMerged((ElkPort)p)).map(p -> p.getParent().toString()).collect(Collectors.toList());
        return srcNodesOfViolations.isEmpty() ? null : srcNodesOfViolations;
    }

    private boolean hasHorizontalSegmentsThatShouldBeMerged(ElkPort port) {
        List<ElkUtil.Segment> segments = ElkUtil.getSegmentsOfOutgoingEdges(port);
        return MesUtilMethods.getUniquePairsAsStream(segments).anyMatch(pair -> this.segmentsShouldBeMerged((ElkUtil.Segment)pair.getFirst(), (ElkUtil.Segment)pair.getSecond(), port, segments));
    }

    private boolean segmentsShouldBeMerged(ElkUtil.Segment s1, ElkUtil.Segment s2, ElkPort p, List<ElkUtil.Segment> allSegmentsOfEdge) {
        return HorizontalSegmentsOfEdgesFromSameSourceShouldBeMerged.areHorizontal(s1, s2) && HorizontalSegmentsOfEdgesFromSameSourceShouldBeMerged.haveSameDirection(s1, s2) && HorizontalSegmentsOfEdgesFromSameSourceShouldBeMerged.haveYDistance(s1, s2) && HorizontalSegmentsOfEdgesFromSameSourceShouldBeMerged.overlapTooMuch(s1, s2, allSegmentsOfEdge) && this.noNodeBetweenSegments(s1, s2) && this.noHorizontalSegmentsBetweenSegments(s1, s2, p);
    }

    private static boolean areHorizontal(ElkUtil.Segment s1, ElkUtil.Segment s2) {
        return s1.isHorizontal() && s2.isHorizontal();
    }

    private static boolean haveSameDirection(ElkUtil.Segment s1, ElkUtil.Segment s2) {
        return s1.runsRightwards() == s2.runsRightwards();
    }

    private static boolean haveYDistance(ElkUtil.Segment s1, ElkUtil.Segment s2) {
        return HorizontalSegmentsOfEdgesFromSameSourceShouldBeMerged.getAbsYDistance(s1, s2) > 0.0;
    }

    private static double getAbsYDistance(ElkUtil.Segment s1, ElkUtil.Segment s2) {
        return Math.abs(s1.getHigherPoint().y - s2.getHigherPoint().y);
    }

    private static boolean overlapTooMuch(ElkUtil.Segment s1, ElkUtil.Segment s2, List<ElkUtil.Segment> allSegmentsOfEdge) {
        return s1.getHorizontalOverlapLength(s2) > (double)HorizontalSegmentsOfEdgesFromSameSourceShouldBeMerged.getMaxAllowedXOverlap(s1, s2, allSegmentsOfEdge);
    }

    private static int getMaxAllowedXOverlap(ElkUtil.Segment s1, ElkUtil.Segment s2, List<ElkUtil.Segment> allSegmentsOfEdge) {
        return HorizontalSegmentsOfEdgesFromSameSourceShouldBeMerged.oneEdgeBendsBeforeOtherEnds(s1, s2, allSegmentsOfEdge) ? 0 : 400;
    }

    private static boolean oneEdgeBendsBeforeOtherEnds(ElkUtil.Segment s1, ElkUtil.Segment s2, List<ElkUtil.Segment> allSegmentsOfEdge) {
        return HorizontalSegmentsOfEdgesFromSameSourceShouldBeMerged.edgeBendsBeforeOtherEnds(s1, s2, allSegmentsOfEdge) || HorizontalSegmentsOfEdgesFromSameSourceShouldBeMerged.edgeBendsBeforeOtherEnds(s2, s1, allSegmentsOfEdge);
    }

    private static boolean edgeBendsBeforeOtherEnds(ElkUtil.Segment s1, ElkUtil.Segment s2, List<ElkUtil.Segment> allSegmentsOfEdge) {
        return HorizontalSegmentsOfEdgesFromSameSourceShouldBeMerged.hasFollowingSegment(s1, allSegmentsOfEdge) && (s1.runsRightwards() && s1.getEndPoint().x < s2.getEndPoint().x || s1.runsLeftwards() && s1.getEndPoint().x > s2.getEndPoint().x);
    }

    private static boolean hasFollowingSegment(ElkUtil.Segment segment, List<ElkUtil.Segment> allSegmentsOfEdge) {
        return allSegmentsOfEdge.stream().anyMatch(s -> s.getStartPoint() == segment.getEndPoint());
    }

    private boolean noNodeBetweenSegments(ElkUtil.Segment s1, ElkUtil.Segment s2) {
        ElkRectangle segmentsRectangle = this.getSegmentsOverlapRectangle(s1, s2);
        return this.nodeWithLabelRectangles.stream().noneMatch(nr -> nr.intersects(segmentsRectangle));
    }

    private boolean noHorizontalSegmentsBetweenSegments(ElkUtil.Segment s1, ElkUtil.Segment s2, ElkPort srcPort) {
        ElkRectangle segmentsRectangle = this.getSegmentsOverlapRectangle(s1, s2);
        return this.graph.getContainedEdges().stream().filter(e -> !((ElkConnectableShape)e.getSources().get(0)).equals(srcPort)).noneMatch(e -> ElkUtil.getSegments(e).stream().anyMatch(s -> s.isHorizontal() && segmentsRectangle.intersects(this.getSegmentRectangle((ElkUtil.Segment)s))));
    }

    private ElkRectangle getSegmentsOverlapRectangle(ElkUtil.Segment s1, ElkUtil.Segment s2) {
        double width = s1.getHorizontalOverlapLength(s2);
        double height = Math.abs(s1.getHigherPoint().y - s2.getHigherPoint().y);
        double left = Math.max(s1.getLeftPoint().x, s2.getLeftPoint().x);
        double top = Math.min(s1.getHigherPoint().y, s2.getHigherPoint().y);
        return new ElkRectangle(left, top, width, height);
    }

    private ElkRectangle getSegmentRectangle(ElkUtil.Segment segment) {
        double width = segment.getHorizontalLength() + 2.0;
        double height = segment.getVerticalLength() + 2.0;
        double top = segment.getHigherPoint().y - 1.0;
        double left = segment.getLeftPoint().x - 1.0;
        return new ElkRectangle(left, top, width, height);
    }
}

