/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.mestestutils;

import com.google.common.collect.Streams;
import com.modelengineers.MoRe_elk.core.math.KVector;
import com.modelengineers.MoRe_elk.core.math.KVectorChain;
import com.modelengineers.MoRe_elk.core.util.ElkUtil;
import com.modelengineers.MoRe_elk.core.util.Pair;
import com.modelengineers.MoRe_elk.graph.ElkEdge;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_elk.graph.ElkPort;
import com.modelengineers.MoRe_emf.common.util.EList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EdgesSplitTooFarFromAdjacentTargetPorts {
    private static final int MAX_ALLOWED_X_DISTANCE_OF_SPLIT_POINT_FROM_ADJACENT_TARGET_PORTS = 80;
    private ElkNode graph;

    public EdgesSplitTooFarFromAdjacentTargetPorts(ElkNode graph) {
        this.graph = graph;
    }

    public boolean found() {
        return this.getEdgesFromSameSourceToPortNeighbors().anyMatch(edgePair -> EdgesSplitTooFarFromAdjacentTargetPorts.edgesSplitTooFarFromTarget(edgePair));
    }

    private Stream<Pair<ElkEdge, ElkEdge>> getEdgesFromSameSourceToPortNeighbors() {
        return this.graph.getChildren().stream().flatMap(node -> this.getPortNeighbors((ElkNode)node)).map(portPair -> EdgesSplitTooFarFromAdjacentTargetPorts.getIncomingEdges(portPair)).filter(edgePair -> EdgesSplitTooFarFromAdjacentTargetPorts.haveSameSource(edgePair));
    }

    private Stream<Pair<ElkPort, ElkPort>> getPortNeighbors(ElkNode node) {
        Stream<ElkPort> westPorts = node.getPorts().stream().filter(p -> p.getX() <= 0.0);
        Stream<ElkPort> eastPorts = node.getPorts().stream().filter(p -> p.getX() >= p.getParent().getWidth());
        return Streams.concat((Stream[])new Stream[]{this.getPortNeighbors(westPorts), this.getPortNeighbors(eastPorts)});
    }

    private Stream<Pair<ElkPort, ElkPort>> getPortNeighbors(Stream<ElkPort> ports) {
        ArrayList<Pair<ElkPort, ElkPort>> neighbors = new ArrayList<Pair<ElkPort, ElkPort>>();
        List<ElkPort> sortedPorts = EdgesSplitTooFarFromAdjacentTargetPorts.sortPortsTopToBottom(ports);
        int ixPort = 0;
        while (ixPort < sortedPorts.size() - 1) {
            neighbors.add(new Pair<ElkPort, ElkPort>(sortedPorts.get(ixPort), sortedPorts.get(ixPort + 1)));
            ++ixPort;
        }
        return neighbors.stream();
    }

    private static List<ElkPort> sortPortsTopToBottom(Stream<ElkPort> ports) {
        return ports.sorted(Comparator.comparingDouble(p -> p.getY())).collect(Collectors.toList());
    }

    private static Pair<ElkEdge, ElkEdge> getIncomingEdges(Pair<ElkPort, ElkPort> portPair) {
        return new Pair<ElkEdge, ElkEdge>(EdgesSplitTooFarFromAdjacentTargetPorts.getIncomingEdge(portPair.getFirst()), EdgesSplitTooFarFromAdjacentTargetPorts.getIncomingEdge(portPair.getSecond()));
    }

    private static boolean haveSameSource(Pair<ElkEdge, ElkEdge> edgePair) {
        ElkEdge e1 = edgePair.getFirst();
        ElkEdge e2 = edgePair.getSecond();
        return e1 != null && e2 != null && e1.getSources().equals(e2.getSources());
    }

    private static ElkEdge getIncomingEdge(ElkPort port) {
        EList<ElkEdge> incomingEdges = port.getIncomingEdges();
        if (incomingEdges.isEmpty()) {
            return null;
        }
        assert (incomingEdges.size() == 1);
        return (ElkEdge)incomingEdges.get(0);
    }

    private static boolean edgesSplitTooFarFromTarget(Pair<ElkEdge, ElkEdge> edgePair) {
        ElkPort t1 = EdgesSplitTooFarFromAdjacentTargetPorts.getTarget(edgePair.getFirst());
        ElkPort t2 = EdgesSplitTooFarFromAdjacentTargetPorts.getTarget(edgePair.getSecond());
        assert (t1.getX() == t2.getX());
        return EdgesSplitTooFarFromAdjacentTargetPorts.getXDistanceOfSplitPointFromPort(edgePair, t1) > 80.0;
    }

    private static ElkPort getTarget(ElkEdge edge) {
        return (ElkPort)edge.getTargets().get(0);
    }

    private static double getXDistanceOfSplitPointFromPort(Pair<ElkEdge, ElkEdge> edgePair, ElkPort p) {
        KVectorChain points1 = ElkUtil.getPointsOfEdge(edgePair.getFirst());
        KVectorChain points2 = ElkUtil.getPointsOfEdge(edgePair.getSecond());
        Stream<KVector> differentPoints = EdgesSplitTooFarFromAdjacentTargetPorts.getSymmetricDifference(points1, points2);
        double pAbsX = p.getParent().getX() + p.getX();
        return differentPoints.mapToDouble(bp -> Math.abs(bp.x - pAbsX)).max().getAsDouble();
    }

    public static <T> Stream<T> getSymmetricDifference(List<T> a, List<T> b) {
        return Stream.concat(a.stream().filter(e -> !b.contains(e)), b.stream().filter(e -> !a.contains(e)));
    }
}

