/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.mestestutils;

import com.modelengineers.MoRe_elk.alg.layered.mesutils.MesUtilMethods;
import com.modelengineers.MoRe_elk.core.util.ElkUtil;
import com.modelengineers.MoRe_elk.graph.ElkEdge;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import java.util.List;
import java.util.function.Function;

public final class EdgeWithBulge {
    private ElkNode graph;
    private static final int NUM_OF_SEGMENTS_FORMING_BULGE = 4;

    public EdgeWithBulge(ElkNode graph) {
        this.graph = graph;
    }

    public String getErrorMsg() {
        return this.getMessageForEdgeWithBulge(this.getEdgeWithBulge());
    }

    private ElkEdge getEdgeWithBulge() {
        return this.graph.getContainedEdges().stream().filter(e -> this.hasBulge((ElkEdge)e)).findFirst().orElse(null);
    }

    private boolean hasBulge(ElkEdge edge) {
        return this.containsBulge(ElkUtil.getSegments(edge));
    }

    private boolean containsBulge(List<ElkUtil.Segment> segments) {
        int ix = 0;
        while (ix <= segments.size() - 4) {
            if (this.formBulge(segments.subList(ix, ix + 4))) {
                return true;
            }
            ++ix;
        }
        return false;
    }

    private boolean formBulge(List<ElkUtil.Segment> fourConsecutiveSegments) {
        return this.formUpwardsBulge(fourConsecutiveSegments) || this.formDownwardsBulge(fourConsecutiveSegments);
    }

    private boolean formUpwardsBulge(List<ElkUtil.Segment> fourConsecutiveSegments) {
        return this.formBulge(fourConsecutiveSegments, true);
    }

    private boolean formDownwardsBulge(List<ElkUtil.Segment> fourConsecutiveSegments) {
        return this.formBulge(fourConsecutiveSegments, false);
    }

    private boolean formBulge(List<ElkUtil.Segment> fourConsecutiveSegments, boolean upwards) {
        Function<ElkUtil.Segment, Boolean> runsUpDownwards;
        Function<ElkUtil.Segment, Boolean> function = runsUpDownwards = upwards ? ElkUtil.Segment::runsUpwards : ElkUtil.Segment::runsDownwards;
        return runsUpDownwards.apply(fourConsecutiveSegments.get(0)) != false && fourConsecutiveSegments.get(1).runsRightwards() && runsUpDownwards.apply(fourConsecutiveSegments.get(2)) != false && fourConsecutiveSegments.get(3).runsLeftwards();
    }

    private String getMessageForEdgeWithBulge(ElkEdge edge) {
        return edge == null ? "" : String.valueOf(MesUtilMethods.getDescription(edge)) + " has bulge";
    }
}

