/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.mestestutils;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.mestestutils.NodeLabelEdgeIntersection;
import com.modelengineers.MoRe_elk.core.options.CoreOptions;
import com.modelengineers.MoRe_elk.core.util.ElkUtil;
import com.modelengineers.MoRe_elk.graph.ElkConnectableShape;
import com.modelengineers.MoRe_elk.graph.ElkEdge;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_elk.graph.ElkPort;
import com.modelengineers.MoRe_emf.common.util.EList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class CrossingEdgesOfPortBlockNodes {
    private ElkNode graph;
    private NodeLabelEdgeIntersection nodeLabelEdgeIntersection;

    public CrossingEdgesOfPortBlockNodes(ElkNode graph) {
        this.graph = graph;
        this.nodeLabelEdgeIntersection = new NodeLabelEdgeIntersection(graph);
    }

    public boolean unnecessaryCrossingEdgesOfPortBlockNodes() {
        return this.edgesHaveUnnecessaryCrossings(this.getOutgoingEdgesFrom(this.getInportBlocks())) || this.edgesHaveUnnecessaryCrossings(this.getIncomingEdgesTo(this.getOutportBlocks()));
    }

    private boolean edgesHaveUnnecessaryCrossings(List<ElkEdge> edgesFromOrToPortBlocks) {
        int i = 0;
        while (i < edgesFromOrToPortBlocks.size()) {
            int j = i + 1;
            while (j < edgesFromOrToPortBlocks.size()) {
                ElkEdge edge2;
                ElkEdge edge1 = edgesFromOrToPortBlocks.get(i);
                if (this.nodeLabelEdgeIntersection.edgesCross(edge1, edge2 = edgesFromOrToPortBlocks.get(j)) && this.crossingIsUnnecessary(edge1, edge2)) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private boolean crossingIsUnnecessary(ElkEdge edge1, ElkEdge edge2) {
        return this.lineTrunkCrossesVertically(edge1, edge2);
    }

    private boolean lineTrunkCrossesVertically(ElkEdge edge1, ElkEdge edge2) {
        ElkEdge crossingEdge = this.getVerticalCrossingEdge(edge1, edge2);
        ElkEdge crossedEdge = crossingEdge.equals(edge1) ? edge2 : edge1;
        EList<ElkEdge> allEdgesThatStartFromSrc = ((ElkConnectableShape)crossingEdge.getSources().get(0)).getOutgoingEdges();
        for (ElkEdge edge : allEdgesThatStartFromSrc) {
            if (this.nodeLabelEdgeIntersection.edgesCross(edge, crossedEdge)) continue;
            return false;
        }
        return true;
    }

    private ElkEdge getVerticalCrossingEdge(ElkEdge edge1, ElkEdge edge2) {
        for (ElkUtil.Segment segmentOfEdge1 : ElkUtil.getSegments(edge1)) {
            for (ElkUtil.Segment segmentOfEdge2 : ElkUtil.getSegments(edge2)) {
                if (!segmentOfEdge1.crosses(segmentOfEdge2)) continue;
                if (segmentOfEdge1.isVertical()) {
                    return edge1;
                }
                return edge2;
            }
        }
        return null;
    }

    private List<ElkEdge> getOutgoingEdgesFrom(List<ElkNode> inportBlocks) {
        ArrayList outgoingEdges = Lists.newArrayList();
        for (ElkNode inportBlock : inportBlocks) {
            outgoingEdges.addAll(((ElkPort)inportBlock.getPorts().get(0)).getOutgoingEdges());
        }
        return outgoingEdges;
    }

    private List<ElkEdge> getIncomingEdgesTo(List<ElkNode> outportBlocks) {
        ArrayList incomingEdges = Lists.newArrayList();
        for (ElkNode outportBlock : outportBlocks) {
            incomingEdges.addAll(((ElkPort)outportBlock.getPorts().get(0)).getIncomingEdges());
        }
        return incomingEdges;
    }

    private List<ElkNode> getInportBlocks() {
        return this.graph.getChildren().stream().filter(node -> node.getProperty(CoreOptions.MES_BLOCK_PARAMETERS_MAP).getMap().get("BlockType").equals("Inport")).collect(Collectors.toList());
    }

    private List<ElkNode> getOutportBlocks() {
        return this.graph.getChildren().stream().filter(node -> node.getProperty(CoreOptions.MES_BLOCK_PARAMETERS_MAP).getMap().get("BlockType").equals("Outport")).collect(Collectors.toList());
    }
}

