/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate.widenodesplitting;

import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.widenodesplitting.LabelMerger;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.widenodesplitting.WideNodeJoiner;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessor;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import java.util.stream.Stream;

public final class WideNodePostProcessor
implements ILayoutProcessor<LGraph> {
    @Override
    public void process(LGraph graph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Wide Node postprocessing", 1.0f);
        new WideNodeJoiner(graph).joinNodes();
        this.restoreNodeSizeAndPortPositions(graph);
        assert (this.noWideNodesInGraph(graph));
        assert (this.containsNoLayeredNodeWithUncorrectLayerField(graph));
        progressMonitor.done();
    }

    private void restoreNodeSizeAndPortPositions(LGraph lGraph) {
        for (Layer layer : lGraph.getLayers()) {
            for (LNode node : layer.getNodes()) {
                new LabelMerger(node).resetNodeSizeAndPortPositionsIfLabelsIncluded();
            }
        }
    }

    private boolean noWideNodesInGraph(LGraph graph) {
        boolean noWideNodeInLayerlessNodes = graph.getLayerlessNodes().stream().noneMatch(LNode::isWideNode);
        boolean noWideNodeInLayerNodes = graph.getLayers().stream().flatMap(layer -> layer.getNodes().stream()).noneMatch(LNode::isWideNode);
        return noWideNodeInLayerlessNodes && noWideNodeInLayerNodes;
    }

    private boolean containsNoLayeredNodeWithUncorrectLayerField(LGraph lGraph) {
        for (Layer layer : lGraph) {
            Stream<LNode> normalNonCommentNodesInLayer = layer.getNodes().stream().filter(n -> !n.isCommentBox());
            if (!normalNonCommentNodesInLayer.anyMatch(n -> n.getLayer() != layer)) continue;
            return false;
        }
        return true;
    }
}

