/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate.widenodesplitting;

import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.LongEdgeSplitter;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.widenodesplitting.WideNodeCrossingDetector;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.widenodesplitting.WideNodeSplitter;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessor;
import com.modelengineers.MoRe_elk.core.math.KVector;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public final class WideNodeCrossingAvoider
implements ILayoutProcessor<LGraph> {
    private WideNodeCrossingDetector detector = new WideNodeCrossingDetector();
    private LGraph graph;
    private List<LNode> dummiesToMerge;
    private List<LNode> remainingDummies;

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        this.graph = layeredGraph;
        while (this.crossingExists()) {
            this.avoidCrossing();
        }
    }

    private boolean crossingExists() {
        return this.detector.detect(this.graph);
    }

    private void avoidCrossing() {
        LNode sourceDummyOfCrossing = this.detector.getSourceWideNodeDummyOfCrossing();
        this.mergeNecessaryWideNodeDummies(sourceDummyOfCrossing);
        this.assertAllEdgesAreValid();
    }

    private void mergeNecessaryWideNodeDummies(LNode sourceDummyOfCrossing) {
        this.determineDummiesToMergeAndRemainingDummies(sourceDummyOfCrossing);
        this.mergeDummiesIntoRemainingDummies();
    }

    private void determineDummiesToMergeAndRemainingDummies(LNode sourceDummyOfCrossing) {
        List<LNode> wideNodeDummies = sourceDummyOfCrossing.getWideNodeDummies();
        int ixSourceDummyOfCrossing = wideNodeDummies.indexOf(sourceDummyOfCrossing);
        this.dummiesToMerge = wideNodeDummies.subList(0, ixSourceDummyOfCrossing + 1);
        this.remainingDummies = wideNodeDummies.subList(ixSourceDummyOfCrossing + 1, wideNodeDummies.size());
    }

    private void mergeDummiesIntoRemainingDummies() {
        this.transferWidthToRemainingDummies();
        this.transferPortsToRemainingDummies();
        this.handleLongWestEdges();
        this.removeDummiesToMerge();
    }

    private void transferWidthToRemainingDummies() {
        double mergedWidth = this.getMergedWidth();
        this.transferGivenWidthToRemainingWideNodeDummies(mergedWidth);
    }

    private double getMergedWidth() {
        double layerSpacing = this.graph.getProperty(LayeredOptions.SPACING_NODE_NODE_BETWEEN_LAYERS);
        double mergeWidth = 0.0;
        for (LNode dummy : this.dummiesToMerge) {
            mergeWidth += dummy.getSize().x + layerSpacing;
        }
        return mergeWidth;
    }

    private void transferGivenWidthToRemainingWideNodeDummies(double mergeWidth) {
        double widthPerDummy = mergeWidth / (double)this.remainingDummies.size();
        this.remainingDummies.forEach(d2 -> {
            double d3 = d2.getSize().x = d2.getSize().x + widthPerDummy;
        });
    }

    private void transferPortsToRemainingDummies() {
        this.transferWestPortsToRemainingDummies();
        this.transferToAndUpdateTopPortsOfRemainingDummies();
        this.remainingDummies.forEach(dummy -> dummy.cachePortSides());
    }

    private void transferWestPortsToRemainingDummies() {
        this.removeWestPorts(this.remainingDummies.get(0));
        this.transferWestPorts(this.dummiesToMerge.get(0), this.remainingDummies.get(0));
    }

    private void removeWestPorts(LNode node) {
        this.transferWestPorts(node, null);
    }

    private void transferWestPorts(LNode origNode, LNode newNode) {
        origNode.getPortsAsList(PortSide.WEST).forEach(p -> p.setNode(newNode));
    }

    private void transferToAndUpdateTopPortsOfRemainingDummies() {
        double layerSpacing = this.graph.getProperty(LayeredOptions.SPACING_NODE_NODE_BETWEEN_LAYERS);
        double effDummyWidth = layerSpacing + this.remainingDummies.get((int)0).getSize().x;
        this.remainingDummies.forEach(dummy -> this.transferTopPortsOfDummy((LNode)dummy, effDummyWidth));
        this.dummiesToMerge.forEach(dummy -> this.transferTopPortsOfDummy((LNode)dummy, effDummyWidth));
    }

    private void transferTopPortsOfDummy(LNode dummy, double effDummyWidth) {
        dummy.getPortsAsList(PortSide.NORTH).forEach(p -> this.transferTopPortOfDummy((LPort)p, dummy, effDummyWidth));
    }

    private void transferTopPortOfDummy(LPort topPort, LNode dummy, double effDummyWidth) {
        KVector portPos = topPort.getProperty(InternalProperties.ORIGINAL_PORT_POSITION);
        LNode newNodeOfTopPort = WideNodeSplitter.transferTopPort(topPort, this.remainingDummies, portPos, effDummyWidth);
        this.moveTopPortDummyToNewLayer(topPort, dummy, newNodeOfTopPort, this.remainingDummies.get(0));
    }

    private void moveTopPortDummyToNewLayer(LPort topPort, LNode origNodeOfTopPort, LNode newNodeOfTopPort, LNode firstRemainigDummy) {
        LNode portDummy = topPort.getProperty(InternalProperties.PORT_DUMMY);
        if (portDummy != null && newNodeOfTopPort != origNodeOfTopPort) {
            portDummy.setProperty(InternalProperties.ORIGIN, newNodeOfTopPort);
            Layer newLayer = newNodeOfTopPort.getLayer();
            int inLayerIxOfNewNode = newLayer.getNodes().indexOf(newNodeOfTopPort);
            portDummy.setLayer(inLayerIxOfNewNode, newLayer);
            this.splitIncomingEdgesOfMovedTopPortDummy(portDummy, origNodeOfTopPort, newNodeOfTopPort);
        }
    }

    private void splitIncomingEdgesOfMovedTopPortDummy(LNode portDummy, LNode origNodeOfTopPort, LNode newNodeOfTopPort) {
        for (LEdge edgeToSplit : portDummy.getIncomingEdges()) {
            this.splitIncomingEdgeOfMovedTopPortDummy(edgeToSplit, origNodeOfTopPort, newNodeOfTopPort);
        }
    }

    private void splitIncomingEdgeOfMovedTopPortDummy(LEdge edgeToSplit, LNode origNodeOfTopPort, LNode newNodeOfTopPort) {
        LNode currentWideNodeDummy = origNodeOfTopPort;
        LEdge currentEdgeToSplit = edgeToSplit;
        while (currentWideNodeDummy != newNodeOfTopPort) {
            Layer currentLayer = currentWideNodeDummy.getLayer();
            int indexOfCreatedDummyNodeInLayer = currentLayer.getNodes().indexOf(currentWideNodeDummy);
            currentEdgeToSplit = LongEdgeSplitter.splitEdge(currentEdgeToSplit, currentLayer, indexOfCreatedDummyNodeInLayer);
            currentWideNodeDummy = currentWideNodeDummy.getNextWideNodeDummy();
        }
    }

    private void handleLongWestEdges() {
        List<LPort> westPortsOfFirstRemainingDummy = this.getWestPortsOfFirstRemainingDummySortedBottomUp();
        for (LNode dummy : this.dummiesToMerge) {
            Layer layerOfDummy = dummy.getLayer();
            int indexOfCreatedDummyNodeInLayer = layerOfDummy.getNodes().indexOf(dummy);
            westPortsOfFirstRemainingDummy.forEach(p -> this.handleLongWestEdges((LPort)p, layerOfDummy, indexOfCreatedDummyNodeInLayer));
            westPortsOfFirstRemainingDummy.forEach(p -> this.handleWestWestEdgesToLongEdgeDummies((LPort)p));
        }
    }

    private void handleWestWestEdgesToLongEdgeDummies(LPort p) {
        p.getOutgoingEdges().stream().filter(e -> e.getTargetNode().getType().equals((Object)LNode.NodeType.LONG_EDGE)).forEach(e -> this.handleLongWestWestEdgeToLongEdgeDummy((LEdge)e));
    }

    private List<LPort> getWestPortsOfFirstRemainingDummySortedBottomUp() {
        LNode firstRemainingDummy = this.remainingDummies.get(0);
        List<LPort> westPortsSortedBottomUp = firstRemainingDummy.getPortsSortedTopToBottom(PortSide.WEST);
        Collections.reverse(westPortsSortedBottomUp);
        return westPortsSortedBottomUp;
    }

    private void handleLongWestEdges(LPort westPort, Layer layerOfDummy, int indexOfCreatedDummyNodeInLayer) {
        ArrayList<LEdge> incomingEdges = new ArrayList<LEdge>(westPort.getIncomingEdges());
        ArrayList<LEdge> outgoingEdges = new ArrayList<LEdge>(westPort.getOutgoingEdges());
        incomingEdges.forEach(e -> {
            LEdge lEdge = LongEdgeSplitter.splitEdge(e, layerOfDummy, indexOfCreatedDummyNodeInLayer);
        });
        outgoingEdges.forEach(e -> this.handleLongWestWestEdge((LEdge)e, layerOfDummy, indexOfCreatedDummyNodeInLayer));
    }

    private void handleLongWestWestEdge(LEdge edge, Layer layerOfDummy, int indexOfCreatedDummyNodeInLayer) {
        LNode targetNode = edge.getTargetNode();
        if (!targetNode.getType().equals((Object)LNode.NodeType.LONG_EDGE)) {
            this.handleLongWestWestEdgeToNormalNode(edge, layerOfDummy, indexOfCreatedDummyNodeInLayer);
        }
    }

    private void handleLongWestWestEdgeToLongEdgeDummy(LEdge edge) {
        LNode longEdgeDummy = edge.getTargetNode();
        List<LEdge> outgoingEdgesOfLongEdgeDummy = longEdgeDummy.getOutgoingEdgesAsList();
        assert (outgoingEdgesOfLongEdgeDummy.size() == 1);
        LEdge outgoingEdgeOfLongEdgeDummy = outgoingEdgesOfLongEdgeDummy.get(0);
        LPort targetPortOfLongEdgeDummy = outgoingEdgeOfLongEdgeDummy.getTarget();
        outgoingEdgeOfLongEdgeDummy.setSource(null);
        outgoingEdgeOfLongEdgeDummy.setTarget(null);
        longEdgeDummy.getLayer().getNodes().remove(longEdgeDummy);
        edge.setTarget(targetPortOfLongEdgeDummy);
    }

    private void handleLongWestWestEdgeToNormalNode(LEdge edge, Layer layerOfDummy, int indexOfCreatedDummyNodeInLayer) {
        edge.reverse(this.graph, false);
        LongEdgeSplitter.splitEdge(edge, layerOfDummy, indexOfCreatedDummyNodeInLayer);
    }

    private void removeDummiesToMerge() {
        this.dummiesToMerge.forEach(d -> {
            boolean bl = d.getLayer().getNodes().remove(d);
        });
        List<LNode> dummiesOfWideNode = this.dummiesToMerge.get(0).getWideNodeDummies();
        dummiesOfWideNode.removeAll(this.dummiesToMerge);
    }

    private void assertAllEdgesAreValid() {
        Stream edges = this.graph.getLayers().stream().flatMap(l -> l.getNodes().stream().flatMap(n -> n.getOutgoingEdgesAsList().stream()));
        edges.forEach(e -> WideNodeCrossingAvoider.assertEdgeIsValid(e));
    }

    private static void assertEdgeIsValid(LEdge e) {
        int sourceIx = e.getSourceNode().getLayer().getIndex();
        int targetIx = e.getTargetNode().getLayer().getIndex();
        assert (sourceIx == targetIx || sourceIx == targetIx - 1) : "source node " + e.getSourceNode() + " is in layer " + sourceIx + ", but target node " + e.getTargetNode() + " is in layer " + targetIx;
    }
}

