/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate.loops;

import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.loops.SelfLoopEdge;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.StreamSupport;

public class SelfLoopPort {
    private final LPort lPort;
    private final boolean hadOnlySelfLoops;
    private final List<SelfLoopEdge> incomingSLEdges = new ArrayList<SelfLoopEdge>();
    private final List<SelfLoopEdge> outgoingSLEdges = new ArrayList<SelfLoopEdge>();
    private boolean isHidden = false;

    SelfLoopPort(LPort lPort) {
        assert (lPort.getConnectedEdges().iterator().hasNext());
        this.lPort = lPort;
        this.hadOnlySelfLoops = StreamSupport.stream(lPort.getConnectedEdges().spliterator(), false).allMatch(edge -> edge.isSelfLoop());
    }

    public LPort getLPort() {
        return this.lPort;
    }

    public boolean hadOnlySelfLoops() {
        return this.hadOnlySelfLoops;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void setHidden(boolean hidden) {
        this.isHidden = hidden;
    }

    public List<SelfLoopEdge> getIncomingSLEdges() {
        return this.incomingSLEdges;
    }

    public List<SelfLoopEdge> getOutgoingSLEdges() {
        return this.outgoingSLEdges;
    }

    public int getSLNetFlow() {
        return this.incomingSLEdges.size() - this.outgoingSLEdges.size();
    }
}

