/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate.loops;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.modelengineers.MoRe_elk.alg.layered.graph.LLabel;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.loops.SelfHyperLoopLabels;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.loops.SelfLoopEdge;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.loops.SelfLoopHolder;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.loops.SelfLoopPort;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.loops.SelfLoopType;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SelfHyperLoop {
    private final SelfLoopHolder slHolder;
    private final List<SelfLoopPort> slPorts = new ArrayList<SelfLoopPort>();
    private final Set<SelfLoopEdge> slEdges = new HashSet<SelfLoopEdge>();
    private SelfHyperLoopLabels slLabels = null;
    private SelfLoopType selfLoopType;
    private ListMultimap<PortSide, SelfLoopPort> slPortsBySide;
    private SelfLoopPort leftmostPort = null;
    private SelfLoopPort rightmostPort = null;
    private final Set<PortSide> occupiedPortSides = EnumSet.noneOf(PortSide.class);
    private int[] routingSlot = new int[PortSide.values().length];

    SelfHyperLoop(SelfLoopHolder slHolder) {
        this.slHolder = slHolder;
    }

    public void computePortsPerSide() {
        assert (this.slPortsBySide == null);
        this.slPortsBySide = ArrayListMultimap.create((int)PortSide.values().length, (int)this.slPorts.size());
        for (SelfLoopPort slPort : this.slPorts) {
            PortSide portSide = slPort.getLPort().getSide();
            assert (portSide != PortSide.UNDEFINED);
            this.slPortsBySide.put((Object)portSide, (Object)slPort);
        }
        this.selfLoopType = SelfLoopType.fromPortSides(this.slPortsBySide.keySet());
    }

    public SelfLoopHolder getSLHolder() {
        return this.slHolder;
    }

    public void addSelfLoopEdge(SelfLoopEdge slEdge) {
        if (this.slEdges.add(slEdge)) {
            List<LLabel> lLabels;
            SelfLoopPort slTarget;
            slEdge.setSLHyperLoop(this);
            SelfLoopPort slSource = slEdge.getSLSource();
            if (!this.slPorts.contains(slSource)) {
                this.slPorts.add(slSource);
            }
            if (!this.slPorts.contains(slTarget = slEdge.getSLTarget())) {
                this.slPorts.add(slTarget);
            }
            if (!(lLabels = slEdge.getLEdge().getLabels()).isEmpty()) {
                if (this.slLabels == null) {
                    this.slLabels = new SelfHyperLoopLabels(this);
                }
                this.slLabels.addLLabels(lLabels);
            }
        }
    }

    public List<SelfLoopPort> getSLPorts() {
        return this.slPorts;
    }

    public Set<SelfLoopEdge> getSLEdges() {
        return this.slEdges;
    }

    public SelfHyperLoopLabels getSLLabels() {
        return this.slLabels;
    }

    public SelfLoopType getSelfLoopType() {
        return this.selfLoopType;
    }

    public Multimap<PortSide, SelfLoopPort> getSLPortsBySide() {
        return this.slPortsBySide;
    }

    public Collection<SelfLoopPort> getSLPortsBySide(PortSide portSide) {
        return this.slPortsBySide.get((Object)portSide);
    }

    public boolean hasSLPortsOnSide(PortSide portSide) {
        return this.slPortsBySide.containsKey((Object)portSide);
    }

    public SelfLoopPort getLeftmostPort() {
        return this.leftmostPort;
    }

    public void setLeftmostPort(SelfLoopPort leftmostPort) {
        this.leftmostPort = leftmostPort;
    }

    public SelfLoopPort getRightmostPort() {
        return this.rightmostPort;
    }

    public void setRightmostPort(SelfLoopPort rightmostPort) {
        this.rightmostPort = rightmostPort;
    }

    public Set<PortSide> getOccupiedPortSides() {
        return this.occupiedPortSides;
    }

    public int getRoutingSlot(PortSide portSide) {
        return this.routingSlot[portSide.ordinal()];
    }

    public void setRoutingSlot(PortSide portSide, int slot) {
        this.routingSlot[portSide.ordinal()] = slot;
        int[] slotCount = this.slHolder.getRoutingSlotCount();
        slotCount[portSide.ordinal()] = Math.max(slotCount[portSide.ordinal()], slot + 1);
    }
}

