/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate.adjustnodeheight;

import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.adjustnodeheight.HeightAdjustableNode;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.Spacings;
import com.modelengineers.MoRe_elk.alg.layered.p4nodes.mes.MesNodePlacer;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessor;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class NodeHeightAdjustmentProcessor
implements ILayoutProcessor<LGraph> {
    private static final int MIN_NUM_PORTS_HEIGHT_ADJUSTABLE = 5;

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Adjusting node heights", 1.0f);
        this.adjustNodeHeights(layeredGraph);
        progressMonitor.done();
    }

    private void adjustNodeHeights(LGraph layeredGraph) {
        List<HeightAdjustableNode> heightAdjustableNodes = this.getHeightAdjustableNodes(layeredGraph);
        this.adjustAccordingToConnectedLinearNodes(heightAdjustableNodes);
        this.furtherAdjustAccordingToAllConnectedNodes(heightAdjustableNodes);
    }

    private List<HeightAdjustableNode> getHeightAdjustableNodes(LGraph layeredGraph) {
        List<LNode> nodesToAdjust = this.getNodesToAdjust(layeredGraph);
        Spacings spacings = layeredGraph.getProperty(InternalProperties.SPACINGS);
        boolean newP4WillBeUsed = !MesNodePlacer.useOldVariant(layeredGraph);
        return nodesToAdjust.stream().map(node -> new HeightAdjustableNode((LNode)node, spacings, newP4WillBeUsed)).collect(Collectors.toList());
    }

    private List<LNode> getNodesToAdjust(LGraph layeredGraph) {
        List<LNode> potentiallyAdjustableNodes = this.getPotentiallyAdjustableNodes(layeredGraph);
        return potentiallyAdjustableNodes.stream().filter(this::nodeShouldBeAdjusted).collect(Collectors.toList());
    }

    private List<LNode> getPotentiallyAdjustableNodes(LGraph layeredGraph) {
        List<LNode> nodes = layeredGraph.getNodesFromAllLayers();
        List<LNode> allNodesWithDuplicatedLink = this.getAllNodesWithDuplicatedLink(nodes);
        nodes.removeAll(allNodesWithDuplicatedLink);
        return nodes;
    }

    private List<LNode> getAllNodesWithDuplicatedLink(List<LNode> nodes) {
        List trueNodes = nodes.stream().map(LNode::getTrueNode).distinct().collect(Collectors.toList());
        List trueNodesWithDuplicatedLink = trueNodes.stream().filter(e -> e.hasLink()).collect(Collectors.groupingBy(LNode::getLink)).values().stream().filter(list -> list.size() > 1).flatMap(Collection::stream).collect(Collectors.toList());
        return trueNodesWithDuplicatedLink.stream().map(LNode::getWideNodeDummiesOrNodeItself).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private boolean nodeShouldBeAdjusted(LNode node) {
        return !(node.isWideNode() && !node.isFirstWideNodeDummy() || !this.shouldBeAdjustedDueToTypeAndNoLink(node) && !this.shouldBeAdjustedDueToEnoughPorts(node));
    }

    private boolean shouldBeAdjustedDueToTypeAndNoLink(LNode node) {
        return this.hasValidBlockType(node) && !node.hasLink();
    }

    private boolean hasValidBlockType(LNode node) {
        String blockType = node.getMesBlockParam("BlockType");
        List<String> validBlockTypes = Arrays.asList("BusCreator", "BusSelector", "SubSystem", "Reference", "Demux", "Mux");
        return validBlockTypes.contains(blockType);
    }

    private boolean shouldBeAdjustedDueToEnoughPorts(LNode node) {
        return node.getTruePorts().size() >= 5;
    }

    private void adjustAccordingToConnectedLinearNodes(List<HeightAdjustableNode> heightAdjustableNodes) {
        boolean onlyConsiderLinearNodes = true;
        this.adjust(heightAdjustableNodes, onlyConsiderLinearNodes);
    }

    private void furtherAdjustAccordingToAllConnectedNodes(List<HeightAdjustableNode> heightAdjustableNodes) {
        boolean onlyConsiderLinearNodes = false;
        this.adjust(heightAdjustableNodes, onlyConsiderLinearNodes);
    }

    private void adjust(List<HeightAdjustableNode> heightAdjustableNodes, boolean onlyConsiderLinearNodes) {
        heightAdjustableNodes.forEach(heightAdjustableNode -> heightAdjustableNode.adjust(onlyConsiderLinearNodes));
    }
}

