/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate.adjustnodeheight;

import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.adjustnodeheight.HeightForPortPair;
import com.modelengineers.MoRe_elk.alg.layered.mesutils.MesUtilMethods;
import com.modelengineers.MoRe_elk.alg.layered.options.Spacings;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import com.modelengineers.MoRe_elk.core.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HeightAdjustableNode {
    private LNode node;
    private Spacings spacings;
    private boolean newP4WillBeUsed;
    private int originalHeight;
    private PortSide maxPortsSide;
    private PortSide minPortsSide;
    private List<LPort> maxPorts;
    private List<LPort> minPorts;
    private int numMaxPorts;
    private int numMinPorts;
    private Integer desiredHeight;
    private Integer newHeight = null;
    private int newPortSpacingOfMaxPorts;
    private int newPortSpacingOfMinPorts;
    private int newDistanceToUpperNodeEdgeOfMaxPorts;
    private int newDistanceToUpperNodeEdgeOfMinPorts;
    private int newDistanceToLowerNodeEdgeOfMaxPorts;
    private List<HeightForPortPair> heightsForPortPairs;

    public HeightAdjustableNode(LNode node, Spacings spacings, boolean newP4WillBeUsed) {
        this.node = node;
        this.spacings = spacings;
        this.newP4WillBeUsed = newP4WillBeUsed;
        this.maxPortsSide = node.getNumTrueEastPorts() > node.getNumTrueWestPorts() ? PortSide.EAST : PortSide.WEST;
        this.minPortsSide = this.maxPortsSide.opposed();
        this.maxPorts = node.getTruePortsSortedTopToBottom(this.maxPortsSide);
        this.minPorts = node.getTruePortsSortedTopToBottom(this.minPortsSide);
        this.numMaxPorts = this.maxPorts.size();
        this.numMinPorts = this.minPorts.size();
        this.originalHeight = (int)node.getTrueHeightWithoutLabelMargins();
        this.heightsForPortPairs = this.getHeightsForPortPairs();
    }

    public void adjust(boolean onlyConsiderLinearNodes) {
        int initialHeight = (int)this.node.getTrueHeightWithoutLabelMargins();
        this.computeAdjustmentValues(onlyConsiderLinearNodes, initialHeight);
        if (this.newHeight != null) {
            this.adjustNodeHeightAndPortPositions();
        }
    }

    private List<HeightForPortPair> getHeightsForPortPairs() {
        List<Pair<LPort, LPort>> portPairs = this.node.getTrueEastAndWestAdjacentPortPairsSortedTopToBottom();
        return portPairs.stream().map(portPair -> this.getHeightForPortPair((Pair<LPort, LPort>)portPair)).collect(Collectors.toList());
    }

    private HeightForPortPair getHeightForPortPair(Pair<LPort, LPort> portPair) {
        return new HeightForPortPair(portPair.getFirst(), portPair.getSecond(), this.originalHeight, this.spacings, this.newP4WillBeUsed);
    }

    public void computeAdjustmentValues(boolean onlyConsiderLinearNodes, int initialHeight) {
        this.computeDesiredHeight(onlyConsiderLinearNodes);
        if (this.desiredHeight != null && this.desiredHeight > initialHeight) {
            this.computeAdjustmentValuesCompatibleWithSimulinkGrid();
        }
    }

    private void computeDesiredHeight(boolean onlyConsiderLinearNodes) {
        this.heightsForPortPairs.forEach(h -> h.compute(onlyConsiderLinearNodes));
        this.desiredHeight = onlyConsiderLinearNodes ? this.getMaxHeight() : this.getLeastInvasiveHeight();
    }

    private Integer getMaxHeight() {
        return MesUtilMethods.getMaxOrNull(this.heightsForPortPairs.stream().map(h -> h.getHeight()).filter(h -> h != null));
    }

    private Integer getLeastInvasiveHeight() {
        List<Integer> heightsDeterminedBySingleNode = this.getFilteredHeights(this.heightsForPortPairs, true);
        List<Integer> heightsDeterminedByMultipleNodes = this.getFilteredHeights(this.heightsForPortPairs, false);
        if (!heightsDeterminedBySingleNode.isEmpty()) {
            return HeightAdjustableNode.getMinOfMostFrequentValues(heightsDeterminedBySingleNode);
        }
        return MesUtilMethods.getMaxOrNull(heightsDeterminedByMultipleNodes.stream());
    }

    private List<Integer> getFilteredHeights(List<HeightForPortPair> heights, boolean getHeightsDeterminedBySingleNode) {
        return heights.stream().filter(h -> h.getHeight() != null && h.heightIsDeterminedBySingleNode() == getHeightsDeterminedBySingleNode).map(h -> h.getHeight()).collect(Collectors.toList());
    }

    private static int getMinOfMostFrequentValues(List<Integer> list) {
        Map<Integer, Long> frequencyMap = list.stream().collect(Collectors.groupingBy(e -> e, Collectors.counting()));
        long maxFrequency = frequencyMap.values().stream().max(Long::compare).get();
        Stream<Integer> mostFrequentValues = frequencyMap.entrySet().stream().filter(entry -> (Long)entry.getValue() == maxFrequency).map(Map.Entry::getKey);
        return mostFrequentValues.min(Integer::compare).get();
    }

    private void computeAdjustmentValuesCompatibleWithSimulinkGrid() {
        this.newHeight = this.desiredHeight;
        this.computeAdjustmentValuesForNewHeight();
        while (!this.adjustmentValuesAreValid()) {
            this.newHeight = this.newHeight - 1;
            this.computeAdjustmentValuesForNewHeight();
        }
    }

    private void computeAdjustmentValuesForNewHeight() {
        this.computeAdjustmentValuesForMaxPorts();
        if (this.adjustmentValuesAreValid()) {
            this.computeAdjustmentValuesForMinPorts();
        }
    }

    private void computeAdjustmentValuesForMaxPorts() {
        this.newPortSpacingOfMaxPorts = this.getPortSpacingFromHeight(this.numMaxPorts);
        int spaceForUpperAndLowerNodeEdgeDistance = this.newHeight - this.newPortSpacingOfMaxPorts * (this.numMaxPorts - 1);
        this.newDistanceToUpperNodeEdgeOfMaxPorts = spaceForUpperAndLowerNodeEdgeDistance / 2;
        this.newDistanceToLowerNodeEdgeOfMaxPorts = spaceForUpperAndLowerNodeEdgeDistance - this.newDistanceToUpperNodeEdgeOfMaxPorts;
    }

    private boolean adjustmentValuesAreValid() {
        return this.newDistanceToUpperNodeEdgeOfMaxPorts == this.newDistanceToLowerNodeEdgeOfMaxPorts;
    }

    private void computeAdjustmentValuesForMinPorts() {
        if (this.numMinPorts > 0) {
            this.computeAdjustmentValuesForExistingMinPorts();
        }
    }

    private void computeAdjustmentValuesForExistingMinPorts() {
        if (this.numMinPorts == this.numMaxPorts) {
            this.newPortSpacingOfMinPorts = this.newPortSpacingOfMaxPorts;
            this.newDistanceToUpperNodeEdgeOfMinPorts = this.newDistanceToUpperNodeEdgeOfMaxPorts;
        } else {
            this.computeAdjustmentValuesForFewerMinPortsThanMaxPorts();
        }
    }

    private void computeAdjustmentValuesForFewerMinPortsThanMaxPorts() {
        this.newPortSpacingOfMinPorts = this.numMinPorts > 1 ? this.getPortSpacingFromHeight(this.numMinPorts) : 0;
        double idealNewDistanceToUpperNodeEdgeOfMinPorts = (double)(this.newHeight - (this.numMinPorts - 1) * this.newPortSpacingOfMinPorts) / 2.0;
        this.newDistanceToUpperNodeEdgeOfMinPorts = this.newDistanceToUpperNodeEdgeOfMaxPorts + MesUtilMethods.roundUpToMultipleOfFive(idealNewDistanceToUpperNodeEdgeOfMinPorts - (double)this.newDistanceToUpperNodeEdgeOfMaxPorts);
    }

    private int getPortSpacingFromHeight(int numPorts) {
        int portSpacingRoundedUp;
        double portSpacingUnrounded = this.newHeight / numPorts;
        int portSpacingRoundedDown = MesUtilMethods.roundDownToMultipleOfFive(portSpacingUnrounded);
        if (portSpacingRoundedDown == (portSpacingRoundedUp = MesUtilMethods.roundUpToMultipleOfFive(portSpacingUnrounded))) {
            return portSpacingRoundedDown;
        }
        if (portSpacingRoundedUp * (numPorts - 1) > this.newHeight) {
            return portSpacingRoundedDown;
        }
        return MesUtilMethods.roundDownToMultipleOfFive(portSpacingUnrounded + 2.0);
    }

    private void adjustNodeHeightAndPortPositions() {
        this.node.adjustTrueHeight(this.newHeight.intValue());
        this.adjustPortPositions();
    }

    private void adjustPortPositions() {
        this.adjustPortPositions(this.maxPortsSide, this.newPortSpacingOfMaxPorts, this.newDistanceToUpperNodeEdgeOfMaxPorts);
        this.adjustPortPositions(this.minPortsSide, this.newPortSpacingOfMinPorts, this.newDistanceToUpperNodeEdgeOfMinPorts);
    }

    private void adjustPortPositions(PortSide portSide, double portSpacing, double distanceToUpperNodeEdge) {
        List<LPort> ports = this.node.getTruePortsSortedTopToBottom(portSide);
        int ixPort = 0;
        while (ixPort < ports.size()) {
            ports.get((int)ixPort).getPosition().y = distanceToUpperNodeEdge + (double)ixPort * portSpacing;
            ++ixPort;
        }
    }
}

