/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate;

import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessor;
import com.modelengineers.MoRe_elk.core.options.PortConstraints;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;

public final class PortSideProcessor
implements ILayoutProcessor<LGraph> {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Port side processing", 1.0f);
        this.process(layeredGraph);
        assert (this.allPortsHaveFixedSide(layeredGraph));
        assert (this.allPortsHaveDefinedSide(layeredGraph));
        monitor.done();
    }

    private void process(LGraph layeredGraph) {
        for (LNode node : layeredGraph.getLayerlessNodes()) {
            this.process(node);
        }
        for (Layer layer : layeredGraph) {
            for (LNode node : layer) {
                this.process(node);
            }
        }
    }

    private void process(LNode node) {
        if (node.getProperty(LayeredOptions.PORT_CONSTRAINTS).isSideFixed()) {
            for (LPort port : node.getPorts()) {
                if (port.getSide() != PortSide.UNDEFINED) continue;
                PortSideProcessor.setPortSide(port);
            }
        } else {
            for (LPort port : node.getPorts()) {
                PortSideProcessor.setPortSide(port);
            }
            node.setProperty(LayeredOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_SIDE);
        }
    }

    public static void setPortSide(LPort port) {
        LNode portDummy = port.getProperty(InternalProperties.PORT_DUMMY);
        if (portDummy != null) {
            port.setSide(portDummy.getProperty(InternalProperties.EXT_PORT_SIDE));
        } else if (port.getNetFlow() < 0) {
            port.setSide(PortSide.EAST);
        } else {
            port.setSide(PortSide.WEST);
        }
    }

    public boolean allPortsHaveFixedSide(LGraph layeredGraph) {
        return layeredGraph.getNodesFromAllLayers().stream().allMatch(node -> node.getProperty(LayeredOptions.PORT_CONSTRAINTS).isSideFixed());
    }

    public boolean allPortsHaveDefinedSide(LGraph layeredGraph) {
        return layeredGraph.getNodesFromAllLayers().stream().flatMap(node -> node.getPorts().stream()).noneMatch(port -> port.getSide() == PortSide.UNDEFINED);
    }
}

