/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate;

import com.google.common.collect.Iterables;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessor;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;

public final class NodeWidthCorrector
implements ILayoutProcessor<LGraph> {
    private static final int SIMULINK_GRID_CONSTANT = 5;

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Inverted port preprocessing", 1.0f);
        this.findInvalidNodesAndAdjustWidth(layeredGraph);
        monitor.done();
    }

    private void findInvalidNodesAndAdjustWidth(LGraph layeredGraph) {
        for (LNode node : layeredGraph.getLayerlessNodes()) {
            if (!this.isInvalidNode(node)) continue;
            this.adjustWidth(node);
        }
    }

    private boolean isInvalidNode(LNode node) {
        return Iterables.size(node.getPorts(PortSide.NORTH)) == 1 && Iterables.size(node.getPorts(PortSide.SOUTH)) == 0 && node.getSize().x % 10.0 == 5.0 && node.getSize().x / 2.0 < node.getPorts((PortSide)PortSide.NORTH).iterator().next().getPosition().x;
    }

    private void adjustWidth(LNode node) {
        node.setProperty(InternalProperties.WIDTH_WAS_ADJUSTED, (Object)true);
        node.getSize().x += 5.0;
        for (LPort port : node.getPorts(PortSide.EAST)) {
            port.getPosition().x += 5.0;
        }
    }
}

