/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate;

import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LLabel;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessor;
import com.modelengineers.MoRe_elk.core.options.EdgeLabelPlacement;
import com.modelengineers.MoRe_elk.core.options.PortConstraints;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import java.util.ListIterator;

public final class LongEdgeSplitter
implements ILayoutProcessor<LGraph> {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Edge splitting", 1.0f);
        if (layeredGraph.getLayers().size() > 2) {
            this.splitLongEdges(layeredGraph);
            assert (this.noLongEdgesRemaining(layeredGraph));
        }
        monitor.done();
    }

    private void splitLongEdges(LGraph layeredGraph) {
        ListIterator<Layer> layerIter = layeredGraph.getLayers().listIterator();
        Layer nextLayer = layerIter.next();
        while (layerIter.hasNext()) {
            Layer layer = nextLayer;
            nextLayer = layerIter.next();
            for (LNode node : layer) {
                for (LPort port : node.getPorts()) {
                    for (LEdge edge : port.getOutgoingEdges()) {
                        LPort targetPort = edge.getTarget();
                        Layer targetLayer = targetPort.getNode().getLayer();
                        if (targetLayer == layer || targetLayer == nextLayer) continue;
                        assert (layerIter.hasNext());
                        this.splitEdge(edge, nextLayer);
                    }
                }
            }
        }
    }

    private void splitEdge(LEdge edge, Layer layerForNode) {
        LongEdgeSplitter.splitEdge(edge, layerForNode, layerForNode.getNodes().size());
    }

    public static LEdge splitEdge(LEdge edge, Layer layerForNode, int indexOfCreatedDummyNodeInLayer) {
        return LongEdgeSplitter.splitEdge(edge, LongEdgeSplitter.createDummyNode(layerForNode, edge, indexOfCreatedDummyNodeInLayer));
    }

    private static LNode createDummyNode(Layer targetLayer, LEdge edgeToSplit, int indexOfCreatedDummyNodeInLayer) {
        LNode dummyNode = new LNode(targetLayer.getGraph());
        dummyNode.setType(LNode.NodeType.LONG_EDGE);
        dummyNode.setProperty(InternalProperties.ORIGIN, edgeToSplit);
        dummyNode.setProperty(LayeredOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_POS);
        dummyNode.setLayer(indexOfCreatedDummyNodeInLayer, targetLayer);
        return dummyNode;
    }

    public static LEdge splitEdge(LEdge edge, LNode dummyNode) {
        LPort oldEdgeTarget = edge.getTarget();
        double thickness = edge.getProperty(LayeredOptions.EDGE_THICKNESS);
        if (thickness < 0.0) {
            thickness = 0.0;
            edge.setProperty(LayeredOptions.EDGE_THICKNESS, (Object)thickness);
        }
        dummyNode.getSize().y = thickness;
        double portPos = Math.floor(thickness / 2.0);
        LPort dummyInput = new LPort();
        dummyInput.setSide(PortSide.WEST);
        dummyInput.setNode(dummyNode);
        dummyInput.getPosition().y = portPos;
        LPort dummyOutput = new LPort();
        dummyOutput.setSide(PortSide.EAST);
        dummyOutput.setNode(dummyNode);
        dummyOutput.getPosition().y = portPos;
        edge.setTarget(dummyInput);
        LEdge dummyEdge = new LEdge();
        dummyEdge.copyProperties(edge);
        dummyEdge.setProperty(LayeredOptions.JUNCTION_POINTS, (Object)null);
        dummyEdge.setSource(dummyOutput);
        dummyEdge.setTarget(oldEdgeTarget);
        LongEdgeSplitter.setDummyNodeProperties(dummyNode, edge, dummyEdge);
        LongEdgeSplitter.moveHeadLabels(edge, dummyEdge);
        return dummyEdge;
    }

    private static void setDummyNodeProperties(LNode dummyNode, LEdge inEdge, LEdge outEdge) {
        LNode inEdgeSourceNode = inEdge.getSource().getNode();
        LNode outEdgeTargetNode = outEdge.getTarget().getNode();
        if (inEdgeSourceNode.getType() == LNode.NodeType.LONG_EDGE) {
            dummyNode.setProperty(InternalProperties.LONG_EDGE_SOURCE, inEdgeSourceNode.getProperty(InternalProperties.LONG_EDGE_SOURCE));
            dummyNode.setProperty(InternalProperties.LONG_EDGE_TARGET, inEdgeSourceNode.getProperty(InternalProperties.LONG_EDGE_TARGET));
            dummyNode.setProperty(InternalProperties.LONG_EDGE_HAS_LABEL_DUMMIES, inEdgeSourceNode.getProperty(InternalProperties.LONG_EDGE_HAS_LABEL_DUMMIES));
        } else if (inEdgeSourceNode.getType() == LNode.NodeType.LABEL) {
            dummyNode.setProperty(InternalProperties.LONG_EDGE_SOURCE, inEdgeSourceNode.getProperty(InternalProperties.LONG_EDGE_SOURCE));
            dummyNode.setProperty(InternalProperties.LONG_EDGE_TARGET, inEdgeSourceNode.getProperty(InternalProperties.LONG_EDGE_TARGET));
            dummyNode.setProperty(InternalProperties.LONG_EDGE_HAS_LABEL_DUMMIES, (Object)true);
        } else if (outEdgeTargetNode.getType() == LNode.NodeType.LABEL) {
            dummyNode.setProperty(InternalProperties.LONG_EDGE_SOURCE, outEdgeTargetNode.getProperty(InternalProperties.LONG_EDGE_SOURCE));
            dummyNode.setProperty(InternalProperties.LONG_EDGE_TARGET, outEdgeTargetNode.getProperty(InternalProperties.LONG_EDGE_TARGET));
            dummyNode.setProperty(InternalProperties.LONG_EDGE_HAS_LABEL_DUMMIES, (Object)true);
        } else {
            dummyNode.setProperty(InternalProperties.LONG_EDGE_SOURCE, inEdge.getSource());
            dummyNode.setProperty(InternalProperties.LONG_EDGE_TARGET, outEdge.getTarget());
        }
    }

    private static void moveHeadLabels(LEdge oldEdge, LEdge newEdge) {
        ListIterator<LLabel> labelIterator = oldEdge.getLabels().listIterator();
        while (labelIterator.hasNext()) {
            LLabel label = labelIterator.next();
            EdgeLabelPlacement labelPlacement = label.getProperty(LayeredOptions.EDGE_LABELS_PLACEMENT);
            if (labelPlacement != EdgeLabelPlacement.HEAD) continue;
            labelIterator.remove();
            newEdge.getLabels().add(label);
            if (label.hasProperty(InternalProperties.END_LABEL_EDGE)) continue;
            label.setProperty(InternalProperties.END_LABEL_EDGE, oldEdge);
        }
    }

    private boolean noLongEdgesRemaining(LGraph layeredGraph) {
        int nextLayerId = 0;
        for (Layer layer : layeredGraph) {
            layer.id = nextLayerId++;
        }
        for (Layer layer : layeredGraph) {
            for (LNode node : layer) {
                for (LEdge edge : node.getOutgoingEdges()) {
                    int layerDiffToTarget = edge.getTarget().getNode().getLayer().id - layer.id;
                    if (layerDiffToTarget >= 0 && layerDiffToTarget <= 1) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

