/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraphUtil;
import com.modelengineers.MoRe_elk.alg.layered.graph.LLabel;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.alg.layered.options.PortType;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessor;
import com.modelengineers.MoRe_elk.core.options.EdgeLabelPlacement;
import com.modelengineers.MoRe_elk.core.options.PortConstraints;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public final class InvertedPortProcessor
implements ILayoutProcessor<LGraph> {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Inverted port preprocessing", 1.0f);
        this.process(layeredGraph);
        assert (this.nodeOrderIsValid(layeredGraph));
        monitor.done();
    }

    private void process(LGraph layeredGraph) {
        List<Layer> layers = layeredGraph.getLayers();
        ListIterator<Layer> layerIterator = layers.listIterator();
        Layer currentLayer = null;
        ArrayList unassignedNodes = Lists.newArrayList();
        while (layerIterator.hasNext()) {
            Layer previousLayer = currentLayer;
            currentLayer = layerIterator.next();
            for (LNode node : unassignedNodes) {
                node.setLayer(previousLayer);
            }
            unassignedNodes.clear();
            for (LNode node : currentLayer) {
                LEdge edge;
                int n;
                int n2;
                LEdge[] lEdgeArray;
                LEdge[] edgeArray;
                List<LEdge> edges;
                if (node.getType() != LNode.NodeType.NORMAL && node.getType() != LNode.NodeType.WIDE_NODE || !node.getProperty(LayeredOptions.PORT_CONSTRAINTS).isSideFixed()) continue;
                for (LPort port : node.getPorts(PortType.INPUT, PortSide.EAST)) {
                    edges = port.getIncomingEdges();
                    lEdgeArray = edgeArray = LGraphUtil.toEdgeArray(edges);
                    n2 = edgeArray.length;
                    n = 0;
                    while (n < n2) {
                        edge = lEdgeArray[n];
                        if (layers.indexOf(edge.getSourceNode().getLayer()) < layers.indexOf(currentLayer)) {
                            this.createEastPortSideDummies(layeredGraph, port, edge, unassignedNodes);
                        }
                        ++n;
                    }
                }
                for (LPort port : node.getPorts(PortType.OUTPUT, PortSide.WEST)) {
                    edges = port.getOutgoingEdges();
                    lEdgeArray = edgeArray = LGraphUtil.toEdgeArray(edges);
                    n2 = edgeArray.length;
                    n = 0;
                    while (n < n2) {
                        edge = lEdgeArray[n];
                        if (layers.indexOf(edge.getTargetNode().getLayer()) > layers.indexOf(currentLayer)) {
                            this.createWestPortSideDummies(layeredGraph, port, edge, unassignedNodes);
                        }
                        ++n;
                    }
                }
            }
        }
        for (LNode node : unassignedNodes) {
            node.setLayer(currentLayer);
        }
    }

    private void createEastPortSideDummies(LGraph layeredGraph, LPort eastwardPort, LEdge edge, List<LNode> layerNodeList) {
        assert (edge.getTarget() == eastwardPort);
        if (edge.getSource().getNode() == eastwardPort.getNode()) {
            return;
        }
        LNode dummy = new LNode(layeredGraph);
        dummy.setType(LNode.NodeType.LONG_EDGE);
        dummy.setProperty(InternalProperties.ORIGIN, edge);
        dummy.setProperty(LayeredOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_POS);
        layerNodeList.add(dummy);
        LPort dummyInput = new LPort();
        dummyInput.setNode(dummy);
        dummyInput.setSide(PortSide.WEST);
        LPort dummyOutput = new LPort();
        dummyOutput.setNode(dummy);
        dummyOutput.setSide(PortSide.EAST);
        edge.setTarget(dummyInput);
        LEdge dummyEdge = new LEdge();
        dummyEdge.copyProperties(edge);
        dummyEdge.setProperty(LayeredOptions.JUNCTION_POINTS, (Object)null);
        dummyEdge.setSource(dummyOutput);
        dummyEdge.setTarget(eastwardPort);
        this.setLongEdgeSourceAndTarget(dummy, dummyInput, dummyOutput, eastwardPort);
        ListIterator<LLabel> labelIterator = edge.getLabels().listIterator();
        while (labelIterator.hasNext()) {
            LLabel label = labelIterator.next();
            EdgeLabelPlacement labelPlacement = label.getProperty(LayeredOptions.EDGE_LABELS_PLACEMENT);
            if (labelPlacement != EdgeLabelPlacement.HEAD) continue;
            if (!label.hasProperty(InternalProperties.END_LABEL_EDGE)) {
                label.setProperty(InternalProperties.END_LABEL_EDGE, edge);
            }
            labelIterator.remove();
            dummyEdge.getLabels().add(label);
        }
    }

    private void createWestPortSideDummies(LGraph layeredGraph, LPort westwardPort, LEdge edge, List<LNode> layerNodeList) {
        assert (edge.getSource() == westwardPort);
        if (edge.getTarget().getNode() == westwardPort.getNode()) {
            return;
        }
        LNode dummy = new LNode(layeredGraph);
        dummy.setType(LNode.NodeType.LONG_EDGE);
        dummy.setProperty(InternalProperties.ORIGIN, edge);
        dummy.setProperty(LayeredOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_POS);
        layerNodeList.add(dummy);
        LPort dummyInput = new LPort();
        dummyInput.setNode(dummy);
        dummyInput.setSide(PortSide.WEST);
        LPort dummyOutput = new LPort();
        dummyOutput.setNode(dummy);
        dummyOutput.setSide(PortSide.EAST);
        LPort originalTarget = edge.getTarget();
        edge.setTarget(dummyInput);
        LEdge dummyEdge = new LEdge();
        dummyEdge.copyProperties(edge);
        dummyEdge.setProperty(LayeredOptions.JUNCTION_POINTS, (Object)null);
        dummyEdge.setSource(dummyOutput);
        dummyEdge.setTarget(originalTarget);
        ListIterator<LLabel> labelIterator = edge.getLabels().listIterator();
        while (labelIterator.hasNext()) {
            LLabel label = labelIterator.next();
            if (label.getProperty(LayeredOptions.EDGE_LABELS_PLACEMENT) != EdgeLabelPlacement.HEAD) continue;
            assert (!label.hasProperty(InternalProperties.END_LABEL_EDGE));
            label.setProperty(InternalProperties.END_LABEL_EDGE, edge);
            labelIterator.remove();
            dummyEdge.getLabels().add(label);
        }
        this.setLongEdgeSourceAndTarget(dummy, dummyInput, dummyOutput, westwardPort);
    }

    private void setLongEdgeSourceAndTarget(LNode longEdgeDummy, LPort dummyInputPort, LPort dummyOutputPort, LPort oddPort) {
        LPort sourcePort = dummyInputPort.getIncomingEdges().get(0).getSource();
        LNode sourceNode = sourcePort.getNode();
        LNode.NodeType sourceNodeType = sourceNode.getType();
        LPort targetPort = dummyOutputPort.getOutgoingEdges().get(0).getTarget();
        LNode targetNode = targetPort.getNode();
        LNode.NodeType targetNodeType = targetNode.getType();
        if (sourceNodeType == LNode.NodeType.LONG_EDGE) {
            longEdgeDummy.setProperty(InternalProperties.LONG_EDGE_SOURCE, sourceNode.getProperty(InternalProperties.LONG_EDGE_SOURCE));
        } else {
            longEdgeDummy.setProperty(InternalProperties.LONG_EDGE_SOURCE, sourcePort);
        }
        if (targetNodeType == LNode.NodeType.LONG_EDGE) {
            longEdgeDummy.setProperty(InternalProperties.LONG_EDGE_TARGET, targetNode.getProperty(InternalProperties.LONG_EDGE_TARGET));
        } else {
            longEdgeDummy.setProperty(InternalProperties.LONG_EDGE_TARGET, targetPort);
        }
    }

    public boolean nodeOrderIsValid(LGraph layeredGraph) {
        for (Layer layer : layeredGraph) {
            for (LNode node : layer) {
                for (LEdge edge : node.getOutgoingEdges()) {
                    LNode target;
                    if (edge.getSource().getSide() != PortSide.WEST || (target = edge.getTarget().getNode()).getLayer().getIndex() == layer.getIndex()) continue;
                    return false;
                }
                for (LEdge edge : node.getIncomingEdges()) {
                    LNode source;
                    if (edge.getTarget().getSide() != PortSide.EAST || (source = edge.getSource().getNode()).getLayer().getIndex() == layer.getIndex()) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

