/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessor;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import com.modelengineers.MoRe_elk.core.util.feedbackloop.Finder;
import com.modelengineers.MoRe_elk.core.util.feedbackloop.IGraphAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class FeedbackLoopProcessor
implements ILayoutProcessor<LGraph> {
    private List<List<LNode>> feedbackLoops;

    @Override
    public void process(LGraph lGraph, IElkProgressMonitor progressMonitor) {
        this.findFeedbackLoops(lGraph);
        this.markElementsOfFoundFeedbackLoops();
    }

    private void findFeedbackLoops(LGraph lGraph) {
        Finder<LNode> feedbackLoopFinder = new Finder<LNode>(new LGraphAdapter(lGraph));
        this.feedbackLoops = feedbackLoopFinder.findAll();
    }

    private void markElementsOfFoundFeedbackLoops() {
        int feedbackLoopId = 0;
        for (List<LNode> feedbackLoop : this.feedbackLoops) {
            this.markElements(feedbackLoop, feedbackLoopId);
            ++feedbackLoopId;
        }
    }

    private void markElements(List<LNode> feedbackLoop, int feedbackLoopId) {
        this.markEdges(feedbackLoop, feedbackLoopId);
        this.markNodes(feedbackLoop, feedbackLoopId);
    }

    private void markEdges(List<LNode> feedbackLoop, int feedbackLoopId) {
        this.getEdges(feedbackLoop).forEach(edge -> {
            boolean bl = edge.getProperty(InternalProperties.FEEDBACK_LOOP_IDS).add(feedbackLoopId);
        });
    }

    private void markNodes(List<LNode> feedbackLoop, int feedbackLoopId) {
        feedbackLoop.forEach(nodeOfFeedbackLoop -> {
            boolean bl = nodeOfFeedbackLoop.getProperty(InternalProperties.FEEDBACK_LOOP_IDS).add(feedbackLoopId);
        });
    }

    private List<LEdge> getEdges(List<LNode> feedbackLoop) {
        ArrayList edgesOfFeedbackLoop = Lists.newArrayList();
        int i = 0;
        while (i < feedbackLoop.size()) {
            LNode source = feedbackLoop.get(i);
            LNode target = feedbackLoop.get((i + 1) % feedbackLoop.size());
            edgesOfFeedbackLoop.addAll(source.getOutgoingEdgesTo(target));
            ++i;
        }
        return edgesOfFeedbackLoop;
    }

    class LGraphAdapter
    implements IGraphAdapter<LNode> {
        private LGraph lGraph;

        LGraphAdapter(LGraph lGraph) {
            this.lGraph = lGraph;
        }

        @Override
        public List<LNode> getNodes() {
            return this.lGraph.getLayerlessNodes();
        }

        @Override
        public List<IGraphAdapter.Edge<LNode>> getEdges() {
            return this.lGraph.getLayerlessNodes().stream().flatMap(node -> node.getOutgoingEdgesAsList().stream()).map(outEdge -> new IGraphAdapter.Edge<LNode>(outEdge.getSourceNode(), outEdge.getTargetNode())).collect(Collectors.toList());
        }
    }
}

