/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate;

import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessor;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import java.util.List;
import java.util.stream.Collectors;

public final class DelayNodeOrientationSwitcher
implements ILayoutProcessor<LGraph> {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("nodeorientationadjustprocessor", 1.0f);
        this.switchDelayNodesOrientation(layeredGraph);
        progressMonitor.done();
    }

    private void switchDelayNodesOrientation(LGraph layeredGraph) {
        List<LNode> nodesThatNeedChangeInOrientation = this.getNodesThatNeedChangeInOrientation(layeredGraph);
        nodesThatNeedChangeInOrientation.forEach(n -> this.switchOrientation((LNode)n));
    }

    private List<LNode> getNodesThatNeedChangeInOrientation(LGraph layeredGraph) {
        return layeredGraph.getLayerlessNodes().stream().filter(n -> this.shouldNodeOrientationBeSwitched((LNode)n)).collect(Collectors.toList());
    }

    private boolean shouldNodeOrientationBeSwitched(LNode node) {
        return node.isDelayNode() && this.isNodeRightOriented(node) && this.hasOnlyOneInport(node) && node.hasOutgoingEdges() && node.allOutgoingEdgesArePartOfFeedbackLoops();
    }

    private boolean isNodeRightOriented(LNode node) {
        return node.getMesBlockParam("Orientation").equals("right");
    }

    private boolean hasOnlyOneInport(LNode node) {
        return node.getPortsAsList(PortSide.WEST).size() == 1;
    }

    private void switchOrientation(LNode node) {
        this.switchPortPositions(node);
        this.changeOrientationParams(node);
    }

    private void switchPortPositions(LNode node) {
        LPort outport = node.getTruePorts(PortSide.EAST).get(0);
        LPort inport = node.getTruePorts(PortSide.WEST).get(0);
        double newInportXPos = outport.getPosition().x;
        outport.getPosition().x = inport.getPosition().x;
        inport.getPosition().x = newInportXPos;
        outport.setSide(PortSide.WEST);
        inport.setSide(PortSide.EAST);
    }

    private void changeOrientationParams(LNode node) {
        node.setMesBlockParam("Orientation", "left");
        node.setProperty(InternalProperties.ORIENTATION_WAS_ADJUSTED, (Object)true);
    }
}

