/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate;

import com.modelengineers.MoRe_elk.alg.layered.DebugUtil;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessor;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;

public final class ConstraintsPostprocessor
implements ILayoutProcessor<LGraph> {
    @Override
    public void process(LGraph graph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Constraints Postprocessor", 1.0f);
        if (progressMonitor.isLoggingEnabled()) {
            DebugUtil.logDebugGraph(progressMonitor, graph, 0, "ConstraintPostProcessor");
        }
        int layerIndex = 0;
        for (Layer layer : graph.getLayers()) {
            int posIndex = 0;
            for (LNode currentNode : layer.getNodes()) {
                if (currentNode.getType() != LNode.NodeType.NORMAL) continue;
                currentNode.setProperty(LayeredOptions.LAYERING_LAYER_ID, (Object)layerIndex);
                currentNode.setProperty(LayeredOptions.CROSSING_MINIMIZATION_POSITION_ID, (Object)posIndex);
                ++posIndex;
            }
            ++layerIndex;
        }
        if (progressMonitor.isLoggingEnabled()) {
            DebugUtil.logDebugGraph(progressMonitor, graph, 0, "ConstraintPostProcessor");
        }
        progressMonitor.done();
    }
}

