/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.graph.transform;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraphUtil;
import com.modelengineers.MoRe_elk.alg.layered.graph.LLabel;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPadding;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.options.GraphProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.core.math.ElkPadding;
import com.modelengineers.MoRe_elk.core.math.KVector;
import com.modelengineers.MoRe_elk.core.math.KVectorChain;
import com.modelengineers.MoRe_elk.core.options.PortConstraints;
import com.modelengineers.MoRe_elk.core.options.PortLabelPlacement;
import com.modelengineers.MoRe_elk.core.options.SizeConstraint;
import com.modelengineers.MoRe_elk.core.options.SizeOptions;
import com.modelengineers.MoRe_elk.core.util.ElkUtil;
import com.modelengineers.MoRe_elk.graph.ElkConnectableShape;
import com.modelengineers.MoRe_elk.graph.ElkEdge;
import com.modelengineers.MoRe_elk.graph.ElkEdgeSection;
import com.modelengineers.MoRe_elk.graph.ElkLabel;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_elk.graph.ElkPort;
import com.modelengineers.MoRe_elk.graph.util.ElkGraphUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;

class ElkGraphLayoutTransferrer {
    private static final KVector ZERO_OFFSET = new KVector();

    ElkGraphLayoutTransferrer() {
    }

    public void applyLayout(LGraph lgraph) {
        Object graphOrigin = lgraph.getProperty(InternalProperties.ORIGIN);
        if (!(graphOrigin instanceof ElkNode)) {
            return;
        }
        ElkNode parentElkNode = (ElkNode)graphOrigin;
        LNode parentLNode = lgraph.getParentNode();
        KVector offset = new KVector(lgraph.getOffset());
        LPadding lPadding = lgraph.getPadding();
        offset.x += lPadding.left;
        offset.y += lPadding.top;
        EnumSet<SizeOptions> sizeOptions = parentElkNode.getProperty(LayeredOptions.NODE_SIZE_OPTIONS);
        if (sizeOptions.contains((Object)SizeOptions.COMPUTE_PADDING)) {
            ElkPadding padding = parentElkNode.getProperty(LayeredOptions.PADDING);
            padding.setBottom(lPadding.bottom);
            padding.setTop(lPadding.top);
            padding.setLeft(lPadding.left);
            padding.setRight(lPadding.right);
        }
        ArrayList edgeList = Lists.newArrayList();
        for (LNode lnode : lgraph.getLayerlessNodes()) {
            if (ElkGraphLayoutTransferrer.representsNode(lnode)) {
                this.applyNodeLayout(lnode, offset);
            } else if (ElkGraphLayoutTransferrer.representsExternalPort(lnode) && parentLNode == null) {
                ElkPort elkport = (ElkPort)lnode.getProperty(InternalProperties.ORIGIN);
                KVector portPosition = LGraphUtil.getExternalPortPosition(lgraph, lnode, elkport.getWidth(), elkport.getHeight());
                elkport.setLocation(portPosition.x, portPosition.y);
            }
            for (LPort port : lnode.getPorts()) {
                port.getOutgoingEdges().stream().filter(edge -> !LGraphUtil.isDescendant(edge.getTarget().getNode(), lnode)).forEach(edge -> {
                    boolean bl = edgeList.add(edge);
                });
            }
        }
        if (parentLNode != null) {
            for (LPort port : parentLNode.getPorts()) {
                port.getOutgoingEdges().stream().filter(edge -> LGraphUtil.isDescendant(edge.getTarget().getNode(), parentLNode)).forEach(edge -> {
                    boolean bl = edgeList.add(edge);
                });
            }
        }
        for (LEdge ledge : edgeList) {
            this.applyEdgeLayout(ledge, offset, lPadding);
        }
        this.applyParentNodeLayout(lgraph);
        for (LNode lnode : lgraph.getLayerlessNodes()) {
            LGraph nestedGraph = lnode.getNestedGraph();
            if (nestedGraph == null) continue;
            this.applyLayout(nestedGraph);
        }
    }

    private void applyNodeLayout(LNode lnode, KVector offset) {
        ElkNode elknode = (ElkNode)lnode.getProperty(InternalProperties.ORIGIN);
        int nodeID = lnode.getProperty(LayeredOptions.CROSSING_MINIMIZATION_POSITION_ID);
        int layerID = lnode.getProperty(LayeredOptions.LAYERING_LAYER_ID);
        elknode.setProperty(LayeredOptions.CROSSING_MINIMIZATION_POSITION_ID, nodeID);
        elknode.setProperty(LayeredOptions.LAYERING_LAYER_ID, layerID);
        elknode.setProperty(InternalProperties.WIDTH_WAS_ADJUSTED, lnode.getProperty(InternalProperties.WIDTH_WAS_ADJUSTED));
        elknode.setProperty(InternalProperties.HEIGHT_WAS_ADJUSTED, lnode.getProperty(InternalProperties.HEIGHT_WAS_ADJUSTED));
        elknode.setProperty(InternalProperties.ORIENTATION_WAS_ADJUSTED, lnode.getProperty(InternalProperties.ORIENTATION_WAS_ADJUSTED));
        elknode.setX(lnode.getPosition().x + offset.x);
        elknode.setY(lnode.getPosition().y + offset.y);
        if (!elknode.getProperty(LayeredOptions.NODE_SIZE_CONSTRAINTS).isEmpty() || lnode.getProperty(InternalProperties.WIDTH_WAS_ADJUSTED).booleanValue() || lnode.getProperty(InternalProperties.HEIGHT_WAS_ADJUSTED).booleanValue() || lnode.getNestedGraph() != null) {
            elknode.setWidth(lnode.getSize().x);
            elknode.setHeight(lnode.getSize().y);
        }
        for (LPort lport : lnode.getPorts()) {
            Object origin = lport.getProperty(InternalProperties.ORIGIN);
            if (!(origin instanceof ElkPort)) continue;
            ElkPort elkport = (ElkPort)origin;
            elkport.setLocation(lport.getPosition().x, lport.getPosition().y);
            elkport.setProperty(LayeredOptions.PORT_SIDE, lport.getSide());
        }
        boolean nodeHasLabelPlacement = !lnode.getProperty(LayeredOptions.NODE_LABELS_PLACEMENT).isEmpty();
        for (LLabel llabel : lnode.getLabels()) {
            if (!nodeHasLabelPlacement && llabel.getProperty(LayeredOptions.NODE_LABELS_PLACEMENT).isEmpty()) continue;
            ElkLabel elklabel = (ElkLabel)llabel.getProperty(InternalProperties.ORIGIN);
            elklabel.setDimensions(llabel.getSize().x, llabel.getSize().y);
            elklabel.setLocation(llabel.getPosition().x, llabel.getPosition().y);
        }
        if (lnode.getProperty(InternalProperties.HEIGHT_WAS_ADJUSTED).booleanValue()) {
            for (ElkLabel elkLabel : elknode.getLabels()) {
                elkLabel.setY(elkLabel.getY() + lnode.getHeightAdjustment());
            }
        }
        if (!PortLabelPlacement.isFixed((Set<PortLabelPlacement>)lnode.getProperty(LayeredOptions.PORT_LABELS_PLACEMENT))) {
            for (LPort lport : lnode.getPorts()) {
                for (LLabel llabel : lport.getLabels()) {
                    ElkLabel elklabel = (ElkLabel)llabel.getProperty(InternalProperties.ORIGIN);
                    elklabel.setWidth(llabel.getSize().x);
                    elklabel.setHeight(llabel.getSize().y);
                    elklabel.setLocation(llabel.getPosition().x, llabel.getPosition().y);
                }
            }
        }
    }

    private void applyEdgeLayout(LEdge ledge, KVector offset, LPadding additionalPadding) {
        KVector sourcePoint;
        ElkEdge elkedge = (ElkEdge)ledge.getProperty(InternalProperties.ORIGIN);
        if (elkedge == null) {
            return;
        }
        KVectorChain bendPoints = ledge.getBendPoints();
        KVector edgeOffset = new KVector(offset);
        edgeOffset.add(this.calculateHierarchicalOffset(ledge));
        if (LGraphUtil.isDescendant(ledge.getTarget().getNode(), ledge.getSource().getNode())) {
            LPort sourcePort = ledge.getSource();
            sourcePoint = KVector.sum(sourcePort.getPosition(), sourcePort.getAnchor());
            sourcePoint.sub(offset);
        } else {
            sourcePoint = ledge.getSource().getAbsoluteAnchor();
        }
        bendPoints.addFirst(sourcePoint);
        KVector targetPoint = ledge.getTarget().getAbsoluteAnchor();
        if (ledge.getProperty(InternalProperties.TARGET_OFFSET) != null) {
            targetPoint.add(ledge.getProperty(InternalProperties.TARGET_OFFSET));
        }
        bendPoints.addLast(targetPoint);
        bendPoints.offset(edgeOffset);
        ElkEdgeSection elkedgeSection = ElkGraphUtil.firstEdgeSection(elkedge, true, true);
        elkedgeSection.setIncomingShape((ElkConnectableShape)elkedge.getSources().get(0));
        elkedgeSection.setOutgoingShape((ElkConnectableShape)elkedge.getTargets().get(0));
        ElkUtil.applyVectorChain(bendPoints, elkedgeSection);
        for (LLabel llabel : ledge.getLabels()) {
            ElkLabel elklabel = (ElkLabel)llabel.getProperty(InternalProperties.ORIGIN);
            elklabel.setWidth(llabel.getSize().x);
            elklabel.setHeight(llabel.getSize().y);
            elklabel.setLocation(llabel.getPosition().x + edgeOffset.x, llabel.getPosition().y + edgeOffset.y);
        }
        KVectorChain junctionPoints = ledge.getProperty(LayeredOptions.JUNCTION_POINTS);
        if (junctionPoints != null) {
            junctionPoints.offset(edgeOffset);
            elkedge.setProperty(LayeredOptions.JUNCTION_POINTS, junctionPoints);
        } else {
            elkedge.setProperty(LayeredOptions.JUNCTION_POINTS, null);
        }
    }

    private KVector calculateHierarchicalOffset(LEdge ledge) {
        LGraph targetCoordinateSystem = ledge.getProperty(InternalProperties.COORDINATE_SYSTEM_ORIGIN);
        if (targetCoordinateSystem != null) {
            KVector result = new KVector();
            LGraph currentGraph = ledge.getSource().getNode().getGraph();
            while (currentGraph != targetCoordinateSystem) {
                LNode representingNode = currentGraph.getParentNode();
                currentGraph = representingNode.getGraph();
                result.add(representingNode.getPosition()).add(currentGraph.getOffset()).add(currentGraph.getPadding().left, currentGraph.getPadding().top);
            }
            return result;
        }
        return ZERO_OFFSET;
    }

    private void applyParentNodeLayout(LGraph lgraph) {
        ElkNode elknode = (ElkNode)lgraph.getProperty(InternalProperties.ORIGIN);
        boolean sizeConstraintsIncludedPortLabels = elknode.getProperty(LayeredOptions.NODE_SIZE_CONSTRAINTS).contains((Object)SizeConstraint.PORT_LABELS);
        if (lgraph.getParentNode() == null) {
            Set<GraphProperties> graphProps = lgraph.getProperty(InternalProperties.GRAPH_PROPERTIES);
            KVector actualGraphSize = lgraph.getActualSize();
            if (graphProps.contains((Object)GraphProperties.EXTERNAL_PORTS)) {
                elknode.setProperty(LayeredOptions.PORT_CONSTRAINTS, PortConstraints.FIXED_POS);
                ElkUtil.resizeNode(elknode, actualGraphSize.x, actualGraphSize.y, false, true);
            } else if (!elknode.getProperty(LayeredOptions.NODE_SIZE_FIXED_GRAPH_SIZE).booleanValue()) {
                ElkUtil.resizeNode(elknode, actualGraphSize.x, actualGraphSize.y, true, true);
            }
        }
        if (sizeConstraintsIncludedPortLabels) {
            elknode.setProperty(LayeredOptions.NODE_SIZE_CONSTRAINTS, EnumSet.of(SizeConstraint.PORT_LABELS));
        } else {
            elknode.setProperty(LayeredOptions.NODE_SIZE_CONSTRAINTS, SizeConstraint.fixed());
        }
    }

    private static boolean representsNode(LNode lnode) {
        return lnode.getProperty(InternalProperties.ORIGIN) instanceof ElkNode;
    }

    private static boolean representsExternalPort(LNode lnode) {
        return lnode.getProperty(InternalProperties.ORIGIN) instanceof ElkPort;
    }
}

