/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.graph;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.graph.Component;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraphElement;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraphUtil;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPadding;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.core.math.KVector;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;

public final class LGraph
extends LGraphElement
implements Iterable<Layer> {
    private static final long serialVersionUID = -8006835373897072852L;
    private final KVector size = new KVector();
    private final LPadding padding = new LPadding();
    private final KVector offset = new KVector();
    private final List<LNode> layerlessNodes = Lists.newArrayList();
    private final List<Layer> layers = Lists.newArrayList();
    private final List<Component> components = Lists.newArrayList();
    private LNode parentNode;
    private final List<LNode> originalWideNodes = Lists.newArrayList();

    public boolean loggingEnabled() {
        return this.getProperty(LayeredOptions.ENABLE_LOGGING_MES_MORE);
    }

    public KVector getSize() {
        return this.size;
    }

    public KVector getActualSize() {
        return new KVector(this.size.x + this.padding.left + this.padding.right, this.size.y + this.padding.top + this.padding.bottom);
    }

    public LPadding getPadding() {
        return this.padding;
    }

    public KVector getOffset() {
        return this.offset;
    }

    public List<LNode> getLayerlessNodes() {
        return this.layerlessNodes;
    }

    public long getNumTrueNodes() {
        return this.getLayers().stream().flatMap(l -> l.getNodes().stream()).filter(n -> !n.isWideNode() || n.isFirstWideNodeDummy()).count();
    }

    public List<LNode> getNodesFromAllLayers() {
        return this.getLayers().stream().flatMap(layer -> layer.getNodes().stream()).collect(Collectors.toList());
    }

    public List<LNode> getTrueNodesFromAllLayers() {
        return this.getNodesFromAllLayers().stream().map(n -> n.getTrueNode()).distinct().collect(Collectors.toList());
    }

    public List<Layer> getLayers() {
        return this.layers;
    }

    public List<Layer> getLayers(boolean forward) {
        if (forward) {
            return this.getLayers();
        }
        ArrayList<Layer> copy = new ArrayList<Layer>(this.getLayers());
        Collections.reverse(copy);
        return copy;
    }

    public Layer getFirstLayer() {
        return this.layers.isEmpty() ? null : this.layers.get(0);
    }

    public Layer getLastLayer() {
        return this.layers.isEmpty() ? null : this.layers.get(this.layers.size() - 1);
    }

    public List<Component> getComponents() {
        return this.components;
    }

    public LNode getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(LNode parentNode) {
        this.parentNode = parentNode;
    }

    public List<LNode> getOriginalWideNodes() {
        return this.originalWideNodes;
    }

    @Override
    public Iterator<Layer> iterator() {
        return this.layers.iterator();
    }

    public LNode[][] toNodeArray() {
        LNode[][] lgraphArray = new LNode[this.layers.size()][];
        ListIterator<Layer> layerIter = this.layers.listIterator();
        while (layerIter.hasNext()) {
            Layer layer = layerIter.next();
            int layerIndex = layerIter.previousIndex();
            lgraphArray[layerIndex] = LGraphUtil.toNodeArray(layer.getNodes());
        }
        return lgraphArray;
    }

    public String getFullSimulinkPath() {
        ElkNode elkOrigin = (ElkNode)this.getProperty(InternalProperties.ORIGIN);
        String identifierOfNode = ((ElkNode)elkOrigin.getChildren().get(0)).getIdentifier();
        if (identifierOfNode == null) {
            return "";
        }
        int lastSlashIndex = identifierOfNode.lastIndexOf("/");
        if (lastSlashIndex < 0) {
            return identifierOfNode;
        }
        return identifierOfNode.substring(0, lastSlashIndex).replaceAll("[\r\n]+", " ");
    }

    public boolean hasNodeOfMesBlockType(String blockType) {
        return this.getNodesFromAllLayers().stream().anyMatch(n -> n.isOfMesBlockType(blockType));
    }

    public void updateCachedTruePorts() {
        this.getNodesFromAllLayers().forEach(n -> n.cacheTruePorts());
    }

    public String toString() {
        if (this.layers.isEmpty()) {
            return "G-unlayered" + this.layerlessNodes.toString();
        }
        if (this.layerlessNodes.isEmpty()) {
            return "G-layered" + this.layers.toString();
        }
        return "G[layerless" + this.layerlessNodes.toString() + ", layers" + this.layers.toString() + "]";
    }
}

