/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered;

import com.modelengineers.MoRe_elk.alg.layered.LayeredPhases;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import com.modelengineers.MoRe_elk.alg.layered.options.CrossingMinimizationStrategy;
import com.modelengineers.MoRe_elk.alg.layered.options.GraphProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.GreedySwitchType;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeringStrategy;
import com.modelengineers.MoRe_elk.alg.layered.options.Spacings;
import com.modelengineers.MoRe_elk.alg.layered.p5edges.EdgeRouterFactory;
import com.modelengineers.MoRe_elk.core.alg.AlgorithmAssembler;
import com.modelengineers.MoRe_elk.core.alg.LayoutProcessorConfiguration;
import com.modelengineers.MoRe_elk.core.labels.LabelManagementOptions;
import com.modelengineers.MoRe_elk.core.options.HierarchyHandling;
import com.modelengineers.MoRe_elk.core.options.PortConstraints;
import java.util.Random;
import java.util.Set;

public final class GraphConfigurator {
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> BASELINE_PROCESSING_CONFIGURATION = LayoutProcessorConfiguration.create().addBefore(LayeredPhases.P1_CYCLE_BREAKING, IntermediateProcessorStrategy.NODE_WIDTH_CORRECTOR).addBefore(LayeredPhases.P4_NODE_PLACEMENT, IntermediateProcessorStrategy.INNERMOST_NODE_MARGIN_CALCULATOR).addBefore(LayeredPhases.P4_NODE_PLACEMENT, IntermediateProcessorStrategy.LABEL_AND_NODE_SIZE_PROCESSOR).addBefore(LayeredPhases.P5_EDGE_ROUTING, IntermediateProcessorStrategy.LAYER_SIZE_AND_GRAPH_HEIGHT_CALCULATOR);
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> LABEL_MANAGEMENT_ADDITIONS = LayoutProcessorConfiguration.create().addBefore(LayeredPhases.P4_NODE_PLACEMENT, IntermediateProcessorStrategy.END_NODE_PORT_LABEL_MANAGEMENT_PROCESSOR);
    private final AlgorithmAssembler<LayeredPhases, LGraph> algorithmAssembler = AlgorithmAssembler.create(LayeredPhases.class);
    private static final double MIN_EDGE_SPACING = 2.0;

    private void configureGraphProperties(LGraph lgraph) {
        Integer randomSeed;
        double edgeSpacing = lgraph.getProperty(LayeredOptions.SPACING_EDGE_EDGE);
        if (edgeSpacing < 2.0) {
            lgraph.setProperty(LayeredOptions.SPACING_EDGE_EDGE, (Object)2.0);
        }
        if ((randomSeed = lgraph.getProperty(LayeredOptions.RANDOM_SEED)) == 0) {
            lgraph.setProperty(InternalProperties.RANDOM, new Random());
        } else {
            lgraph.setProperty(InternalProperties.RANDOM, new Random(randomSeed.intValue()));
        }
        Boolean favorStraightness = lgraph.getProperty(LayeredOptions.NODE_PLACEMENT_FAVOR_STRAIGHT_EDGES);
        if (favorStraightness == null) {
            lgraph.setProperty(LayeredOptions.NODE_PLACEMENT_FAVOR_STRAIGHT_EDGES, (Object)true);
        }
        this.copyPortContraints(lgraph);
        Spacings spacings = new Spacings(lgraph);
        lgraph.setProperty(InternalProperties.SPACINGS, spacings);
    }

    private void copyPortContraints(LGraph lgraph) {
        lgraph.getLayerlessNodes().stream().forEach(lnode -> this.copyPortConstraints((LNode)lnode));
        lgraph.getLayers().stream().flatMap(layer -> layer.getNodes().stream()).forEach(lnode -> this.copyPortConstraints((LNode)lnode));
    }

    private void copyPortConstraints(LNode node) {
        PortConstraints originalPortconstraints = node.getProperty(LayeredOptions.PORT_CONSTRAINTS);
        node.setProperty(InternalProperties.ORIGINAL_PORT_CONSTRAINTS, (Object)originalPortconstraints);
        LGraph nestedGraph = node.getNestedGraph();
        if (nestedGraph != null) {
            this.copyPortContraints(nestedGraph);
        }
    }

    public void prepareGraphForLayout(LGraph lgraph) {
        this.configureGraphProperties(lgraph);
        this.algorithmAssembler.reset();
        this.algorithmAssembler.setPhase(LayeredPhases.P1_CYCLE_BREAKING, lgraph.getProperty(LayeredOptions.CYCLE_BREAKING_STRATEGY));
        this.algorithmAssembler.setPhase(LayeredPhases.P2_LAYERING, lgraph.getProperty(LayeredOptions.LAYERING_STRATEGY));
        this.algorithmAssembler.setPhase(LayeredPhases.P3_NODE_ORDERING, lgraph.getProperty(LayeredOptions.CROSSING_MINIMIZATION_STRATEGY));
        this.algorithmAssembler.setPhase(LayeredPhases.P4_NODE_PLACEMENT, lgraph.getProperty(LayeredOptions.NODE_PLACEMENT_STRATEGY));
        this.algorithmAssembler.setPhase(LayeredPhases.P5_EDGE_ROUTING, EdgeRouterFactory.factoryFor(lgraph.getProperty(LayeredOptions.EDGE_ROUTING)));
        this.algorithmAssembler.addProcessorConfiguration(this.getPhaseIndependentLayoutProcessorConfiguration(lgraph));
        lgraph.setProperty(InternalProperties.PROCESSORS, this.algorithmAssembler.build(lgraph));
    }

    private LayoutProcessorConfiguration<LayeredPhases, LGraph> getPhaseIndependentLayoutProcessorConfiguration(LGraph lgraph) {
        Set<GraphProperties> graphProperties = lgraph.getProperty(InternalProperties.GRAPH_PROPERTIES);
        LayoutProcessorConfiguration<LayeredPhases, LGraph> configuration = LayoutProcessorConfiguration.createFrom(BASELINE_PROCESSING_CONFIGURATION);
        if (!lgraph.getProperty(LayeredOptions.LAYERING_STRATEGY).equals(LayeringStrategy.INTERACTIVE)) {
            configuration.addBefore(LayeredPhases.P1_CYCLE_BREAKING, IntermediateProcessorStrategy.DELAY_NODE_ORIENTATION_SWITCHER);
        }
        configuration.addBefore(LayeredPhases.P3_NODE_ORDERING, IntermediateProcessorStrategy.PORT_SIDE_PROCESSOR);
        if (lgraph.getProperty(LabelManagementOptions.LABEL_MANAGER) != null) {
            configuration.addAll(LABEL_MANAGEMENT_ADDITIONS);
        }
        if (lgraph.getProperty(LayeredOptions.INTERACTIVE_LAYOUT).booleanValue() || lgraph.getProperty(LayeredOptions.GENERATE_POSITION_AND_LAYER_IDS).booleanValue()) {
            configuration.addAfter(LayeredPhases.P5_EDGE_ROUTING, IntermediateProcessorStrategy.CONSTRAINTS_POSTPROCESSOR);
        }
        if (graphProperties.contains((Object)GraphProperties.COMMENTS)) {
            configuration.addBefore(LayeredPhases.P1_CYCLE_BREAKING, IntermediateProcessorStrategy.COMMENT_PREPROCESSOR).addBefore(LayeredPhases.P4_NODE_PLACEMENT, IntermediateProcessorStrategy.COMMENT_NODE_MARGIN_CALCULATOR).addAfter(LayeredPhases.P5_EDGE_ROUTING, IntermediateProcessorStrategy.COMMENT_POSTPROCESSOR);
        }
        if (lgraph.getProperty(LayeredOptions.LAYERING_STRATEGY) == LayeringStrategy.MES_MORE) {
            configuration.addBefore(LayeredPhases.P2_LAYERING, IntermediateProcessorStrategy.WIDE_NODE_PREPROCESSOR);
            configuration.addAfter(LayeredPhases.P3_NODE_ORDERING, IntermediateProcessorStrategy.WIDE_NODE_CROSSING_AVOIDER);
            configuration.addAfter(LayeredPhases.P5_EDGE_ROUTING, IntermediateProcessorStrategy.WIDE_NODE_POSTPROCESSOR);
        }
        if (lgraph.getProperty(LayeredOptions.ADJUST_NODE_HEIGHTS).booleanValue()) {
            configuration.addBefore(LayeredPhases.P4_NODE_PLACEMENT, IntermediateProcessorStrategy.NODE_HEIGHT_ADJUSTMENT_PROCESSOR);
        }
        if (GraphConfigurator.activateGreedySwitchFor(lgraph)) {
            GreedySwitchType greedySwitchType = GraphConfigurator.isHierarchicalLayout(lgraph) ? lgraph.getProperty(LayeredOptions.CROSSING_MINIMIZATION_GREEDY_SWITCH_HIERARCHICAL_TYPE) : lgraph.getProperty(LayeredOptions.CROSSING_MINIMIZATION_GREEDY_SWITCH_TYPE);
            lgraph.setProperty(LayeredOptions.CROSSING_MINIMIZATION_GREEDY_SWITCH_TYPE, (Object)greedySwitchType);
        } else {
            lgraph.setProperty(LayeredOptions.CROSSING_MINIMIZATION_GREEDY_SWITCH_TYPE, (Object)GreedySwitchType.OFF);
        }
        return configuration;
    }

    public static boolean activateGreedySwitchFor(LGraph lgraph) {
        if (GraphConfigurator.isHierarchicalLayout(lgraph)) {
            return lgraph.getParentNode() == null && lgraph.getProperty(LayeredOptions.CROSSING_MINIMIZATION_GREEDY_SWITCH_HIERARCHICAL_TYPE) != GreedySwitchType.OFF;
        }
        GreedySwitchType greedySwitchType = lgraph.getProperty(LayeredOptions.CROSSING_MINIMIZATION_GREEDY_SWITCH_TYPE);
        boolean interactiveCrossMin = lgraph.getProperty(LayeredOptions.CROSSING_MINIMIZATION_STRATEGY) == CrossingMinimizationStrategy.INTERACTIVE;
        int activationThreshold = lgraph.getProperty(LayeredOptions.CROSSING_MINIMIZATION_GREEDY_SWITCH_ACTIVATION_THRESHOLD);
        int graphSize = lgraph.getLayerlessNodes().size();
        return !interactiveCrossMin && greedySwitchType != GreedySwitchType.OFF && (activationThreshold == 0 || activationThreshold > graphSize);
    }

    private static boolean isHierarchicalLayout(LGraph lgraph) {
        return lgraph.getProperty(LayeredOptions.HIERARCHY_HANDLING) == HierarchyHandling.INCLUDE_CHILDREN;
    }
}

