/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.common.polyomino.structures;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.common.polyomino.ProfileFill;
import com.modelengineers.MoRe_elk.alg.common.polyomino.structures.PlanarGrid;
import com.modelengineers.MoRe_elk.alg.common.polyomino.structures.Polyomino;
import com.modelengineers.MoRe_elk.graph.properties.MapPropertyHolder;
import java.util.List;

public class Polyominoes<P extends Polyomino>
extends MapPropertyHolder {
    private static final long serialVersionUID = -6003285848848775273L;
    private List<P> polys = Lists.newArrayList();
    private PlanarGrid grid;

    public Polyominoes(Iterable<P> polys, double aspectRatio) {
        this(polys, aspectRatio, false);
    }

    public Polyominoes(Iterable<P> polys, double aspectRatio, boolean fill) {
        int gridWidth = 0;
        int gridHeight = 0;
        for (Polyomino poly : polys) {
            if (fill) {
                ProfileFill.fillPolyomino(poly);
            }
            this.polys.add(poly);
            gridWidth += poly.getWidth();
            gridHeight += poly.getHeight();
        }
        if (this.polys.size() > 0) {
            Polyomino poly;
            poly = (Polyomino)this.polys.get(0);
            gridWidth += poly.getWidth();
            gridHeight += poly.getHeight();
        }
        gridWidth *= 2;
        gridHeight *= 2;
        if (aspectRatio > 1.0) {
            gridWidth = (int)Math.ceil((double)gridWidth * aspectRatio);
        } else {
            gridHeight = (int)Math.ceil((double)gridHeight / aspectRatio);
        }
        this.grid = new PlanarGrid(gridWidth, gridHeight);
    }

    public List<P> getPolyominoes() {
        return this.polys;
    }

    public PlanarGrid getGrid() {
        return this.grid;
    }
}

