/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.common.nodespacing.internal.algorithm;

import com.modelengineers.MoRe_elk.alg.common.nodespacing.cellsystem.LabelCell;
import com.modelengineers.MoRe_elk.alg.common.nodespacing.internal.NodeContext;
import com.modelengineers.MoRe_elk.alg.common.nodespacing.internal.PortContext;
import com.modelengineers.MoRe_elk.core.options.PortLabelPlacement;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import com.modelengineers.MoRe_elk.core.util.adapters.GraphAdapters;

public final class PortContextCreator {
    private PortContextCreator() {
    }

    public static void createPortContexts(NodeContext nodeContext, boolean ignoreInsidePortLabels) {
        boolean imPortLabels = !ignoreInsidePortLabels || !nodeContext.portLabelsPlacement.contains((Object)PortLabelPlacement.INSIDE);
        int volatileId = 0;
        for (GraphAdapters.PortAdapter<?> port : nodeContext.node.getPorts()) {
            if (port.getSide() == PortSide.UNDEFINED) {
                throw new IllegalArgumentException("Label and node size calculator can only be used with ports that have port sides assigned.");
            }
            port.setVolatileId(volatileId++);
            PortContextCreator.createPortContext(nodeContext, port, imPortLabels);
        }
    }

    private static void createPortContext(NodeContext nodeContext, GraphAdapters.PortAdapter<?> port, boolean imPortLabels) {
        PortContext portContext = new PortContext(nodeContext, port);
        nodeContext.portContexts.put((Object)port.getSide(), (Object)portContext);
        if (imPortLabels && !PortLabelPlacement.isFixed(nodeContext.portLabelsPlacement)) {
            portContext.portLabelCell = new LabelCell(nodeContext.labelLabelSpacing);
            port.getLabels().forEach(label -> portContext.portLabelCell.addLabel((GraphAdapters.LabelAdapter<?>)label));
        }
    }
}

