/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.common.nodespacing.internal.algorithm;

import com.modelengineers.MoRe_elk.alg.common.nodespacing.internal.NodeContext;
import com.modelengineers.MoRe_elk.alg.common.nodespacing.internal.algorithm.NodeLabelAndSizeUtilities;
import com.modelengineers.MoRe_elk.core.math.ElkRectangle;
import com.modelengineers.MoRe_elk.core.math.KVector;
import com.modelengineers.MoRe_elk.core.options.CoreOptions;
import com.modelengineers.MoRe_elk.core.options.PortConstraints;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import com.modelengineers.MoRe_elk.core.options.SizeConstraint;
import com.modelengineers.MoRe_elk.core.options.SizeOptions;

public final class NodeSizeCalculator {
    private NodeSizeCalculator() {
    }

    public static void setNodeWidth(NodeContext nodeContext) {
        double width;
        KVector nodeSize = nodeContext.nodeSize;
        if (NodeLabelAndSizeUtilities.areSizeConstraintsFixed(nodeContext)) {
            width = nodeSize.x;
        } else {
            KVector minNodeSize;
            width = nodeContext.nodeContainer.getMinimumWidth();
            if (nodeContext.sizeConstraints.contains((Object)SizeConstraint.NODE_LABELS) && !nodeContext.sizeOptions.contains((Object)SizeOptions.OUTSIDE_NODE_LABELS_OVERHANG)) {
                width = Math.max(width, nodeContext.outsideNodeLabelContainers.get((Object)PortSide.NORTH).getMinimumWidth());
                width = Math.max(width, nodeContext.outsideNodeLabelContainers.get((Object)PortSide.SOUTH).getMinimumWidth());
            }
            if ((minNodeSize = NodeLabelAndSizeUtilities.getMinimumNodeSize(nodeContext)) != null) {
                width = Math.max(width, minNodeSize.x);
            }
        }
        nodeSize.x = nodeContext.node.getGraph().getProperty(CoreOptions.NODE_SIZE_FIXED_GRAPH_SIZE) != false ? Math.max(nodeSize.x, width) : width;
        ElkRectangle nodeCellRectangle = nodeContext.nodeContainer.getCellRectangle();
        nodeCellRectangle.x = 0.0;
        nodeCellRectangle.width = width;
        nodeContext.nodeContainer.layoutChildrenHorizontally();
    }

    public static void setNodeHeight(NodeContext nodeContext) {
        double height;
        KVector nodeSize = nodeContext.nodeSize;
        if (NodeLabelAndSizeUtilities.areSizeConstraintsFixed(nodeContext)) {
            height = nodeSize.y;
        } else {
            KVector minNodeSize;
            height = nodeContext.nodeContainer.getMinimumHeight();
            if (nodeContext.sizeConstraints.contains((Object)SizeConstraint.NODE_LABELS) && !nodeContext.sizeOptions.contains((Object)SizeOptions.OUTSIDE_NODE_LABELS_OVERHANG)) {
                height = Math.max(height, nodeContext.outsideNodeLabelContainers.get((Object)PortSide.EAST).getMinimumHeight());
                height = Math.max(height, nodeContext.outsideNodeLabelContainers.get((Object)PortSide.WEST).getMinimumHeight());
            }
            if ((minNodeSize = NodeLabelAndSizeUtilities.getMinimumNodeSize(nodeContext)) != null) {
                height = Math.max(height, minNodeSize.y);
            }
            if (nodeContext.sizeConstraints.contains((Object)SizeConstraint.PORTS) && (nodeContext.portConstraints == PortConstraints.FIXED_RATIO || nodeContext.portConstraints == PortConstraints.FIXED_POS)) {
                height = Math.max(height, nodeContext.insidePortLabelCells.get((Object)PortSide.EAST).getMinimumHeight());
                height = Math.max(height, nodeContext.insidePortLabelCells.get((Object)PortSide.WEST).getMinimumHeight());
            }
        }
        nodeSize.y = nodeContext.node.getGraph().getProperty(CoreOptions.NODE_SIZE_FIXED_GRAPH_SIZE) != false ? Math.max(nodeSize.y, height) : height;
        ElkRectangle nodeCellRectangle = nodeContext.nodeContainer.getCellRectangle();
        nodeCellRectangle.y = 0.0;
        nodeCellRectangle.height = height;
        nodeContext.nodeContainer.layoutChildrenVertically();
    }
}

