/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.common.nodespacing.internal.algorithm;

import com.modelengineers.MoRe_elk.alg.common.nodespacing.cellsystem.ContainerArea;
import com.modelengineers.MoRe_elk.alg.common.nodespacing.cellsystem.GridContainerCell;
import com.modelengineers.MoRe_elk.alg.common.nodespacing.cellsystem.LabelCell;
import com.modelengineers.MoRe_elk.alg.common.nodespacing.cellsystem.StripContainerCell;
import com.modelengineers.MoRe_elk.alg.common.nodespacing.internal.NodeContext;
import com.modelengineers.MoRe_elk.alg.common.nodespacing.internal.NodeLabelLocation;
import com.modelengineers.MoRe_elk.core.options.CoreOptions;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import com.modelengineers.MoRe_elk.core.options.SizeOptions;
import com.modelengineers.MoRe_elk.core.util.adapters.GraphAdapters;
import java.util.Set;

public final class NodeLabelCellCreator {
    private NodeLabelCellCreator() {
    }

    public static void createNodeLabelCells(NodeContext nodeContext, boolean onlyInside, boolean horizontalLayoutMode) {
        NodeLabelCellCreator.createNodeLabelCellContainers(nodeContext, onlyInside);
        nodeContext.node.getLabels().forEach(label -> NodeLabelCellCreator.handleNodeLabel(nodeContext, label, onlyInside, horizontalLayoutMode));
    }

    private static void handleNodeLabel(NodeContext nodeContext, GraphAdapters.LabelAdapter<?> label, boolean onlyInside, boolean horizontalLayoutMode) {
        Set labelPlacement = label.hasProperty(CoreOptions.NODE_LABELS_PLACEMENT) ? (Set)label.getProperty(CoreOptions.NODE_LABELS_PLACEMENT) : nodeContext.nodeLabelPlacement;
        NodeLabelLocation labelLocation = NodeLabelLocation.fromNodeLabelPlacement(labelPlacement);
        if (labelLocation == NodeLabelLocation.UNDEFINED) {
            return;
        }
        if (onlyInside && !labelLocation.isInsideLocation()) {
            return;
        }
        NodeLabelCellCreator.retrieveNodeLabelCell(nodeContext, labelLocation, horizontalLayoutMode).addLabel(label);
    }

    private static void createNodeLabelCellContainers(NodeContext nodeContext, boolean onlyInside) {
        boolean symmetry = !nodeContext.sizeOptions.contains((Object)SizeOptions.ASYMMETRICAL);
        boolean tabularNodeLabels = nodeContext.sizeOptions.contains((Object)SizeOptions.FORCE_TABULAR_NODE_LABELS);
        nodeContext.insideNodeLabelContainer = new GridContainerCell(tabularNodeLabels, symmetry, nodeContext.labelCellSpacing);
        if (nodeContext.nodeLabelsPadding != null) {
            nodeContext.insideNodeLabelContainer.getPadding().copy(nodeContext.nodeLabelsPadding);
        }
        nodeContext.nodeContainerMiddleRow.setCell(ContainerArea.CENTER, nodeContext.insideNodeLabelContainer);
        if (!onlyInside) {
            StripContainerCell northContainer = new StripContainerCell(StripContainerCell.Strip.HORIZONTAL, symmetry, nodeContext.labelCellSpacing);
            northContainer.getPadding().bottom = nodeContext.nodeLabelSpacing;
            nodeContext.outsideNodeLabelContainers.put(PortSide.NORTH, northContainer);
            StripContainerCell southContainer = new StripContainerCell(StripContainerCell.Strip.HORIZONTAL, symmetry, nodeContext.labelCellSpacing);
            southContainer.getPadding().top = nodeContext.nodeLabelSpacing;
            nodeContext.outsideNodeLabelContainers.put(PortSide.SOUTH, southContainer);
            StripContainerCell westContainer = new StripContainerCell(StripContainerCell.Strip.VERTICAL, symmetry, nodeContext.labelCellSpacing);
            westContainer.getPadding().right = nodeContext.nodeLabelSpacing;
            nodeContext.outsideNodeLabelContainers.put(PortSide.WEST, westContainer);
            StripContainerCell eastContainer = new StripContainerCell(StripContainerCell.Strip.VERTICAL, symmetry, nodeContext.labelCellSpacing);
            eastContainer.getPadding().left = nodeContext.nodeLabelSpacing;
            nodeContext.outsideNodeLabelContainers.put(PortSide.EAST, eastContainer);
        }
    }

    private static LabelCell retrieveNodeLabelCell(NodeContext nodeContext, NodeLabelLocation nodeLabelLocation, boolean horizontalLayoutMode) {
        LabelCell nodeLabelCell = nodeContext.nodeLabelCells.get((Object)nodeLabelLocation);
        if (nodeLabelCell == null) {
            nodeLabelCell = new LabelCell(nodeContext.labelLabelSpacing, nodeLabelLocation, horizontalLayoutMode);
            nodeContext.nodeLabelCells.put(nodeLabelLocation, nodeLabelCell);
            if (nodeLabelLocation.isInsideLocation()) {
                nodeContext.insideNodeLabelContainer.setCell(nodeLabelLocation.getContainerRow(), nodeLabelLocation.getContainerColumn(), nodeLabelCell);
            } else {
                PortSide outsideSide = nodeLabelLocation.getOutsideSide();
                StripContainerCell containerCell = nodeContext.outsideNodeLabelContainers.get((Object)outsideSide);
                switch (outsideSide) {
                    case NORTH: 
                    case SOUTH: {
                        nodeLabelCell.setContributesToMinimumHeight(true);
                        containerCell.setCell(nodeLabelLocation.getContainerColumn(), nodeLabelCell);
                        break;
                    }
                    case EAST: 
                    case WEST: {
                        nodeLabelCell.setContributesToMinimumWidth(true);
                        containerCell.setCell(nodeLabelLocation.getContainerRow(), nodeLabelCell);
                    }
                }
            }
        }
        return nodeLabelCell;
    }
}

