/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.common.nodespacing.internal.algorithm;

import com.modelengineers.MoRe_elk.alg.common.nodespacing.cellsystem.AtomicCell;
import com.modelengineers.MoRe_elk.alg.common.nodespacing.cellsystem.ContainerArea;
import com.modelengineers.MoRe_elk.alg.common.nodespacing.cellsystem.StripContainerCell;
import com.modelengineers.MoRe_elk.alg.common.nodespacing.internal.NodeContext;
import com.modelengineers.MoRe_elk.alg.common.nodespacing.internal.PortContext;
import com.modelengineers.MoRe_elk.core.math.ElkPadding;
import com.modelengineers.MoRe_elk.core.math.KVector;
import com.modelengineers.MoRe_elk.core.options.PortLabelPlacement;
import com.modelengineers.MoRe_elk.core.options.PortSide;

public final class InsidePortLabelCellCreator {
    private InsidePortLabelCellCreator() {
    }

    public static void createInsidePortLabelCells(NodeContext nodeContext) {
        InsidePortLabelCellCreator.createInsidePortLabelCell(nodeContext, nodeContext.nodeContainer, ContainerArea.BEGIN, PortSide.NORTH);
        InsidePortLabelCellCreator.createInsidePortLabelCell(nodeContext, nodeContext.nodeContainer, ContainerArea.END, PortSide.SOUTH);
        InsidePortLabelCellCreator.createInsidePortLabelCell(nodeContext, nodeContext.nodeContainerMiddleRow, ContainerArea.BEGIN, PortSide.WEST);
        InsidePortLabelCellCreator.createInsidePortLabelCell(nodeContext, nodeContext.nodeContainerMiddleRow, ContainerArea.END, PortSide.EAST);
        InsidePortLabelCellCreator.setupNorthOrSouthPortLabelCell(nodeContext, PortSide.NORTH);
        InsidePortLabelCellCreator.setupNorthOrSouthPortLabelCell(nodeContext, PortSide.SOUTH);
        InsidePortLabelCellCreator.setupEastOrWestPortLabelCell(nodeContext, PortSide.EAST);
        InsidePortLabelCellCreator.setupEastOrWestPortLabelCell(nodeContext, PortSide.WEST);
    }

    private static void createInsidePortLabelCell(NodeContext nodeContext, StripContainerCell container, ContainerArea containerArea, PortSide portSide) {
        AtomicCell portLabelCell = new AtomicCell();
        container.setCell(containerArea, portLabelCell);
        nodeContext.insidePortLabelCells.put(portSide, portLabelCell);
    }

    private static void setupNorthOrSouthPortLabelCell(NodeContext nodeContext, PortSide portSide) {
        ElkPadding padding = nodeContext.insidePortLabelCells.get((Object)portSide).getPadding();
        switch (portSide) {
            case NORTH: {
                if (!(nodeContext.portLabelSpacingVertical >= 0.0)) break;
                padding.top = nodeContext.portLabelSpacingVertical;
                break;
            }
            case SOUTH: {
                if (!(nodeContext.portLabelSpacingVertical >= 0.0)) break;
                padding.bottom = nodeContext.portLabelSpacingVertical;
            }
        }
        if (nodeContext.surroundingPortMargins != null) {
            padding.left = nodeContext.surroundingPortMargins.left;
            padding.right = nodeContext.surroundingPortMargins.right;
        }
    }

    private static void setupEastOrWestPortLabelCell(NodeContext nodeContext, PortSide portSide) {
        if (nodeContext.portLabelsPlacement.contains((Object)PortLabelPlacement.INSIDE)) {
            InsidePortLabelCellCreator.calculateWidthDueToLabels(nodeContext, portSide);
        }
        InsidePortLabelCellCreator.setupTopAndBottomPadding(nodeContext, portSide);
    }

    private static void calculateWidthDueToLabels(NodeContext nodeContext, PortSide portSide) {
        AtomicCell theAppropriateCell = nodeContext.insidePortLabelCells.get((Object)portSide);
        KVector minCellSize = theAppropriateCell.getMinimumContentAreaSize();
        for (PortContext portContext : nodeContext.portContexts.get((Object)portSide)) {
            if (portContext.portLabelCell == null) continue;
            minCellSize.x = Math.max(minCellSize.x, portContext.portLabelCell.getMinimumWidth());
        }
        if (minCellSize.x > 0.0) {
            switch (portSide) {
                case EAST: {
                    theAppropriateCell.getPadding().right = nodeContext.portLabelSpacingHorizontal;
                    break;
                }
                case WEST: {
                    theAppropriateCell.getPadding().left = nodeContext.portLabelSpacingHorizontal;
                }
            }
        }
    }

    private static void setupTopAndBottomPadding(NodeContext nodeContext, PortSide portSide) {
        if (nodeContext.surroundingPortMargins != null) {
            ElkPadding padding = nodeContext.insidePortLabelCells.get((Object)portSide).getPadding();
            padding.top = nodeContext.surroundingPortMargins.top;
            padding.bottom = nodeContext.surroundingPortMargins.bottom;
        }
    }
}

