/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.common.nodespacing.internal;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.common.nodespacing.cellsystem.ContainerArea;
import com.modelengineers.MoRe_elk.alg.common.nodespacing.cellsystem.HorizontalLabelAlignment;
import com.modelengineers.MoRe_elk.alg.common.nodespacing.cellsystem.VerticalLabelAlignment;
import com.modelengineers.MoRe_elk.core.options.NodeLabelPlacement;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public enum NodeLabelLocation {
    OUT_T_L(HorizontalLabelAlignment.LEFT, VerticalLabelAlignment.BOTTOM, ContainerArea.BEGIN, ContainerArea.BEGIN, EnumSet.of(NodeLabelPlacement.OUTSIDE, NodeLabelPlacement.V_TOP, NodeLabelPlacement.H_LEFT)),
    OUT_T_C(HorizontalLabelAlignment.CENTER, VerticalLabelAlignment.BOTTOM, ContainerArea.BEGIN, ContainerArea.CENTER, EnumSet.of(NodeLabelPlacement.OUTSIDE, NodeLabelPlacement.V_TOP, NodeLabelPlacement.H_CENTER), EnumSet.of(NodeLabelPlacement.OUTSIDE, NodeLabelPlacement.V_TOP, NodeLabelPlacement.H_CENTER, NodeLabelPlacement.H_PRIORITY)),
    OUT_T_R(HorizontalLabelAlignment.RIGHT, VerticalLabelAlignment.BOTTOM, ContainerArea.BEGIN, ContainerArea.END, EnumSet.of(NodeLabelPlacement.OUTSIDE, NodeLabelPlacement.V_TOP, NodeLabelPlacement.H_RIGHT)),
    OUT_B_L(HorizontalLabelAlignment.LEFT, VerticalLabelAlignment.TOP, ContainerArea.END, ContainerArea.BEGIN, EnumSet.of(NodeLabelPlacement.OUTSIDE, NodeLabelPlacement.V_BOTTOM, NodeLabelPlacement.H_LEFT)),
    OUT_B_C(HorizontalLabelAlignment.CENTER, VerticalLabelAlignment.TOP, ContainerArea.END, ContainerArea.CENTER, EnumSet.of(NodeLabelPlacement.OUTSIDE, NodeLabelPlacement.V_BOTTOM, NodeLabelPlacement.H_CENTER), EnumSet.of(NodeLabelPlacement.OUTSIDE, NodeLabelPlacement.V_BOTTOM, NodeLabelPlacement.H_CENTER, NodeLabelPlacement.H_PRIORITY)),
    OUT_B_R(HorizontalLabelAlignment.RIGHT, VerticalLabelAlignment.TOP, ContainerArea.END, ContainerArea.END, EnumSet.of(NodeLabelPlacement.OUTSIDE, NodeLabelPlacement.V_BOTTOM, NodeLabelPlacement.H_RIGHT)),
    OUT_L_T(HorizontalLabelAlignment.RIGHT, VerticalLabelAlignment.TOP, ContainerArea.BEGIN, ContainerArea.BEGIN, EnumSet.of(NodeLabelPlacement.OUTSIDE, NodeLabelPlacement.H_LEFT, NodeLabelPlacement.V_TOP, NodeLabelPlacement.H_PRIORITY)),
    OUT_L_C(HorizontalLabelAlignment.RIGHT, VerticalLabelAlignment.CENTER, ContainerArea.CENTER, ContainerArea.BEGIN, EnumSet.of(NodeLabelPlacement.OUTSIDE, NodeLabelPlacement.H_LEFT, NodeLabelPlacement.V_CENTER), EnumSet.of(NodeLabelPlacement.OUTSIDE, NodeLabelPlacement.H_LEFT, NodeLabelPlacement.V_CENTER, NodeLabelPlacement.H_PRIORITY)),
    OUT_L_B(HorizontalLabelAlignment.RIGHT, VerticalLabelAlignment.BOTTOM, ContainerArea.END, ContainerArea.BEGIN, EnumSet.of(NodeLabelPlacement.OUTSIDE, NodeLabelPlacement.H_LEFT, NodeLabelPlacement.V_BOTTOM, NodeLabelPlacement.H_PRIORITY)),
    OUT_R_T(HorizontalLabelAlignment.LEFT, VerticalLabelAlignment.TOP, ContainerArea.BEGIN, ContainerArea.END, EnumSet.of(NodeLabelPlacement.OUTSIDE, NodeLabelPlacement.H_RIGHT, NodeLabelPlacement.V_TOP, NodeLabelPlacement.H_PRIORITY)),
    OUT_R_C(HorizontalLabelAlignment.LEFT, VerticalLabelAlignment.CENTER, ContainerArea.CENTER, ContainerArea.END, EnumSet.of(NodeLabelPlacement.OUTSIDE, NodeLabelPlacement.H_RIGHT, NodeLabelPlacement.V_CENTER), EnumSet.of(NodeLabelPlacement.OUTSIDE, NodeLabelPlacement.H_RIGHT, NodeLabelPlacement.V_CENTER, NodeLabelPlacement.H_PRIORITY)),
    OUT_R_B(HorizontalLabelAlignment.LEFT, VerticalLabelAlignment.BOTTOM, ContainerArea.END, ContainerArea.END, EnumSet.of(NodeLabelPlacement.OUTSIDE, NodeLabelPlacement.H_RIGHT, NodeLabelPlacement.V_BOTTOM, NodeLabelPlacement.H_PRIORITY)),
    IN_T_L(HorizontalLabelAlignment.LEFT, VerticalLabelAlignment.TOP, ContainerArea.BEGIN, ContainerArea.BEGIN, EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_TOP, NodeLabelPlacement.H_LEFT), EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_TOP, NodeLabelPlacement.H_LEFT, NodeLabelPlacement.H_PRIORITY)),
    IN_T_C(HorizontalLabelAlignment.CENTER, VerticalLabelAlignment.TOP, ContainerArea.BEGIN, ContainerArea.CENTER, EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_TOP, NodeLabelPlacement.H_CENTER), EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_TOP, NodeLabelPlacement.H_CENTER, NodeLabelPlacement.H_PRIORITY)),
    IN_T_R(HorizontalLabelAlignment.RIGHT, VerticalLabelAlignment.TOP, ContainerArea.BEGIN, ContainerArea.END, EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_TOP, NodeLabelPlacement.H_RIGHT), EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_TOP, NodeLabelPlacement.H_RIGHT, NodeLabelPlacement.H_PRIORITY)),
    IN_C_L(HorizontalLabelAlignment.LEFT, VerticalLabelAlignment.CENTER, ContainerArea.CENTER, ContainerArea.BEGIN, EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_CENTER, NodeLabelPlacement.H_LEFT), EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_CENTER, NodeLabelPlacement.H_LEFT, NodeLabelPlacement.H_PRIORITY)),
    IN_C_C(HorizontalLabelAlignment.CENTER, VerticalLabelAlignment.CENTER, ContainerArea.CENTER, ContainerArea.CENTER, EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_CENTER, NodeLabelPlacement.H_CENTER), EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_CENTER, NodeLabelPlacement.H_CENTER, NodeLabelPlacement.H_PRIORITY)),
    IN_C_R(HorizontalLabelAlignment.RIGHT, VerticalLabelAlignment.CENTER, ContainerArea.CENTER, ContainerArea.END, EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_CENTER, NodeLabelPlacement.H_RIGHT), EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_CENTER, NodeLabelPlacement.H_RIGHT, NodeLabelPlacement.H_PRIORITY)),
    IN_B_L(HorizontalLabelAlignment.LEFT, VerticalLabelAlignment.BOTTOM, ContainerArea.END, ContainerArea.BEGIN, EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_BOTTOM, NodeLabelPlacement.H_LEFT), EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_BOTTOM, NodeLabelPlacement.H_LEFT, NodeLabelPlacement.H_PRIORITY)),
    IN_B_C(HorizontalLabelAlignment.CENTER, VerticalLabelAlignment.BOTTOM, ContainerArea.END, ContainerArea.CENTER, EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_BOTTOM, NodeLabelPlacement.H_CENTER), EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_BOTTOM, NodeLabelPlacement.H_CENTER, NodeLabelPlacement.H_PRIORITY)),
    IN_B_R(HorizontalLabelAlignment.RIGHT, VerticalLabelAlignment.BOTTOM, ContainerArea.END, ContainerArea.END, EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_BOTTOM, NodeLabelPlacement.H_RIGHT), EnumSet.of(NodeLabelPlacement.INSIDE, NodeLabelPlacement.V_BOTTOM, NodeLabelPlacement.H_RIGHT, NodeLabelPlacement.H_PRIORITY)),
    UNDEFINED(null, null, null, null, new Set[0]);

    private final List<? extends Set<NodeLabelPlacement>> assignedPlacements;
    private final HorizontalLabelAlignment horizontalAlignment;
    private final VerticalLabelAlignment verticalAlignment;
    private final ContainerArea containerRow;
    private final ContainerArea containerColumn;

    private NodeLabelLocation(HorizontalLabelAlignment horizontalAlignment, VerticalLabelAlignment verticalAlignment, ContainerArea row, ContainerArea column, Set<NodeLabelPlacement> ... assignedPlacements) {
        this.horizontalAlignment = horizontalAlignment;
        this.verticalAlignment = verticalAlignment;
        this.containerRow = row;
        this.containerColumn = column;
        this.assignedPlacements = Lists.newArrayList((Object[])assignedPlacements);
    }

    public static NodeLabelLocation fromNodeLabelPlacement(Set<NodeLabelPlacement> labelPlacement) {
        NodeLabelLocation[] nodeLabelLocationArray = NodeLabelLocation.values();
        int n = nodeLabelLocationArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeLabelLocation location = nodeLabelLocationArray[n2];
            if (location.assignedPlacements.contains(labelPlacement)) {
                return location;
            }
            ++n2;
        }
        return UNDEFINED;
    }

    public HorizontalLabelAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public VerticalLabelAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public ContainerArea getContainerRow() {
        return this.containerRow;
    }

    public ContainerArea getContainerColumn() {
        return this.containerColumn;
    }

    public boolean isInsideLocation() {
        switch (this) {
            case IN_T_L: 
            case IN_T_C: 
            case IN_T_R: 
            case IN_C_L: 
            case IN_C_C: 
            case IN_C_R: 
            case IN_B_L: 
            case IN_B_C: 
            case IN_B_R: {
                return true;
            }
        }
        return false;
    }

    public PortSide getOutsideSide() {
        switch (this) {
            case OUT_T_L: 
            case OUT_T_C: 
            case OUT_T_R: {
                return PortSide.NORTH;
            }
            case OUT_B_L: 
            case OUT_B_C: 
            case OUT_B_R: {
                return PortSide.SOUTH;
            }
            case OUT_L_T: 
            case OUT_L_C: 
            case OUT_L_B: {
                return PortSide.WEST;
            }
            case OUT_R_T: 
            case OUT_R_C: 
            case OUT_R_B: {
                return PortSide.EAST;
            }
        }
        return PortSide.UNDEFINED;
    }
}

