/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.common.compaction.oned;

import com.modelengineers.MoRe_elk.alg.common.compaction.oned.CNode;
import com.modelengineers.MoRe_elk.alg.common.compaction.oned.CompareFuzzy;
import com.modelengineers.MoRe_elk.alg.common.compaction.oned.IConstraintCalculationAlgorithm;
import com.modelengineers.MoRe_elk.alg.common.compaction.oned.OneDimensionalCompactor;

public class QuadraticConstraintCalculation
implements IConstraintCalculationAlgorithm {
    @Override
    public void calculateConstraints(OneDimensionalCompactor compactor) {
        for (CNode cNode : compactor.cGraph.cNodes) {
            cNode.constraints.clear();
        }
        for (CNode cNode1 : compactor.cGraph.cNodes) {
            for (CNode cNode2 : compactor.cGraph.cNodes) {
                if (cNode1 == cNode2 || cNode1.cGroup != null && cNode1.cGroup == cNode2.cGroup) continue;
                double spacing = compactor.direction.isHorizontal() ? compactor.spacingsHandler.getVerticalSpacing(cNode1, cNode2) : compactor.spacingsHandler.getHorizontalSpacing(cNode1, cNode2);
                if (!(cNode2.hitbox.x > cNode1.hitbox.x) && (cNode1.hitbox.x != cNode2.hitbox.x || !(cNode1.hitbox.width < cNode2.hitbox.width)) || !CompareFuzzy.gt(cNode2.hitbox.y + cNode2.hitbox.height + spacing, cNode1.hitbox.y) || !CompareFuzzy.lt(cNode2.hitbox.y, cNode1.hitbox.y + cNode1.hitbox.height + spacing)) continue;
                cNode1.constraints.add(cNode2);
            }
        }
    }
}

