/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.common.compaction.oned;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.common.compaction.oned.CGraph;
import com.modelengineers.MoRe_elk.alg.common.compaction.oned.CGroup;
import com.modelengineers.MoRe_elk.core.math.ElkRectangle;
import com.modelengineers.MoRe_elk.core.math.KVector;
import java.util.List;
import java.util.function.Function;

public final class CNode {
    public int id;
    public Object origin;
    public String type;
    public Function<CNode, String> toStringDelegate;
    public CGroup cGroup;
    public KVector cGroupOffset = new KVector();
    public ElkRectangle hitboxPreCompaction;
    public ElkRectangle hitbox;
    public List<CNode> constraints = Lists.newArrayList();
    public double startPos = Double.NEGATIVE_INFINITY;

    private CNode() {
    }

    public static CNodeBuilder of() {
        return new CNodeBuilder();
    }

    public String getDebugSVG() {
        StringBuffer sb = new StringBuffer();
        sb.append("<rect x=\"" + this.hitbox.x + "\" y=\"" + this.hitbox.y + "\" width=\"" + Math.max(1.0, this.hitbox.width) + "\" height=\"" + Math.max(1.0, this.hitbox.height) + "\" fill=\"" + "green" + "\" stroke=\"black\" opacity=\"0.5\"/>");
        sb.append("<text x=\"" + (this.hitbox.x + 2.0) + "\" y=\"" + (this.hitbox.y + 8.0 + 2.0 + 1.0) + "\">" + "(" + Math.round(this.hitbox.x) + ", " + Math.round(this.hitbox.y) + ")\n" + this + "</text>");
        return sb.toString();
    }

    public String toString() {
        if (this.toStringDelegate != null) {
            return this.toStringDelegate.apply(this);
        }
        return super.toString();
    }

    /* synthetic */ CNode(CNode cNode) {
        this();
    }

    public static final class CNodeBuilder {
        private CNode node = new CNode(null);
        private CNode groupParent;

        private CNodeBuilder() {
        }

        public CNodeBuilder id(int id) {
            this.node.id = id;
            return this;
        }

        public CNodeBuilder origin(Object origin) {
            this.node.origin = origin;
            return this;
        }

        public CNodeBuilder type(String type) {
            this.node.type = type;
            return this;
        }

        public CNodeBuilder hitbox(ElkRectangle hitbox) {
            this.node.hitbox = hitbox;
            return this;
        }

        public CNodeBuilder toStringDelegate(Function<CNode, String> delegate) {
            this.node.toStringDelegate = delegate;
            return this;
        }

        public CNodeBuilder groupWith(CNode parent) {
            this.groupParent = parent;
            return this;
        }

        public CNode create(CGraph graph) {
            graph.cNodes.add(this.node);
            if (this.groupParent != null) {
                if (this.groupParent.cGroup == null) {
                    CGroup.of().nodes(this.groupParent, this.node).create(graph);
                } else {
                    this.groupParent.cGroup.addCNode(this.node);
                }
            }
            return this.node;
        }
    }
}

