/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe;

import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class TreeFilter {
    private final DefaultMutableTreeNode rootNodeOfUnfilteredTree;

    public TreeFilter(DefaultMutableTreeNode rootNodeOfUnfilteredTree) {
        this.rootNodeOfUnfilteredTree = rootNodeOfUnfilteredTree;
    }

    public DefaultMutableTreeNode filter(FilterCondition filterCondition) {
        DefaultMutableTreeNode rootNodeOfFilteredTree = new DefaultMutableTreeNode(this.rootNodeOfUnfilteredTree.getUserObject());
        this.filterRecursively(this.rootNodeOfUnfilteredTree, rootNodeOfFilteredTree, filterCondition);
        return rootNodeOfFilteredTree;
    }

    private void filterRecursively(DefaultMutableTreeNode parentNodeInUnfilteredTree, DefaultMutableTreeNode parentNodeInFilteredTree, FilterCondition filterCondition) {
        Enumeration<TreeNode> childrenOfParentNodeInUnfilteredTree = parentNodeInUnfilteredTree.children();
        while (childrenOfParentNodeInUnfilteredTree.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)childrenOfParentNodeInUnfilteredTree.nextElement();
            this.filterChildRecursively(child, parentNodeInFilteredTree, filterCondition);
        }
    }

    private void filterChildRecursively(DefaultMutableTreeNode childNodeInUnfilteredTree, DefaultMutableTreeNode parentNodeInFilteredTree, FilterCondition filterCondition) {
        if (filterCondition.keepNode(childNodeInUnfilteredTree)) {
            DefaultMutableTreeNode newChildNodeInFilteredTree = new DefaultMutableTreeNode(childNodeInUnfilteredTree.getUserObject());
            parentNodeInFilteredTree.add(newChildNodeInFilteredTree);
            this.filterRecursively(childNodeInUnfilteredTree, newChildNodeInFilteredTree, filterCondition);
        } else {
            this.filterRecursively(childNodeInUnfilteredTree, parentNodeInFilteredTree, filterCondition);
        }
    }

    static interface FilterCondition {
        public boolean keepNode(DefaultMutableTreeNode var1);
    }
}

