/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe;

import com.modelengineers.MoRe.FrameUtils;
import com.modelengineers.MoRe.SelectItemWithPathFromTreePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class SelectItemWithPathFromTree
extends JFrame
implements FocusListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    private final DefaultMutableTreeNode rootTreeNode;
    private final boolean noButtons;
    private SelectItemWithPathFromTreePanel treePanel;
    private JPanel treeAndInfoMessagePanel;
    private JPanel infoMessagePanel;
    private JLabel infoMessageLabel;
    private JButton okButton;
    private String fullPathOfSelectedItem;
    private Object userDataOfSelectedItem;

    public static DefaultMutableTreeNode makeTreeNode(String fullPath, Object userData, boolean isValidSelection) {
        return new DefaultMutableTreeNode(new SelectItemWithPathFromTreePanel.TreeItem(fullPath, userData, isValidSelection));
    }

    public static DefaultMutableTreeNode makeTreeNode(String fullPath, Object userData) {
        return SelectItemWithPathFromTree.makeTreeNode(fullPath, userData, true);
    }

    public SelectItemWithPathFromTree(DefaultMutableTreeNode tree) {
        this(tree, false);
    }

    public SelectItemWithPathFromTree(DefaultMutableTreeNode tree, boolean noButtons) {
        this.rootTreeNode = tree;
        this.noButtons = noButtons;
        this.initFrame();
        this.addFrameContent();
        this.updateOkButton();
    }

    public void setMatlabFunctionForDoubleClick(String matlabFunction) {
        this.treePanel.setMatlabFunctionForDoubleClick(matlabFunction);
    }

    public void setInfoMessage(String infoMessage) {
        if (!infoMessage.isEmpty()) {
            this.infoMessageLabel.setText("<html>" + infoMessage + "</html>");
            this.infoMessagePanel.setVisible(true);
        }
    }

    public String getFullPathOfSelectedItem() {
        return this.fullPathOfSelectedItem;
    }

    public Object getUserDataOfSelectedItem() {
        return this.userDataOfSelectedItem;
    }

    public DefaultMutableTreeNode getRootTreeNode() {
        return this.rootTreeNode;
    }

    public boolean infoMessageIsShown() {
        return this.infoMessageLabel.isShowing();
    }

    public String getInfoMessageShown() {
        return this.infoMessageLabel.getText();
    }

    public void selectNode(DefaultMutableTreeNode node) {
        this.treePanel.selectNode(node);
    }

    public boolean okButtonIsEnabled() {
        return this.okButton.isEnabled();
    }

    private void initFrame() {
        this.setIconOfFrame();
        this.setSize(400, 500);
        this.getRootPane().setBorder(new EmptyBorder(8, 8, 8, 8));
        this.addFocusListener(this);
        this.addWindowListener(new MyWindowListener());
        this.setUpFrameIsClosedWhenEscKeyIsPressed();
    }

    private void setIconOfFrame() {
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("toolIcon.png"));
        this.setIconImage(imageIcon.getImage());
    }

    private void addFrameContent() {
        this.addTreeAndInfoMessagePanel();
        if (!this.noButtons) {
            this.addButtons();
        }
    }

    private void addTreeAndInfoMessagePanel() {
        this.createTreeAndInfoMessagePanel();
        this.add((Component)this.treeAndInfoMessagePanel, "Center");
    }

    private void createTreeAndInfoMessagePanel() {
        this.createEmptyTreeAndInfoMessagePanel();
        this.addInfoMessagePanel();
        this.addTreePanel();
    }

    private void createEmptyTreeAndInfoMessagePanel() {
        this.treeAndInfoMessagePanel = new JPanel();
        this.treeAndInfoMessagePanel.setLayout(new BorderLayout());
        this.treeAndInfoMessagePanel.setBorder(new EmptyBorder(5, 5, 5, 5));
    }

    private void addInfoMessagePanel() {
        this.createInfoMessagePanel();
        this.treeAndInfoMessagePanel.add((Component)this.infoMessagePanel, "North");
    }

    private void createInfoMessagePanel() {
        this.infoMessagePanel = new JPanel();
        this.infoMessagePanel.setLayout(new BorderLayout());
        this.infoMessagePanel.setBorder(new EmptyBorder(0, 0, 5, 0));
        this.infoMessageLabel = new JLabel();
        this.infoMessageLabel.setIcon(new ImageIcon(SelectItemWithPathFromTree.class.getResource("warningIconBW_16_16.png")));
        Font infoMessageLabelFont = this.infoMessageLabel.getFont();
        this.infoMessageLabel.setFont(infoMessageLabelFont.deriveFont(infoMessageLabelFont.getStyle() & 0xFFFFFFFE));
        this.infoMessagePanel.add((Component)this.infoMessageLabel, "Center");
        this.infoMessagePanel.setVisible(false);
    }

    private void addTreePanel() {
        this.createTreePanel();
        this.treeAndInfoMessagePanel.add((Component)this.treePanel, "Center");
    }

    private void createTreePanel() {
        this.treePanel = new SelectItemWithPathFromTreePanel();
        this.treePanel.setRootNode(this.rootTreeNode);
        this.treePanel.getjTree().addTreeSelectionListener(new MyTreeSelectionListener());
        this.treePanel.getjTree().addKeyListener(this);
        this.treePanel.getjTree().addFocusListener(new JTreeFocusListener());
    }

    private void setUpFrameIsClosedWhenEscKeyIsPressed() {
        AbstractAction closeFrameWithCancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectItemWithPathFromTree.this.dispose();
            }
        };
        FrameUtils.bindKeyStrokeInFrameToAction(this, 27, "ESCAPE", closeFrameWithCancelAction);
    }

    private void addButtons() {
        JPanel buttonPanel = new JPanel();
        GridLayout gridLayout = new GridLayout(1, 2);
        gridLayout.setHgap(5);
        buttonPanel.setLayout(gridLayout);
        this.okButton = new JButton("Ok");
        this.okButton.addActionListener(new OkButtonPressedListener());
        buttonPanel.add(this.okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new CancelButtonPressedListener());
        buttonPanel.add(cancelButton);
        buttonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.add((Component)buttonPanel, "Last");
    }

    private boolean validItemSelectedInTree() {
        boolean isValid = false;
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this.treePanel.getjTree().getLastSelectedPathComponent();
        if (selectedNode != null) {
            SelectItemWithPathFromTreePanel.TreeItem selectedItem = (SelectItemWithPathFromTreePanel.TreeItem)selectedNode.getUserObject();
            isValid = selectedItem.isValidSelection;
        }
        return isValid;
    }

    private void updateOkButton() {
        if (this.okButton != null) {
            this.okButton.setEnabled(this.validItemSelectedInTree());
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.treePanel.getFilterField().requestFocusInWindow();
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    private void saveSelectedNodeAndCloseFrame() {
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this.treePanel.getjTree().getLastSelectedPathComponent();
        this.fullPathOfSelectedItem = ((SelectItemWithPathFromTreePanel.TreeItem)selectedNode.getUserObject()).fullPath;
        this.userDataOfSelectedItem = ((SelectItemWithPathFromTreePanel.TreeItem)selectedNode.getUserObject()).userData;
        this.dispose();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10 && this.validItemSelectedInTree()) {
            this.saveSelectedNodeAndCloseFrame();
        } else if (e.getKeyCode() == 27) {
            this.dispose();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public static void main(String[] args) {
        DefaultMutableTreeNode rootNode = SelectItemWithPathFromTree.makeTreeNode("myModel", null, true);
        DefaultMutableTreeNode childNode1 = SelectItemWithPathFromTree.makeTreeNode("myModel/Subsystem1", null, true);
        rootNode.add(childNode1);
        DefaultMutableTreeNode childNode2 = SelectItemWithPathFromTree.makeTreeNode("myModel/Subsystem2", null, false);
        rootNode.add(childNode2);
        SelectItemWithPathFromTree frame = new SelectItemWithPathFromTree(rootNode);
        frame.setInfoMessage("Signal to be removed is used in another branch. Blocks above branch point are grayed out and cannot be selected.");
        frame.setVisible(true);
    }

    class MyWindowListener
    extends WindowAdapter {
        MyWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
        }
    }

    class JTreeFocusListener
    implements FocusListener {
        JTreeFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (SelectItemWithPathFromTree.this.treePanel.getjTree().getSelectionCount() == 0) {
                SelectItemWithPathFromTree.this.treePanel.getjTree().setSelectionRow(0);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    class CancelButtonPressedListener
    implements ActionListener {
        CancelButtonPressedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectItemWithPathFromTree.this.dispose();
        }
    }

    class OkButtonPressedListener
    implements ActionListener {
        OkButtonPressedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectItemWithPathFromTree.this.saveSelectedNodeAndCloseFrame();
        }
    }

    class MyTreeSelectionListener
    implements TreeSelectionListener {
        MyTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            SelectItemWithPathFromTree.this.updateOkButton();
        }
    }
}

