/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe;

import com.modelengineers.MoRe.FrameUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class MatchBlockSizeToIconText
extends JFrame {
    private static final boolean DEFAULT_OVERRIDE_CONFIG_VALUES = false;
    private static final boolean DEFAULT_CHANGE_WIDTH_ONLY = false;
    private static final boolean DEFAULT_SAME_SIZE_FOR_BLOCKS_OF_SAME_TYPE = false;
    private static final Preferences USER_PREFERENCES = Preferences.userRoot().node(MatchBlockSizeToIconText.class.getName());
    private final int configValue_PaddingWidth;
    private final int configValue_PaddingHeight;
    private boolean closedWithOk;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JPanel contentPanel;
    private JPanel innerPaddingPanel;
    private JCheckBox jCheckBoxChangeWidthOnly;
    private JCheckBox jCheckBoxOverrideConfigValues;
    private JCheckBox jCheckBoxSameSizeForBlocksOfSameType;
    private JLabel jLabelHeight;
    private JLabel jLabelWidth;
    private JSpinner jSpinnerPaddingHeight;
    private JSpinner jSpinnerPaddingWidth;
    private JButton okButton;
    private JPanel outerEmptyBorderPanel;
    private JPanel paddingHeightSpinnerPanel;
    private JPanel paddingPanel;
    private JPanel paddingSpinnerPanel;
    private JPanel paddingWidthSpinnerPanel;

    public MatchBlockSizeToIconText(int configValue_PaddingWidth, int configValue_PaddingHeight) {
        this.configValue_PaddingWidth = configValue_PaddingWidth;
        this.configValue_PaddingHeight = configValue_PaddingHeight;
        this.initComponents();
        this.setUpComponents();
        this.setFrameIcon();
    }

    public boolean closedWithOk() {
        return this.closedWithOk;
    }

    public boolean changeWidthOnlyIsChecked() {
        return this.jCheckBoxChangeWidthOnly.isSelected();
    }

    public boolean sameSizeForBlocksOfSameTypeIsChecked() {
        return this.jCheckBoxSameSizeForBlocksOfSameType.isSelected();
    }

    public int getPaddingWidth() {
        return (Integer)this.jSpinnerPaddingWidth.getValue();
    }

    public int getPaddingHeight() {
        return (Integer)this.jSpinnerPaddingHeight.getValue();
    }

    public static void removeUserPreferences() throws BackingStoreException {
        USER_PREFERENCES.clear();
    }

    private void setUpComponents() {
        this.setUpWidthOfPaddingSpinners();
        this.setUpFocusOnOkButtonWhenWindowIsOpened();
        this.setUpKeyBindings();
        this.setUpUserSelectionsAreStoredOnCloseAndRestoredOnOpen();
    }

    private void setUpWidthOfPaddingSpinners() {
        ((JSpinner.DefaultEditor)this.jSpinnerPaddingWidth.getEditor()).getTextField().setColumns(2);
        ((JSpinner.DefaultEditor)this.jSpinnerPaddingHeight.getEditor()).getTextField().setColumns(2);
    }

    private void setUpFocusOnOkButtonWhenWindowIsOpened() {
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                MatchBlockSizeToIconText.this.okButton.requestFocusInWindow();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
    }

    private void setUpKeyBindings() {
        this.setUpFrameIsClosedWithOkWhenEnterKeyIsPressedOnOkButton();
        this.setUpFrameIsClosedWithCancelWhenEnterKeyIsPressedOnCancelButton();
        this.setUpFrameIsClosedWithCancelWhenEscKeyIsPressed();
    }

    private void setUpFrameIsClosedWithOkWhenEnterKeyIsPressedOnOkButton() {
        boolean closeWithOk = true;
        this.okButton.addKeyListener(new KeyListenerToCloseFrameWhenEnterKeyIsPressed(closeWithOk));
    }

    private void setUpFrameIsClosedWithCancelWhenEnterKeyIsPressedOnCancelButton() {
        boolean closeWithOk = false;
        this.cancelButton.addKeyListener(new KeyListenerToCloseFrameWhenEnterKeyIsPressed(closeWithOk));
    }

    private void setUpFrameIsClosedWithCancelWhenEscKeyIsPressed() {
        AbstractAction closeFrameWithCancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MatchBlockSizeToIconText.this.closeFrameWithCancel();
            }
        };
        FrameUtils.bindKeyStrokeInFrameToAction(this, 27, "ESCAPE", closeFrameWithCancelAction);
    }

    private void closeFrameWithOk() {
        this.closeFrame(true);
    }

    private void closeFrameWithCancel() {
        this.closeFrame(false);
    }

    private void closeFrame(boolean closeWithOk) {
        this.closedWithOk = closeWithOk;
        this.storeUserPreferences();
        this.dispose();
    }

    private void setUpUserSelectionsAreStoredOnCloseAndRestoredOnOpen() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                MatchBlockSizeToIconText.this.restoreUserPreferences();
            }

            @Override
            public void windowClosing(WindowEvent e) {
                MatchBlockSizeToIconText.this.storeUserPreferences();
            }
        });
    }

    private void storeUserPreferences() {
        USER_PREFERENCES.putBoolean("overrideConfigValues", this.jCheckBoxOverrideConfigValues.isSelected());
        if (this.jCheckBoxOverrideConfigValues.isSelected()) {
            this.storePaddingSpinnerValuesUserPreferences();
        }
        USER_PREFERENCES.putBoolean("changeHeight", this.jCheckBoxChangeWidthOnly.isSelected());
        USER_PREFERENCES.putBoolean("sameSizeForBlocksOfSameType", this.jCheckBoxSameSizeForBlocksOfSameType.isSelected());
    }

    private void restoreUserPreferences() {
        this.restorePaddingSpinnerUserPreferences();
        this.jCheckBoxChangeWidthOnly.setSelected(USER_PREFERENCES.getBoolean("changeHeight", false));
        this.jCheckBoxSameSizeForBlocksOfSameType.setSelected(USER_PREFERENCES.getBoolean("sameSizeForBlocksOfSameType", false));
    }

    private void restorePaddingSpinnerUserPreferences() {
        this.jCheckBoxOverrideConfigValues.setSelected(USER_PREFERENCES.getBoolean("overrideConfigValues", false));
        boolean checkboxHasChanged = false;
        this.updatePaddingSpinnersBasedOnOverrideCheckbox(checkboxHasChanged);
    }

    private void setFrameIcon() {
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("toolIcon.png"));
        this.setIconImage(imageIcon.getImage());
    }

    private void updatePaddingSpinnersBasedOnOverrideCheckbox(boolean checkboxHasChanged) {
        if (this.jCheckBoxOverrideConfigValues.isSelected()) {
            this.updatePaddingSpinnersWhenOverrideCheckboxIsSelected();
        } else {
            this.updatePaddingSpinnersWhenOverrideCheckboxIsNotSelected(checkboxHasChanged);
        }
    }

    private void updatePaddingSpinnersWhenOverrideCheckboxIsNotSelected(boolean checkboxHasChanged) {
        if (checkboxHasChanged) {
            this.storePaddingSpinnerValuesUserPreferences();
        }
        this.setPaddingSpinnerValuesToConfigValues();
        this.setPaddingSpinnersEnabled(false);
    }

    private void storePaddingSpinnerValuesUserPreferences() {
        USER_PREFERENCES.putInt("marginX", (Integer)this.jSpinnerPaddingWidth.getValue());
        USER_PREFERENCES.putInt("marginY", (Integer)this.jSpinnerPaddingHeight.getValue());
    }

    private void setPaddingSpinnerValuesToConfigValues() {
        this.jSpinnerPaddingWidth.setValue(this.configValue_PaddingWidth);
        this.jSpinnerPaddingHeight.setValue(this.configValue_PaddingHeight);
    }

    private void updatePaddingSpinnersWhenOverrideCheckboxIsSelected() {
        this.restorePaddingSpinnerValuesUserPreferences();
        this.setPaddingSpinnersEnabled(true);
    }

    private void restorePaddingSpinnerValuesUserPreferences() {
        this.jSpinnerPaddingWidth.setValue(USER_PREFERENCES.getInt("marginX", this.configValue_PaddingWidth));
        this.jSpinnerPaddingHeight.setValue(USER_PREFERENCES.getInt("marginY", this.configValue_PaddingHeight));
    }

    private void setPaddingSpinnersEnabled(boolean enabled) {
        this.jSpinnerPaddingWidth.setEnabled(enabled);
        this.jSpinnerPaddingHeight.setEnabled(enabled);
    }

    private void initComponents() {
        this.outerEmptyBorderPanel = new JPanel();
        this.contentPanel = new JPanel();
        this.paddingPanel = new JPanel();
        this.innerPaddingPanel = new JPanel();
        this.jCheckBoxOverrideConfigValues = new JCheckBox();
        this.paddingSpinnerPanel = new JPanel();
        this.paddingWidthSpinnerPanel = new JPanel();
        this.jLabelWidth = new JLabel();
        this.jSpinnerPaddingWidth = new JSpinner();
        this.paddingHeightSpinnerPanel = new JPanel();
        this.jLabelHeight = new JLabel();
        this.jSpinnerPaddingHeight = new JSpinner();
        this.jCheckBoxChangeWidthOnly = new JCheckBox();
        this.jCheckBoxSameSizeForBlocksOfSameType = new JCheckBox();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.outerEmptyBorderPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.outerEmptyBorderPanel.setLayout(new BorderLayout(0, 5));
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        this.paddingPanel.setBorder(BorderFactory.createTitledBorder("Padding"));
        this.paddingPanel.setAlignmentX(0.0f);
        this.paddingPanel.setLayout(new BoxLayout(this.paddingPanel, 1));
        this.innerPaddingPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.innerPaddingPanel.setLayout(new BoxLayout(this.innerPaddingPanel, 1));
        this.jCheckBoxOverrideConfigValues.setText("Override Config Values");
        this.jCheckBoxOverrideConfigValues.setName("overrideConfigValues");
        this.jCheckBoxOverrideConfigValues.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MatchBlockSizeToIconText.this.jCheckBoxOverrideConfigValuesActionPerformed(evt);
            }
        });
        this.innerPaddingPanel.add(this.jCheckBoxOverrideConfigValues);
        this.paddingSpinnerPanel.setAlignmentX(0.0f);
        this.paddingSpinnerPanel.setLayout(new BoxLayout(this.paddingSpinnerPanel, 2));
        this.jLabelWidth.setText("Width:");
        this.paddingWidthSpinnerPanel.add(this.jLabelWidth);
        this.jSpinnerPaddingWidth.setName("paddingWidth");
        this.paddingWidthSpinnerPanel.add(this.jSpinnerPaddingWidth);
        this.paddingSpinnerPanel.add(this.paddingWidthSpinnerPanel);
        this.jLabelHeight.setText("Height:");
        this.paddingHeightSpinnerPanel.add(this.jLabelHeight);
        this.jSpinnerPaddingHeight.setName("paddingHeight");
        this.paddingHeightSpinnerPanel.add(this.jSpinnerPaddingHeight);
        this.paddingSpinnerPanel.add(this.paddingHeightSpinnerPanel);
        this.innerPaddingPanel.add(this.paddingSpinnerPanel);
        this.paddingPanel.add(this.innerPaddingPanel);
        this.contentPanel.add(this.paddingPanel);
        this.jCheckBoxChangeWidthOnly.setText("Change Width Only");
        this.jCheckBoxChangeWidthOnly.setName("changeWidthOnly");
        this.contentPanel.add(this.jCheckBoxChangeWidthOnly);
        this.jCheckBoxSameSizeForBlocksOfSameType.setText("Same Size for Blocks of Same Type");
        this.jCheckBoxSameSizeForBlocksOfSameType.setName("sameSizeForBlocksOfSameType");
        this.contentPanel.add(this.jCheckBoxSameSizeForBlocksOfSameType);
        this.outerEmptyBorderPanel.add((Component)this.contentPanel, "Center");
        this.buttonPanel.setLayout(new GridLayout(1, 2, 5, 0));
        this.okButton.setText("Ok");
        this.okButton.setName("ok");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MatchBlockSizeToIconText.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setName("cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MatchBlockSizeToIconText.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.outerEmptyBorderPanel.add((Component)this.buttonPanel, "Last");
        this.getContentPane().add((Component)this.outerEmptyBorderPanel, "Center");
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.closeFrameWithOk();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeFrameWithCancel();
    }

    private void jCheckBoxOverrideConfigValuesActionPerformed(ActionEvent evt) {
        boolean checkboxHasChanged = true;
        this.updatePaddingSpinnersBasedOnOverrideCheckbox(checkboxHasChanged);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MatchBlockSizeToIconText.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MatchBlockSizeToIconText.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MatchBlockSizeToIconText.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MatchBlockSizeToIconText.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                int configValue_PaddingWidth = 6;
                int configValue_PaddingHeight = 2;
                new MatchBlockSizeToIconText(configValue_PaddingWidth, configValue_PaddingHeight).setVisible(true);
            }
        });
    }

    class KeyListenerToCloseFrameWhenEnterKeyIsPressed
    implements KeyListener {
        private final boolean closeWithOk;

        public KeyListenerToCloseFrameWhenEnterKeyIsPressed(boolean closeWithOk) {
            this.closeWithOk = closeWithOk;
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                MatchBlockSizeToIconText.this.closeFrame(this.closeWithOk);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }
}

