/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.lismo3_0.internal;

import com.modelengineers.lismo3_0.api.Lismo;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class LismoLogger {
    private static final int MAX_LOG_FILE_SIZE = 0x500000;
    private static final int MAX_NUMBER_OF_LOG_FILES = 1;
    public static final String CLIENT_LOG_FILE_NAME = "lismo.client.log";
    public static final String DEFAULT_TOOL_IDENTIFIER = "default-pre-2.4";
    private static final Map<String, Map<String, Logger>> loggerRegistry = new HashMap<String, Map<String, Logger>>();
    private static Map<String, Handler> configuredFileHandlers = new HashMap<String, Handler>();
    private static Handler defaultConsoleHandler = null;

    protected LismoLogger() {
    }

    public static void setup(String string, String string2) throws IOException {
        LismoLogger.setup(DEFAULT_TOOL_IDENTIFIER, string, string2);
    }

    public static void setup(String string, String string2, String string3) throws IOException {
        LismoLogger.teardown(string);
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdirs();
        }
        Handler handler = LismoLogger.createHandler(new File(file, string3));
        configuredFileHandlers.put(string, handler);
        LismoLogger.addHandler(LismoLogger.getLoggersForTool(string), handler);
    }

    private static Map<String, Logger> getLoggersForTool(String string) {
        Map<String, Logger> map = loggerRegistry.get(string);
        if (map == null) {
            map = new HashMap<String, Logger>();
            loggerRegistry.put(string, map);
        }
        return map;
    }

    public static void teardown(String string) {
        Map<String, Logger> map = LismoLogger.getLoggersForTool(string);
        Handler handler = configuredFileHandlers.get(string);
        if (handler != null) {
            handler.close();
            LismoLogger.removeHandler(map, handler);
            configuredFileHandlers.remove(string);
        }
        LismoLogger.addHandler(map, defaultConsoleHandler);
    }

    private static void addHandler(Map<String, Logger> map, Handler handler) {
        if (handler == null) {
            return;
        }
        for (Logger logger : map.values()) {
            if (LismoLogger.contains(logger, handler)) continue;
            LismoLogger.removeConsoleHandlers(logger);
            logger.addHandler(handler);
        }
    }

    private static boolean contains(Logger logger, Handler handler) {
        Handler[] handlerArray;
        boolean bl = handler instanceof ConsoleHandler;
        for (Handler handler2 : handlerArray = logger.getHandlers()) {
            if (!handler2.equals(handler) && (!bl || !(handler2 instanceof ConsoleHandler))) continue;
            return true;
        }
        return false;
    }

    private static void removeConsoleHandlers(Logger logger) {
        Handler[] handlerArray;
        for (Handler handler : handlerArray = logger.getHandlers()) {
            if (!(handler instanceof ConsoleHandler)) continue;
            logger.removeHandler(handler);
        }
    }

    private static void removeHandler(Map<String, Logger> map, Handler handler) {
        for (Logger logger : map.values()) {
            logger.removeHandler(handler);
        }
    }

    public static Logger getLogger(Class<?> clazz, String string) {
        String string2;
        Map<String, Logger> map = LismoLogger.getLoggersForTool(string);
        Logger logger = map.get(string2 = clazz.getName());
        if (logger != null) {
            if (logger.getHandlers().length < 1) {
                LismoLogger.addDefaultHandlerToLogger(logger, string);
            }
            return logger;
        }
        logger = LismoLogger.createLogger(string, clazz);
        LismoLogger.addDefaultHandlerToLogger(logger, string);
        map.put(clazz.getName(), logger);
        return logger;
    }

    private static Logger createLogger(String string, Class<?> clazz) {
        String string2 = string + "/" + clazz.getName();
        Logger logger = Logger.getLogger(string2);
        logger.setUseParentHandlers(false);
        logger.setLevel(Level.INFO);
        return logger;
    }

    private static void addDefaultHandlerToLogger(Logger logger, String string) {
        if (!configuredFileHandlers.containsKey(string)) {
            if (defaultConsoleHandler == null) {
                defaultConsoleHandler = new ConsoleHandler();
            }
            logger.addHandler(defaultConsoleHandler);
        } else {
            logger.addHandler(configuredFileHandlers.get(string));
        }
    }

    private static Handler createHandler(File file) throws IOException {
        FileHandler fileHandler = new FileHandler(file.getAbsolutePath(), 0x500000, 1, true);
        SimpleFormatter simpleFormatter = new SimpleFormatter();
        fileHandler.setFormatter(simpleFormatter);
        return fileHandler;
    }

    public static Logger initLoggerForLismoClass(String string, String string2) {
        Logger logger;
        if (null == string2) {
            logger = LismoLogger.getLogger(Lismo.class, DEFAULT_TOOL_IDENTIFIER);
        } else {
            try {
                LismoLogger.setup(string, string2, CLIENT_LOG_FILE_NAME);
                logger = LismoLogger.getLogger(Lismo.class, string);
            }
            catch (IOException iOException) {
                logger = LismoLogger.getLogger(Lismo.class, string);
                logger.warning("Failed to initialize logging: " + iOException.toString());
            }
        }
        return logger;
    }
}

