/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.lismo3_0.internal;

import com.modelengineers.lismo3_0.api.exceptions.LicenseBorrowException;
import com.modelengineers.lismo3_0.api.exceptions.LicenseExpiredException;
import com.modelengineers.lismo3_0.api.exceptions.LicenseNotAvailableException;
import com.modelengineers.lismo3_0.api.exceptions.LicenseNumberUsersReachedException;
import com.modelengineers.lismo3_0.api.exceptions.LicenseUnknownFeatureException;
import com.modelengineers.lismo3_0.api.exceptions.LismoException;
import com.modelengineers.lismo3_0.internal.exceptions.FLEXlmException;
import java.text.MessageFormat;

public enum FLEXlmErrorCode {
    LM_NOERROR(0),
    LM_NOCONFFILE(-1),
    LM_BADFILE(-2),
    LM_NOSERVER(-3),
    LM_MAXUSERS(-4){

        @Override
        protected void doThrow(String string, FLEXlmException fLEXlmException) throws LicenseNumberUsersReachedException {
            throw new LicenseNumberUsersReachedException(MessageFormat.format(FLEXlmErrorCode.MESSAGE_WITH_DETAIL, string, "Number of users reached."), fLEXlmException);
        }
    }
    ,
    LM_NOFEATURE(-5){

        @Override
        protected void doThrow(String string, FLEXlmException fLEXlmException) throws LicenseUnknownFeatureException {
            throw new LicenseUnknownFeatureException(MessageFormat.format(FLEXlmErrorCode.MESSAGE_WITH_DETAIL, string, "License feature is not known."), fLEXlmException);
        }
    }
    ,
    LM_NOSERVICE(-6),
    LM_NOSOCKET(-7),
    LM_BADCODE(-8),
    LM_NOTTHISHOST(-9),
    LM_LONGGONE(-10){

        @Override
        protected void doThrow(String string, FLEXlmException fLEXlmException) throws LicenseExpiredException {
            throw new LicenseExpiredException(MessageFormat.format(FLEXlmErrorCode.MESSAGE_WITH_DETAIL, string, "License is expired."), fLEXlmException);
        }
    }
    ,
    LM_BADDATE(-11),
    LM_BADCOMM(-12),
    LM_NO_SERVER_IN_FILE(-13),
    LM_BADHOST(-14),
    LM_CANTCONNECT(-15),
    LM_CANTREAD(-16),
    LM_CANTWRITE(-17),
    LM_NOSERVSUPP(-18),
    LM_SELECTERR(-19),
    LM_SERVBUSY(-20),
    LM_OLDVER(-21),
    LM_CHECKINBAD(-22),
    LM_BUSYNEWSERV(-23),
    LM_USERSQUEUED(-24),
    LM_SERVLONGGONE(-25),
    LM_TOOMANY(-26),
    LM_CANTREADKMEM(-27),
    LM_CANTREADVMUNIX(-28),
    LM_CANTFINDETHER(-29),
    LM_NOREADLIC(-30),
    LM_TOOEARLY(-31),
    LM_NOSUCHATTR(-32),
    LM_BADHANDSHAKE(-33),
    LM_CLOCKBAD(-34),
    LM_FEATQUEUE(-35),
    LM_FEATCORRUPT(-36),
    LM_BADFEATPARAM(-37),
    LM_FEATEXCLUDE(-38),
    LM_FEATNOTINCLUDE(-39),
    LM_CANTMALLOC(-40),
    LM_NEVERCHECKOUT(-41),
    LM_BADPARAM(-42),
    LM_NOKEYDATA(-43),
    LM_BADKEYDATA(-44),
    LM_FUNCNOTAVAIL(-45),
    LM_DEMOKIT(-46),
    LM_NOCLOCKCHECK(-47),
    LM_BADPLATFORM(-48),
    LM_DATE_TOOBIG(-49),
    LM_EXPIREDKEYS(-50),
    LM_NOFLEXLMINIT(-51),
    LM_NOSERVRESP(-52),
    LM_CHECKOUTFILTERED(-53),
    LM_NOFEATSET(-54),
    LM_BADFEATSET(-55),
    LM_CANTCOMPUTEFEATSET(-56),
    LM_SOCKETFAIL(-57),
    LM_SETSOCKFAIL(-58),
    LM_BADCHECKSUM(-59),
    LM_SERVBADCHECKSUM(-60),
    LM_SERVNOREADLIC(-61),
    LM_NONETWORK(-62),
    LM_NOTLICADMIN(-63),
    LM_REMOVETOOSOON(-64),
    LM_BADVENDORDATA(-65),
    LM_LIBRARYMISMATCH(-66),
    LM_NONETOBORROW(-67){

        @Override
        protected void doThrow(String string, FLEXlmException fLEXlmException) throws LicenseBorrowException {
            throw new LicenseBorrowException(MessageFormat.format(FLEXlmErrorCode.MESSAGE_WITH_DETAIL, string, "No license available to borrow."), fLEXlmException);
        }
    }
    ,
    LM_NOBORROWSUPP(-68){

        @Override
        protected void doThrow(String string, FLEXlmException fLEXlmException) throws LicenseBorrowException {
            throw new LicenseBorrowException(MessageFormat.format(FLEXlmErrorCode.MESSAGE_WITH_DETAIL, string, "Support for borrowing licenses is not enabled."), fLEXlmException);
        }
    }
    ,
    LM_NOTONSERVER(-69),
    LM_BORROWLOCKED(-70),
    LM_BAD_TZ(-71),
    LM_OLDVENDORDATA(-72),
    LM_LOCALFILTER(-73),
    LM_ENDPATH(-74),
    LM_VMS_SETIMR_FAILED(-75),
    LM_INTERNAL_ERROR(-76),
    LM_BAD_VERSION(-77),
    LM_NOADMINAPI(-78),
    LM_NOFILEOPS(-79),
    LM_NODATAFILE(-80),
    LM_NOFILEVSEND(-81),
    LM_BADPKG(-82),
    LM_SERVOLDVER(-83),
    LM_USER_BASED(-84),
    LM_NOSERVCAP(-85),
    LM_OBJECTUSED(-86),
    LM_MAXLIMIT(-87),
    LM_BADSYSDATE(-88),
    LM_PLATNOTLIC(-89),
    LM_FUTURE_FILE(-90),
    LM_DEFAULT_SEEDS(-91),
    LM_SERVER_REMOVED(-92),
    LM_POOL(-93),
    LM_LGEN_VER(-94),
    LM_NOT_THIS_HOST(-95),
    LM_HOSTDOWN(-96),
    LM_VENDOR_DOWN(-97),
    LM_CANT_DECIMAL(-98),
    LM_BADDECFILE(-99),
    LM_REMOVE_LINGER(-100),
    LM_RESVFOROTHERS(-101),
    LM_BORROW_ERROR(-102),
    LM_TSOK_ERR(-103),
    LM_BORROW_TOOLONG(-104){

        @Override
        protected void doThrow(String string, FLEXlmException fLEXlmException) throws LicenseBorrowException {
            throw new LicenseBorrowException(MessageFormat.format(FLEXlmErrorCode.MESSAGE_WITH_DETAIL, string, "Borrow is time to long."), fLEXlmException);
        }
    }
    ,
    LM_UNBORROWED_ALREADY(-105){

        @Override
        protected void doThrow(String string, FLEXlmException fLEXlmException) throws LicenseBorrowException {
            throw new LicenseBorrowException(MessageFormat.format(FLEXlmErrorCode.MESSAGE_WITH_DETAIL, string, "Feature was already returned to license server."), fLEXlmException);
        }
    }
    ,
    LM_SERVER_MAXED_OUT(-106),
    LM_NOBORROWCOMP(-107),
    LM_BORROW_METEREMPTY(-108),
    LM_NOBORROWMETER(-109),
    LM_NODONGLE(-110),
    LM_NORESLINK(-111),
    LM_NODONGLEDRIVER(-112),
    LM_FLEXLOCK2CKOUT(-113),
    LM_SIGN_REQ(-114),
    LM_PUBKEY_ERR(-115),
    LM_NOTRLSUPPORT(-116),
    LM_NOCROSUPPORT(-116),
    LM_BORROW_LINGER_ERR(-117),
    LM_BORROW_EXPIRED(-118){

        @Override
        protected void doThrow(String string, FLEXlmException fLEXlmException) throws LicenseBorrowException {
            throw new LicenseBorrowException(MessageFormat.format(FLEXlmErrorCode.MESSAGE_WITH_DETAIL, string, "The borrowed license expired and therefore can no longer be checked."), fLEXlmException);
        }
    }
    ,
    LM_MUST_BE_LOCAL(-119),
    LM_BORROW_DOWN(-120),
    LM_FLOATOK_ONEHOSTID(-121),
    LM_BORROW_DELETE_ERR(-122),
    LM_BORROW_RETURN_EARLY_ERR(-123),
    LM_BORROW_RETURN_SERVER_ERR(-124),
    LM_CANT_CHECKOUT_JUST_PACKAGE(-125),
    LM_COMPOSITEID_INIT_ERR(-126),
    LM_COMPOSITEID_ITEM_ERR(-127),
    LM_BORROW_MATCH_ERR(-128),
    LM_NULLPOINTER(-129),
    LM_BADHANDLE(-130),
    LM_EMPTYSTRING(-131),
    LM_BADMEMORYACCESS(-132),
    LM_NOTSUPPORTED(-133),
    LM_NULLJOBHANDLE(-134),
    LM_EVENTLOG_INIT_ERR(-135),
    LM_EVENTLOG_DISABLED(-136),
    LM_EVENTLOG_WRITE_ERR(-137),
    LM_BADINDEX(-138),
    LM_TIMEOUT(-139),
    LM_BADCOMMAND(-140),
    LM_SOCKET_BROKEN_PIPE(-141),
    LM_INVALID_SIGNATURE(-142),
    LM_UNCOUNTED_NOT_SUPPORTED(-143),
    LM_REDUNDANT_SIGNATURES(-144),
    LM_BADCODE_V71_LK(-145),
    LM_BADCODE_V71_SIGN(-146),
    LM_BADCODE_V80_LK(-147),
    LM_BADCODE_V80_SIGN(-148),
    LM_BADCODE_V81_LK(-149),
    LM_BADCODE_V81_SIGN(-150),
    LM_BADCODE_V81_SIGN2(-151),
    LM_BADCODE_V84_LK(-152),
    LM_BADCODE_V84_SIGN(-153),
    LM_BADCODE_V84_SIGN2(-154),
    LM_LK_REQ(-155),
    LM_BADAUTH(-156),
    LM_REPAIR_NEEDED(-157),
    LM_TS_OPEN(-158),
    LM_BAD_FULFILLMENT(-159),
    LM_BAD_ACTREQ(-160),
    LM_TS_NO_FULFILL_MATCH(-161),
    LM_BAD_ACT_RESP(-162),
    LM_CANTRETURN(-163),
    LM_RETURNEXCEEDSMAX(-164),
    LM_NO_REPAIRS_LEFT(-165),
    LM_NOT_ALLOWED(-166),
    LM_ENTLEXCLUDE(-167),
    LM_ENTLNOTINCLUDE(-168),
    LM_ACTIVATION(-169),
    LM_TS_BADDATE(-170),
    LM_ENCRYPTION_FAILED(-171),
    LM_DECRYPTION_FAILED(-172),
    LM_BADCONTEXT(-173),
    LM_SUPERSEDE_CONFLICT(-174),
    LM_INVALID_SUPERSEDE_SIGN(-175),
    LM_SUPERSEDE_SIGN_EMPTYSTRING(-176),
    LM_ONE_TSOK_PLATFORM_ERR(-177),
    LM_ONE_TSOK_MTX_ERR(-178),
    LM_ONE_TSOK_ERR(-179),
    LM_SSIDNULL(-180),
    LM_SMTXNOTREL(-181),
    LM_MTXNOPERM(-182),
    LM_COMPOSITEID_ETHER_ERR(-183),
    LM_LIC_FILE_CHAR_EXCEED(-184),
    LM_TZ_INVALID_SYNTAX(-185),
    LM_TZ_INVALID_TZONE_SPEC(-186),
    LM_TZ_INVALID_TZONE_INFO(-187),
    LM_TZ_UNAUTHORIZED(-188),
    LM_INVALID_VM_PLATFORMS(-189),
    LM_VM_PHYSICAL_ONLY(-190),
    LM_VM_VIRTUAL_ONLY(-191),
    LM_VM_NOT_SUPPORT(-192),
    LM_VM_BAD_KEY(-193),
    LM_MAXLIMIT_EXCEED(-194),
    LM_BA_API_INTERNAL_ERROR(-195),
    LM_BA_COMM_ERROR(-196),
    LM_INVALID_BA_VERSION(-197),
    LM_UNSUPPORTED_FEATURE_HOSTID(-198),
    LM_SERVERQUERY_LOAD_REQUEST_FAILED(-199),
    LM_SERVERQUERY_RESPONSE_FAILED(-200),
    LM_INVALID_IPADDRESS(-201),
    LM_UNRESOLVED_FEATURE(-202),
    LM_TS_GET_TOTAL_FEAT_COUNT_FAILED(-203),
    LM_TS_ACT_RECLAIM_NOT_ALLOWED(-204),
    LM_TS_ACT_RECLAIM_FAILED(-205),
    LM_TS_ACT_RECLAIM_NO_DR_FOUND(-206),
    LM_TS_ACT_RECLAIM_LS_TS_NOT_SUPPORTED(-207),
    LM_TS_SAVE_ERROR(-208),
    LM_MAXSERVERS(-209),
    LM_LICSRVC_FAILED(-210),
    LM_NO_VMATTR_PHY_SYS(-211),
    LM_LIC_SVC_DISABLED(-212),
    LM_LIC_SVC_NOTINSTALLED(-213),
    LM_LIC_SVC_VER_ERR(-214),
    LM_VM_HOSTID_NOT_AVAILABLE(-215),
    LM_COAVAIL_RECONN_NOT_ALL_CNT_AVAIL(-216),
    LM_COAVAIL_FLAG_NOT_SUPPORTED(-217),
    LM_COAVAIL_PACKAGE_NOT_SUPPORTED(-218),
    LM_COAVAIL_UNSUPPORTED(-219),
    LM_ONLY_TS_ALLOWED(-220),
    LM_LAST_ERRNO(-220);

    private static final String MESSAGE_WITH_DETAIL = "{0} {1}";
    final int errNr;

    private FLEXlmErrorCode(int n2) {
        this.errNr = n2;
    }

    protected void doThrow(String string, FLEXlmException fLEXlmException) throws LismoException {
        throw new LicenseNotAvailableException(string, fLEXlmException);
    }

    public static void handle(String string, FLEXlmException fLEXlmException) throws LismoException {
        FLEXlmErrorCode.valueOf(fLEXlmException.getErrorNumber()).doThrow(string, fLEXlmException);
    }

    private static FLEXlmErrorCode valueOf(int n) {
        for (FLEXlmErrorCode fLEXlmErrorCode : FLEXlmErrorCode.values()) {
            if (fLEXlmErrorCode.errNr != n) continue;
            return fLEXlmErrorCode;
        }
        throw new IllegalArgumentException("Unsupported error number");
    }
}

