/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.lismo3_0.api;

import com.modelengineers.lismo3_0.internal.ConfigType;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class LicenseInformation
implements Serializable {
    private static final long serialVersionUID = 6923013592731642240L;
    private static final String EVAL_LICENSE_NOTICE_TAG = "EVALUATION";
    public static final String PERMANENT_LICENSE_DATE = "1-jan-0";
    private String versionString;
    private String featureName;
    private String startDate;
    private String expirationDate = "1-jan-0";
    private long daysUntilExpiration;
    private String vendorString;
    private String notice;
    private boolean fromLicenseServer;
    private int numberUsers = 0;
    private static final int EMPTY_NUMBER_USERS = 0;
    private static final ThreadLocal<SimpleDateFormat> dateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("dd-MMM-yyyy", Locale.ENGLISH);
        }
    };
    private final boolean initialized;
    private ConfigType type;

    public LicenseInformation(String string, String string2, String string3, String string4, long l, String string5, String string6, boolean bl, int n, ConfigType configType) {
        this.versionString = string;
        this.featureName = string2;
        this.startDate = string3;
        this.expirationDate = string4;
        this.daysUntilExpiration = l != Long.MIN_VALUE ? l : this.computeDaysExpired();
        this.vendorString = string5;
        this.notice = string6;
        this.fromLicenseServer = bl;
        this.numberUsers = n;
        this.type = configType;
        this.initialized = true;
    }

    public LicenseInformation() {
        this.initialized = false;
    }

    public boolean isEmpty() {
        return !this.initialized;
    }

    public int getType() {
        return this.type.ordinal();
    }

    public String getVersionString() {
        return this.versionString;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public String getStartDate() {
        return this.startDate == null ? "" : this.startDate;
    }

    public String getVendorString() {
        return this.vendorString == null ? "" : this.vendorString;
    }

    public String getNotice() {
        return this.notice == null ? "" : this.notice;
    }

    public boolean getFromServer() {
        return this.fromLicenseServer;
    }

    public int getNumberUsers() {
        return this.numberUsers;
    }

    public boolean isEvaluation() {
        return this.notice != null && this.notice.contains(EVAL_LICENSE_NOTICE_TAG);
    }

    public boolean isPermanent() {
        return PERMANENT_LICENSE_DATE.equals(this.expirationDate);
    }

    public boolean isExpired() {
        if (this.isPermanent()) {
            return false;
        }
        return this.getDaysUntilExpiration() < 0L;
    }

    public long getDaysUntilExpiration() {
        return this.daysUntilExpiration;
    }

    public Date getExpirationDate() {
        Date date = null;
        try {
            date = dateFormat.get().parse(this.expirationDate);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    public String getExpirationDateString() {
        return this.expirationDate;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nLicense Information\n");
        stringBuilder.append("feature: ");
        stringBuilder.append(this.getFeatureName());
        stringBuilder.append("\n");
        stringBuilder.append("version: ");
        stringBuilder.append(this.getVersionString());
        stringBuilder.append("\n");
        stringBuilder.append("start: ");
        stringBuilder.append(this.getStartDate());
        stringBuilder.append("\n");
        stringBuilder.append("expires: ");
        stringBuilder.append(this.getExpirationDateString());
        stringBuilder.append("\n");
        stringBuilder.append("days until expires: ");
        stringBuilder.append(this.getDaysUntilExpiration());
        stringBuilder.append("\n");
        stringBuilder.append("vendor string: ");
        stringBuilder.append(this.getVendorString());
        stringBuilder.append("\n");
        stringBuilder.append("notice: ");
        stringBuilder.append(this.getNotice());
        stringBuilder.append("\n");
        stringBuilder.append("from server: ");
        stringBuilder.append(this.getFromServer());
        stringBuilder.append("\n");
        stringBuilder.append("number users: ");
        stringBuilder.append(this.getNumberUsers());
        stringBuilder.append("\n");
        stringBuilder.append("type: ");
        stringBuilder.append(this.getType());
        stringBuilder.append("\n");
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    private long computeDaysExpired() {
        Date date = this.getExpirationDate();
        return date != null ? (long)((int)TimeUnit.DAYS.convert(date.getTime() - System.currentTimeMillis(), TimeUnit.MILLISECONDS)) : -1L;
    }
}

