/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.license;

import java.util.Objects;

public class ToolVersion
implements Comparable<ToolVersion> {
    private static final String REGEXP = "(.*?)(\\d*)\\.(\\d*)\\.(\\d*).*";
    private final String stringRepresentation;
    private String toolName;
    private String major;
    private String minor;
    private String micro;

    public ToolVersion(String string) {
        this.stringRepresentation = string;
        this.parseNumbers();
    }

    private void parseNumbers() {
        if (this.stringRepresentation.matches(REGEXP)) {
            try {
                this.toolName = this.stringRepresentation.replaceAll(REGEXP, "$1");
                this.major = this.stringRepresentation.replaceAll(REGEXP, "$2");
                this.minor = this.stringRepresentation.replaceAll(REGEXP, "$3");
                this.micro = this.stringRepresentation.replaceAll(REGEXP, "$4");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public int hashCode() {
        return Objects.hash(this.stringRepresentation);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ToolVersion)) {
            return false;
        }
        return this.compareTo((ToolVersion)obj) == 0;
    }

    @Override
    public int compareTo(ToolVersion o) {
        if (o == null) {
            return 1;
        }
        if (this.major == null || this.minor == null || this.micro == null) {
            return this.compareStrings(o.stringRepresentation);
        }
        if (!this.toolName.equals(o.toolName)) {
            return this.compareStrings(o.stringRepresentation);
        }
        try {
            int compare = this.getCompare(this.major, o.major);
            if (compare == 0) {
                compare = this.getCompare(this.minor, o.minor);
            }
            if (compare == 0) {
                compare = this.getCompare(this.micro, o.micro);
            }
            return compare;
        }
        catch (NumberFormatException nfe) {
            return this.compareStrings(o.stringRepresentation);
        }
    }

    private int compareStrings(String otherString) {
        int compareValue = this.stringRepresentation.compareTo(otherString);
        if (compareValue == 0) {
            return 0;
        }
        return compareValue < 0 ? -1 : 1;
    }

    private int getCompare(String x, String y) throws NumberFormatException {
        Integer xNum = Integer.parseInt(x);
        Integer yNum = Integer.parseInt(y);
        return xNum.compareTo(yNum);
    }
}

