/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.lismo3_0.api;

import com.modelengineers.lismo3_0.api.LismoConfig;
import com.modelengineers.lismo3_0.api.exceptions.ConfigurationFileDoesNotExistException;
import com.modelengineers.lismo3_0.api.exceptions.LismoSettingsFileCouldNotBeLoadedException;
import com.modelengineers.lismo3_0.api.exceptions.LismoSettingsFileCouldNotBeSavedException;
import com.modelengineers.lismo3_0.api.exceptions.LismoSettingsFileNotFoundException;
import com.modelengineers.lismo3_0.internal.FlexeraApiAccess;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class LismoSettings {
    private LismoConfig lismoConfig;
    private String lismoConfigFilePath;

    public LismoSettings(String string) throws LismoSettingsFileNotFoundException, LismoSettingsFileCouldNotBeLoadedException {
        this.lismoConfigFilePath = string;
        this.lismoConfig = new LismoConfig(string);
        this.loadConfigFromFile(true);
        Path path = this.getGlobalLicenseFilePath();
        if (path != null && !LismoSettings.isValidConfigured(this.lismoConfig)) {
            this.lismoConfigFilePath = path.toString();
            this.lismoConfig = new LismoConfig(path.toString());
            this.loadConfigFromFile(true);
        }
    }

    public static boolean isValidConfiguration(File file) {
        if (!(file.exists() && file.canRead() && file.isFile())) {
            return false;
        }
        LismoConfig lismoConfig = new LismoConfig(file.getAbsolutePath());
        try {
            lismoConfig.loadConfigFile(false);
        }
        catch (Exception exception) {
            return false;
        }
        return LismoSettings.isValidConfigured(lismoConfig);
    }

    private Path getGlobalLicenseFilePath() {
        String string = LismoSettings.getCurrentLismoGlobalConfigDirectory();
        if (string == null) {
            return null;
        }
        return Paths.get(string, "lismo.config");
    }

    private static boolean isValidConfigured(LismoConfig lismoConfig) {
        return LismoSettings.licenseFileFound(LismoSettings.getLicenseFilePaths(lismoConfig)) || LismoSettings.getLicenseServerIds(lismoConfig) != null && !LismoSettings.getLicenseServerIds(lismoConfig).isEmpty();
    }

    private static boolean licenseFileFound(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        for (String string2 : string.split(File.pathSeparator)) {
            File file = new File(string2);
            if (file.isFile()) {
                return true;
            }
            if (!file.isDirectory()) continue;
            return file.listFiles(new OnlyFileFilter()).length > 0;
        }
        return false;
    }

    private void loadConfigFromFile(boolean bl) throws LismoSettingsFileNotFoundException, LismoSettingsFileCouldNotBeLoadedException {
        try {
            this.lismoConfig.loadConfigFile(bl);
        }
        catch (ConfigurationFileDoesNotExistException configurationFileDoesNotExistException) {
            throw new LismoSettingsFileNotFoundException(this.lismoConfigFilePath, false);
        }
        catch (IOException iOException) {
            throw new LismoSettingsFileCouldNotBeLoadedException(this.lismoConfigFilePath, iOException);
        }
    }

    public static String getLismoLibraryDirectory() {
        Path path = FlexeraApiAccess.getLismoLibraryDirectory();
        return path != null ? path.toString() : null;
    }

    public static String getCurrentLismoGlobalConfigDirectory() {
        Path path = FlexeraApiAccess.getGlobalLicenseConfigDirectory();
        LismoSettings.restoreOldConfigIfNecessary(path);
        return path != null ? path.toString() : null;
    }

    private static void restoreOldConfigIfNecessary(Path path) {
        File file;
        File file2 = new File(path.toFile(), "./lismo.config");
        if (!file2.exists() && (file = new File(path.toFile(), "3.0/./lismo.config")).exists()) {
            try {
                Files.copy(file.toPath(), file2.toPath(), new CopyOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void saveConfigToFile() throws LismoSettingsFileCouldNotBeSavedException {
        try {
            this.lismoConfig.saveConfigFile();
        }
        catch (Exception exception) {
            throw new LismoSettingsFileCouldNotBeSavedException(this.lismoConfigFilePath);
        }
    }

    public String getLicenseFilePaths() {
        return LismoSettings.getLicenseFilePaths(this.lismoConfig);
    }

    public static String getLicenseFilePaths(LismoConfig lismoConfig) {
        return lismoConfig.getConfiguration("license_file_dir", false);
    }

    public void setLicenseFilePath(String string) {
        this.lismoConfig.addConfiguration("license_file_dir", string);
    }

    public String getLicenseServerIds() {
        return LismoSettings.getLicenseServerIds(this.lismoConfig);
    }

    public static String getLicenseServerIds(LismoConfig lismoConfig) {
        return lismoConfig.getConfiguration("license_server_id", false);
    }

    public void setLicenseServerIds(String string) {
        this.lismoConfig.addConfiguration("license_server_id", string);
    }

    private static class OnlyFileFilter
    implements FileFilter {
        private OnlyFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isFile();
        }
    }
}

