/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.lismo3_0.api;

import com.modelengineers.lismo3_0.api.CheckoutCallback;
import com.modelengineers.lismo3_0.api.CheckoutFuture;
import com.modelengineers.lismo3_0.api.IdleTimer;
import com.modelengineers.lismo3_0.api.LicenseChangeListener;
import com.modelengineers.lismo3_0.api.LicenseInformation;
import com.modelengineers.lismo3_0.api.LicenseStatus;
import com.modelengineers.lismo3_0.api.exceptions.LicenseBorrowException;
import com.modelengineers.lismo3_0.api.exceptions.LicenseCheckoutAlreadyQueuedException;
import com.modelengineers.lismo3_0.api.exceptions.LicenseNotAvailableException;
import com.modelengineers.lismo3_0.api.exceptions.LismoException;
import com.modelengineers.lismo3_0.api.exceptions.LismoInitializationException;
import com.modelengineers.lismo3_0.internal.CheckoutOption;
import com.modelengineers.lismo3_0.internal.FLEXlmErrorCode;
import com.modelengineers.lismo3_0.internal.FLEXlmSession;
import com.modelengineers.lismo3_0.internal.FLEXlmSessionManager;
import com.modelengineers.lismo3_0.internal.FLEXlmSetupParameter;
import com.modelengineers.lismo3_0.internal.Feature;
import com.modelengineers.lismo3_0.internal.FlexeraApiAccess;
import com.modelengineers.lismo3_0.internal.GroupDuplicatesOption;
import com.modelengineers.lismo3_0.internal.InternalLicenseChangeListener;
import com.modelengineers.lismo3_0.internal.License;
import com.modelengineers.lismo3_0.internal.LicenseParameters;
import com.modelengineers.lismo3_0.internal.LismoLogger;
import com.modelengineers.lismo3_0.internal.ReconnectCallback;
import com.modelengineers.lismo3_0.internal.ReconnectDoneCallback;
import com.modelengineers.lismo3_0.internal.exceptions.FLEXlmException;
import java.io.File;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Lismo {
    private static final int CHECKOUT_THREAD_WAITTIME = 1;
    private static final String ADDED_LICENSE_TO_QUEUE = "Adding of license ''{0}'' to queue successful.";
    private static final String LICENSE_ALREADY_CHECKED_OUT = "Requested license [{0}] in version [{1}] for tool [{2}] is already checked out.";
    private static final String CHECK_OUT_LICENSE = "Check out of license ''{0}'' {1}.";
    private static final String CHECK_OUT_QUEUED_LICENSE = "Queued check out of license ''{0}'' {1}.";
    private static final String BORROWED_LICENSE = "License ''{0}'' borrowed until {1}.";
    private static final int LM_A_BORROW_EXPIRE = 93;
    private static final ReconnectCallback RECONNECT_CALLBACK = new ReconnectCallback(){

        @Override
        public int callback(long l, String string, int n, int n2, int n3) {
            FLEXlmSession fLEXlmSession = FLEXlmSessionManager.INSTANCE.findSessionFor(l);
            if (fLEXlmSession != null) {
                fLEXlmSession.notifyReconnecting(string, n, n2, n3);
            }
            return 0;
        }
    };
    private static final ReconnectDoneCallback RECONNECT_DONE_CALLBACK = new ReconnectDoneCallback(){

        @Override
        public int callback(long l, String string, int n, int n2, int n3) {
            FLEXlmSession fLEXlmSession = FLEXlmSessionManager.INSTANCE.findSessionFor(l);
            if (fLEXlmSession != null) {
                fLEXlmSession.notifyReconnected(string, n, n2, n3);
            }
            return 0;
        }
    };
    private final Logger LOG;
    private final String toolIdentifier;
    private final Map<License, AtomicReference<CheckoutFuture>> queuedLicenses = Collections.synchronizedMap(new HashMap());
    private final List<License> checkedOutLicenses = Collections.synchronizedList(new ArrayList());
    private final Set<License> scheduledforCheckin = Collections.synchronizedSet(new HashSet());
    private final String licenseSourceLocations;
    private FLEXlmSession session;
    private final LismoLicenseChangeListener licenseChangeListener = new LismoLicenseChangeListener();
    private final boolean linger;
    private String borrowingExpirationDateAndTime;
    public final boolean IGNORE_STOP_IDLE_LICENSE_CHECK_THREAD = false;
    private final List<LicenseChangeListener> licenseChangeListeners = Collections.synchronizedList(new ArrayList());
    private IdleTimer idleTimer;
    private final ExecutorService checkoutExecutor = Executors.newCachedThreadPool();

    public Lismo(String string, List<String> list, String string2) {
        this(string, list, string2, false);
    }

    public Lismo(String string, List<String> list, String string2, boolean bl) {
        this.LOG = LismoLogger.initLoggerForLismoClass(string, string2);
        this.toolIdentifier = string;
        this.licenseSourceLocations = Lismo.toString(list);
        this.linger = bl;
    }

    private static String toString(List<String> list) {
        if (list == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder("");
        for (String string : list) {
            if (string == null || string.isEmpty()) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(File.pathSeparator);
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public Lismo addLicenseChangeListener(LicenseChangeListener licenseChangeListener) {
        this.licenseChangeListeners.add(licenseChangeListener);
        return this;
    }

    public void checkout(String string, String string2) throws LismoException {
        this.checkout(string, string2, false).waitForCheckout(1L, TimeUnit.MINUTES);
    }

    public CheckoutFuture checkout(String string, String string2, boolean bl) throws LismoInitializationException, LicenseCheckoutAlreadyQueuedException {
        return this.checkout(string, string2, bl, null);
    }

    public CheckoutFuture checkout(String string, String string2, boolean bl, CheckoutCallback checkoutCallback) throws LismoInitializationException, LicenseCheckoutAlreadyQueuedException {
        return this.checkout(string, string2, bl && this.borrowingExpirationDateAndTime == null ? CheckoutOption.LM_CO_QUEUE : CheckoutOption.LM_CO_NOWAIT, checkoutCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized CheckoutFuture checkout(String string, String string2, CheckoutOption checkoutOption, CheckoutCallback checkoutCallback) throws LismoInitializationException, LicenseCheckoutAlreadyQueuedException {
        Object object;
        License license;
        Object object2;
        this.ensureInitialized();
        this.setIdle(false);
        if (checkoutOption == CheckoutOption.LM_CO_QUEUE) {
            object2 = this.queuedLicenses;
            synchronized (object2) {
                license = this.getQueuedLicense(string, string2);
                if (license != null && (object = this.queuedLicenses.get(license).get()) != null) {
                    return object;
                }
            }
        } else if (this.alreadyCheckedOutLicenseCanBeUsed(string, string2)) {
            this.LOG.info(MessageFormat.format(LICENSE_ALREADY_CHECKED_OUT, string, string2, this.toolIdentifier));
            return new CheckoutFuture(true);
        }
        object2 = new Feature(string, string2);
        license = new License(this.session, (Feature)object2, this.toolIdentifier, this.licenseChangeListener);
        license.setDupGroup(this.linger ? GroupDuplicatesOption.LM_DUP_USER : LicenseParameters.FNL_DUP_GROUP);
        license.setLinger(this.linger ? 28800 : 0);
        license.setQueueMode(checkoutOption);
        object = new AtomicReference();
        CheckoutFuture checkoutFuture = new CheckoutFuture(this.checkoutExecutor.submit(new CheckoutTask(license, checkoutOption, (AtomicReference)object, checkoutCallback)), license);
        ((AtomicReference)object).set(checkoutFuture);
        return checkoutFuture;
    }

    private boolean alreadyCheckedOutLicenseCanBeUsed(String string, String string2) throws LicenseCheckoutAlreadyQueuedException {
        License license = this.getCheckedOutLicense(string, string2);
        if (license == null) {
            license = this.getQueuedLicense(string, string2);
            if (license == null) {
                return false;
            }
            CheckoutFuture checkoutFuture = this.queuedLicenses.get(license).get();
            if (checkoutFuture != null) {
                throw new LicenseCheckoutAlreadyQueuedException("License has already been queued. Checkout future must be used to wait for the license.", checkoutFuture);
            }
        }
        return license.cancelCheckin();
    }

    public void enableBorrowing(String string) throws LismoInitializationException, LicenseBorrowException {
        if (this.borrowingExpirationDateAndTime != null) {
            if (!Objects.equals(this.borrowingExpirationDateAndTime, string)) {
                throw new LicenseBorrowException("Cannot change expiration date and time for borrow of licenses.");
            }
            return;
        }
        try {
            new DateAndOptionalTimeFormat().parse(string);
        }
        catch (ParseException parseException) {
            throw new LicenseBorrowException("Failed to enable borrowing. Format of expiration date and time is invalid.", parseException);
        }
        try {
            this.ensureInitialized();
            this.session.setAttribute(93, "LM_A_BORROW_EXPIRE", string);
            this.LOG.info(MessageFormat.format("Enabled borrowing licenses until {0}.", string));
            this.borrowingExpirationDateAndTime = string;
        }
        catch (FLEXlmException fLEXlmException) {
            throw new LicenseBorrowException("Failed to enable borrowing.", fLEXlmException);
        }
    }

    public void returnBorrowedLicense(String string) throws LismoException {
        if (this.session == null) {
            return;
        }
        License license = this.getLicense(string, null);
        if (license != null) {
            try {
                this.session.returnBorrowedLicense(string);
                this.removeInactiveLicense(license);
            }
            catch (FLEXlmException fLEXlmException) {
                FLEXlmErrorCode.handle("Failed to return borrowed license.", fLEXlmException);
            }
        } else {
            throw new LicenseBorrowException("License was not checked out and therefore cannot be returned to the server.");
        }
    }

    public LicenseInformation getLicenseInformation(String string, String string2) throws LicenseNotAvailableException {
        this.LOG.info("License information requested.");
        this.setIdle(false);
        License license = this.getCheckedOutLicense(string, string2);
        if (license == null) {
            throw new LicenseNotAvailableException("Requested feature is not checked out. No license information available.");
        }
        try {
            return license.getInformation();
        }
        catch (FLEXlmException fLEXlmException) {
            throw new LicenseNotAvailableException("Failed to read license information.", fLEXlmException);
        }
    }

    public boolean isLicenseBound(String string, String string2) {
        this.setIdle(false);
        return this.getCheckedOutLicense(string, string2) != null;
    }

    public void checkin(String string, String string2) {
        this.checkin(string, string2, 0);
    }

    public void checkin(String string, String string2, int n) {
        this.checkin(this.getLicense(string, string2), n);
    }

    private void checkin(License license, int n) {
        if (license != null) {
            this.setIdle(false);
            license.checkin(n);
            if (n > 0) {
                this.scheduledforCheckin.add(license);
            }
        }
    }

    final synchronized void setIdle(boolean bl) {
        if (this.session == null) {
            return;
        }
        Objects.requireNonNull(this);
        this.session.setIdle(bl);
        if (bl) {
            this.stopIdleTimer();
            this.revokeLicenses();
        } else {
            this.restartIdleTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revokeLicenses() {
        if (this.session == null) {
            return;
        }
        ArrayList<License> arrayList = new ArrayList<License>();
        Iterator iterator = this.queuedLicenses;
        synchronized (iterator) {
            arrayList.addAll(this.queuedLicenses.keySet());
        }
        iterator = this.checkedOutLicenses;
        synchronized (iterator) {
            arrayList.addAll(this.checkedOutLicenses);
        }
        this.session.checkInAll();
        for (License license : arrayList) {
            if (this.scheduledforCheckin.contains(license)) continue;
            this.removeInactiveLicense(license);
            List<LicenseChangeListener> list = this.licenseChangeListeners;
            synchronized (list) {
                for (LicenseChangeListener licenseChangeListener : this.licenseChangeListeners) {
                    licenseChangeListener.licenseRevoked(license.getFeature().getName(), license.getFeature().getVersion());
                }
            }
        }
    }

    public synchronized void startIdleTimer(int n) {
        if (this.idleTimer != null) {
            this.idleTimer.stop();
        }
        this.idleTimer = new IdleTimer(this, n);
        this.idleTimer.start();
    }

    public synchronized boolean restartIdleTimer() {
        if (this.idleTimer != null) {
            return this.idleTimer.restart();
        }
        return false;
    }

    public synchronized void stopIdleTimer() {
        if (this.idleTimer != null) {
            this.idleTimer.stop();
        }
    }

    private License getLicense(String string, String string2) {
        License license = this.getCheckedOutLicense(string, string2);
        if (license != null) {
            return license;
        }
        return this.getQueuedLicense(string, string2);
    }

    private License getCheckedOutLicense(String string, String string2) {
        return this.findLicense(string, string2, this.checkedOutLicenses);
    }

    private License getQueuedLicense(String string, String string2) {
        return this.findLicense(string, string2, this.queuedLicenses.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private License findLicense(String string, String string2, Collection<License> collection) {
        Collection<License> collection2 = collection;
        synchronized (collection2) {
            for (License license : collection) {
                if (!license.isLicenseFor(string, string2)) continue;
                return license;
            }
        }
        return null;
    }

    private void removeInactiveLicense(License license) {
        if (this.scheduledforCheckin.remove(license)) {
            license.cancelCheckin();
        }
        this.queuedLicenses.remove(license);
        this.checkedOutLicenses.remove(license);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllLicenses() {
        ArrayList<License> arrayList = new ArrayList<License>();
        Iterator iterator = this.queuedLicenses;
        synchronized (iterator) {
            arrayList.addAll(this.queuedLicenses.keySet());
        }
        iterator = this.checkedOutLicenses;
        synchronized (iterator) {
            arrayList.addAll(this.checkedOutLicenses);
        }
        for (License license : arrayList) {
            this.removeInactiveLicense(license);
            List<LicenseChangeListener> list = this.licenseChangeListeners;
            synchronized (list) {
                for (LicenseChangeListener licenseChangeListener : this.licenseChangeListeners) {
                    licenseChangeListener.licenseCheckedIn(license.getFeature().getName(), license.getFeature().getVersion());
                }
            }
        }
    }

    public void checkinAllLicenses() {
        this.setIdle(false);
        if (this.session == null) {
            return;
        }
        this.session.checkInAll();
    }

    public void tearDown() {
        this.stopIdleTimer();
        this.idleTimer = null;
        this.setIdle(false);
        this.queuedLicenses.clear();
        this.checkoutExecutor.shutdownNow();
        try {
            this.checkoutExecutor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        if (this.session != null) {
            this.LOG.info("Tearing down license module.");
            FLEXlmSessionManager.INSTANCE.teardown(this.session);
            LismoLogger.teardown(this.toolIdentifier);
        }
    }

    private void ensureInitialized() throws LismoInitializationException {
        if (this.session != null) {
            return;
        }
        try {
            this.session = FLEXlmSessionManager.INSTANCE.newInstance(this.licenseChangeListener).setAttribute(FLEXlmSetupParameter.LM_A_LICENSE_DEFAULT, this.licenseSourceLocations).setAttribute(FLEXlmSetupParameter.LM_A_DISABLE_ENV, 0).setAttribute(FLEXlmSetupParameter.LM_A_RETRY_INTERVAL, 60).setAttribute(FLEXlmSetupParameter.LM_A_CHECK_INTERVAL, 60).setAttribute(FLEXlmSetupParameter.LM_A_RETRY_COUNT, -1).setAttribute(FLEXlmSetupParameter.LM_A_TCP_TIMEOUT, 180);
            this.LOG.info(MessageFormat.format("License Module initialized for [{0}].", this.toolIdentifier));
        }
        catch (FLEXlmException fLEXlmException) {
            throw new LismoInitializationException("Failed to initialize Lismo", fLEXlmException);
        }
    }

    static {
        FlexeraApiAccess.registerReconnectCallbacks(RECONNECT_CALLBACK, RECONNECT_DONE_CALLBACK);
    }

    static final class DateAndOptionalTimeFormat
    extends DateFormat {
        private static final long serialVersionUID = 3833252804009970540L;
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yyyy", Locale.ENGLISH);
        SimpleDateFormat dateAndTimeFormat = new SimpleDateFormat("dd-MMM-yyyy:HH:mm", Locale.ENGLISH);

        public DateAndOptionalTimeFormat() {
            this.setCalendar(Calendar.getInstance(Locale.ENGLISH));
            this.setLenient(false);
        }

        @Override
        public Date parse(String string, ParsePosition parsePosition) {
            Date date = this.dateAndTimeFormat.parse(string, parsePosition);
            if (date != null) {
                return date;
            }
            return this.dateFormat.parse(string, parsePosition);
        }

        @Override
        public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            return this.dateAndTimeFormat.format(date, stringBuffer, fieldPosition);
        }

        @Override
        public boolean equals(Object object) {
            return object != null && object.getClass() == this.getClass();
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.dateFormat, this.dateAndTimeFormat);
        }
    }

    private class LismoLicenseChangeListener
    implements InternalLicenseChangeListener {
        private LismoLicenseChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void licenseCheckedIn(License license) {
            Lismo.this.removeInactiveLicense(license);
            List list = Lismo.this.licenseChangeListeners;
            synchronized (list) {
                for (LicenseChangeListener licenseChangeListener : Lismo.this.licenseChangeListeners) {
                    licenseChangeListener.licenseCheckedIn(license.getFeature().getName(), license.getFeature().getVersion());
                }
            }
        }

        @Override
        public void checkedInAllLicenses() {
            Lismo.this.removeAllLicenses();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void licenseValidationFailed(String string) {
            Lismo.this.LOG.warning("Reconnecting to license server failed. Connection lost.");
            License license = Lismo.this.getLicense(string, null);
            if (license == null) {
                return;
            }
            Lismo.this.LOG.warning(MessageFormat.format("Revoking license ''{0}''.", string));
            Lismo.this.removeInactiveLicense(license);
            List list = Lismo.this.licenseChangeListeners;
            synchronized (list) {
                for (LicenseChangeListener licenseChangeListener : Lismo.this.licenseChangeListeners) {
                    licenseChangeListener.licenseRevoked(license.getFeature().getName(), license.getFeature().getVersion());
                }
            }
        }

        @Override
        public void licenseValidationPending(String string) {
            Lismo.this.LOG.info("Connection to license server lost. Trying to reconnect.");
        }

        @Override
        public void licenseValidationSuccessful(String string) {
            Lismo.this.LOG.info("Connection to license server reestablished");
        }

        @Override
        public void licenseRemovedFromQueue(License license) {
            Lismo.this.removeInactiveLicense(license);
        }
    }

    private class CheckoutTask
    implements Callable<Boolean> {
        private static final int QUEUED_LICENSE_STATUS_CHECK_INTERVAL_SECONDS = 5;
        private final MessageFormat WAITING_FOR_LICENSE_MESSAGE = new MessageFormat("Waiting for availability of ''{0}'' ' license.");
        private static final String LICENSE_CHECKED_OUT_MESSAGE = "License checked out";
        private final MessageFormat LICENSE_CHECKOUT_QUEUED_MESSAGE = new MessageFormat("Checkout of license ''{0}'' got queued.");
        private static final String QUEUED_LICENSE_CHECKOUT_CANCELED = "Queued license checkout got canceled.";
        private final License license;
        private final CheckoutOption mode;
        private final AtomicReference<CheckoutFuture> checkoutFutureRef;
        private final CheckoutCallback checkoutCallback;

        private CheckoutTask(License license, CheckoutOption checkoutOption, AtomicReference<CheckoutFuture> atomicReference, CheckoutCallback checkoutCallback) {
            this.license = license;
            this.mode = checkoutOption;
            this.checkoutFutureRef = atomicReference;
            this.checkoutCallback = checkoutCallback != null ? checkoutCallback : new CheckoutCallback(){

                @Override
                public void notify(String string, LicenseStatus licenseStatus) {
                }
            };
        }

        @Override
        public Boolean call() throws Exception {
            String string = this.license.getFeature().getName();
            try {
                boolean bl = this.license.checkout(1);
                if (bl) {
                    this.rememberCheckedOutLicense(this.license);
                    if (Lismo.this.borrowingExpirationDateAndTime == null) {
                        Lismo.this.LOG.info(MessageFormat.format(Lismo.CHECK_OUT_LICENSE, string, "successful"));
                    } else {
                        Lismo.this.LOG.info(MessageFormat.format(Lismo.BORROWED_LICENSE, string, Lismo.this.borrowingExpirationDateAndTime));
                    }
                    return true;
                }
                assert (CheckoutOption.LM_CO_QUEUE == this.mode);
                LicenseStatus licenseStatus = this.license.updateStatus();
                this.checkoutCallback.notify(this.LICENSE_CHECKOUT_QUEUED_MESSAGE.format(new Object[]{string}), licenseStatus);
                Lismo.this.queuedLicenses.put(this.license, this.checkoutFutureRef);
                Lismo.this.LOG.info(MessageFormat.format(Lismo.ADDED_LICENSE_TO_QUEUE, string));
                return this.pollForQueuedCheckout(this.license);
            }
            catch (FLEXlmException fLEXlmException) {
                String string2 = MessageFormat.format(Lismo.CHECK_OUT_LICENSE, string, "failed");
                Lismo.this.LOG.log(Level.SEVERE, string2, fLEXlmException);
                FLEXlmErrorCode.handle(string2, fLEXlmException);
                return false;
            }
        }

        public boolean pollForQueuedCheckout(License license) throws InterruptedException {
            try {
                while (Lismo.this.queuedLicenses.containsKey(license)) {
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    LicenseStatus licenseStatus = license.updateStatus();
                    if (licenseStatus == LicenseStatus.CHECKED_OUT) {
                        this.checkoutCallback.notify(LICENSE_CHECKED_OUT_MESSAGE, licenseStatus);
                        Lismo.this.queuedLicenses.remove(license);
                        this.rememberCheckedOutLicense(license);
                        Lismo.this.LOG.info(MessageFormat.format(Lismo.CHECK_OUT_QUEUED_LICENSE, license.getFeature().getName(), "successful"));
                        return true;
                    }
                    this.checkoutCallback.notify(this.WAITING_FOR_LICENSE_MESSAGE.format(new Object[]{license.getFeature().getName()}), licenseStatus);
                    Thread.sleep(5000L);
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            license.checkin();
            this.checkoutCallback.notify(QUEUED_LICENSE_CHECKOUT_CANCELED, LicenseStatus.NOT_CHECKED_OUT);
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rememberCheckedOutLicense(License license) {
            Lismo.this.checkedOutLicenses.add(license);
            Lismo.this.scheduledforCheckin.remove(license);
            List list = Lismo.this.licenseChangeListeners;
            synchronized (list) {
                for (LicenseChangeListener licenseChangeListener : Lismo.this.licenseChangeListeners) {
                    licenseChangeListener.licenseCheckedOut(license.getFeature().getName(), license.getFeature().getVersion());
                }
            }
        }
    }
}

