/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.lismo3_0.api;

import com.modelengineers.lismo3_0.api.exceptions.LicenseNotAvailableException;
import com.modelengineers.lismo3_0.api.exceptions.LismoException;
import com.modelengineers.lismo3_0.internal.License;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CheckoutFuture {
    private final Future<Boolean> future;
    private final License license;
    private final Boolean result;

    CheckoutFuture(boolean bl) {
        this.future = null;
        this.license = null;
        this.result = bl;
    }

    CheckoutFuture(Future<Boolean> future, License license) {
        assert (future != null);
        assert (license != null);
        this.future = future;
        this.license = license;
        this.result = null;
    }

    public boolean waitForCheckout(long l, TimeUnit timeUnit) throws LismoException {
        if (this.future == null) {
            return this.result;
        }
        try {
            return this.future.get(l, timeUnit);
        }
        catch (TimeoutException timeoutException) {
            this.future.cancel(true);
            this.license.checkin();
            throw new LicenseNotAvailableException("Timeout while waiting for license checkout.", timeoutException);
        }
        catch (CancellationException cancellationException) {
            throw new LicenseNotAvailableException("Canceled during wait for license checkout.", cancellationException);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new LicenseNotAvailableException("Interrupted during wait for license checkout.", interruptedException);
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof LismoException) {
                throw (LismoException)throwable;
            }
            throw new LicenseNotAvailableException("Failed to checkout license.", throwable);
        }
    }

    public boolean cancelCheckout() {
        return this.future != null && this.future.cancel(true);
    }

    public boolean checkoutCompleted() {
        return this.future == null || this.future.isDone();
    }
}

