function path_MoRe(b_Add)
    if nargin < 1
        b_Add = true;
    end
    loc_path_more(b_Add);
end

function loc_path_more(b_Add)
    paths = loc_getPaths();
    if b_Add
        addpath(paths{:}, '-end');
        loc_createConfigFilesInAppDataAndAddToPath();
        loc_createLismoConfigFileInAppDataIfLismoDirDoesNotExist();
        loc_createEmptyLicenseDirIfNotExist();
        loc_addJarToJavaPathWithClassCheck(mes.more.LismoConfig.LismoJarFullPath, 'com.modelengineers.lismo3_0.api.Lismo');
        loc_doOnAllJarsFromLibsFolder(@loc_addJarToJavaPath);
    else
        loc_doOnAllJarsFromLibsFolder(@loc_rmJarFromJavaPath);
        loc_rmJarFromJavaPath(mes.more.LismoConfig.LismoJarFullPath);
        rmpath(mes.more.ToolAppData.PreferencesDir);
        rmpath(paths{:});
    end
end

function paths = loc_getPaths()
    moreBasePath = fileparts(mfilename('fullpath'));
    corePaths = loc_getPathsForFolder(moreBasePath, 'core');
    demoModelsPaths = loc_getPathsForFolder(moreBasePath, 'demo_models');
    mesUtilsPaths = loc_getMesUtilsPaths(moreBasePath);
    paths = [moreBasePath, corePaths, demoModelsPaths, mesUtilsPaths];
end

function pathsForFolder = loc_getPathsForFolder(moreBasePath, folderName)
    pathToFolder = fullfile(moreBasePath, folderName);
    pathsForFolder = genpath(pathToFolder);
end

function mesUtilsPaths = loc_getMesUtilsPaths(moreBasePath)
    mesUtilsPaths = {fullfile(moreBasePath, 'libs', 'mesUtils')};
end

function loc_createConfigFilesInAppDataAndAddToPath()
    mes.more.config.createConfigFilesInAppData();
    addpath(mes.more.ToolAppData.PreferencesDir, '-end');
end

function loc_createLismoConfigFileInAppDataIfLismoDirDoesNotExist()
    if ~exist(mes.more.LismoConfig.LismoAppDataPath, 'file')
        mes.more.LismoConfig.createLismoConfigFile();
    end
end

function loc_createEmptyLicenseDirIfNotExist()
    if ~exist(mes.more.LismoConfig.ToolLicenseDir, 'dir')
        % Folder may be read-only. Then it's better not to create the local license
        % dir than to abort with an error. The local license dir is only important
        % if someone wants to put their licenses in there out of habit. However,
        % any other dir can be configured as local license dir in the License
        % Manager.
        try
            mkdir(mes.more.LismoConfig.ToolLicenseDir);
        catch
        end
    end
end

function loc_doOnAllJarsFromLibsFolder(func)
    cellfun(@(p) func(p), loc_getPathsOfJarsFromLibsFolder());
end

function jarPaths = loc_getPathsOfJarsFromLibsFolder()
    moreBasePath = fileparts(mfilename('fullpath'));
    folder = fullfile(moreBasePath, 'libs');
    % dir with '**' does not work for ML ver older than 2016b, so we need to
    % use our own file search.
    jarPaths = loc_findFiles(folder, 'jar');
end

function filePaths = loc_findFiles(folder, extension)
    files = dir([folder, '\*.', extension]);
    fileNames = {files.name};
    filePaths = fullfile(folder, fileNames);
    items = dir(folder);
    for i = 1 : length(items)
        item = items(i);
        if item.isdir && ~(strcmp(item.name, '.') || strcmp(item.name, '..'))
            fullPath = fullfile(folder, item.name);
            subFolderFiles = loc_findFiles(fullPath, extension);
            if ~isempty(subFolderFiles)
                filePaths = [filePaths, subFolderFiles];
            end
        end
    end
end

function loc_addJarToJavaPathWithClassCheck(fullPathOfJar, classToCheck)
    if ~exist(classToCheck, 'class')
        javaaddpath(fullPathOfJar);
    end
end

function loc_addJarToJavaPath(fullPathOfJar)
    classpath = javaclasspath('-all');
    [~, jarFileName, jarEnding] = fileparts(fullPathOfJar);
    jarFileNameWithEnding = [jarFileName, jarEnding];
    jarAlreadyInClassPath = any(mes.more_mes.ml.string.contains(classpath, jarFileNameWithEnding));
    if ~jarAlreadyInClassPath
       javaaddpath(fullPathOfJar);
   end
end

function loc_rmJarFromJavaPath(fullPathOfJar)
    classpath = javaclasspath('-all');
    if ismember(fullPathOfJar, classpath)
        javarmpath(fullPathOfJar);
    end
end