% Determine if an expression is an enumeration object.
%
% Input
%     inputVar - Some variable or expression. Mandatory.
%
% Output
%     isEnum   - Return true, if inputVar is an Enumeration object.
%                Return false otherwise.
%                Always return false on MATLAB prior to R2009b.
%
% Please note:
%    When trying to separate enumerations from other objects or numeric non-object values,
%    check isEnumType first!
%    That is because enumerations are both, numeric (isnumeric(SlDemoSign.Positive) == true)
%    and objects (isObjectType(SlDemoSign.Positive) == true).
%
% Example
% >> false == isEnumType(0)
% >> true  == isEnumType(SlDemoSign.Positive)
