% Determine if char array string ends with another string
%
% As Matlab's endsWith function is only available since R2016b, this
% function is a rudimentary substitute for older Matlab versions.
% As the original, this function is case-sensitive and returns always true
% if the second input is the empty string.
% Currently, function is 'rudimentary' substitute of the original as it
% does not support:
% (1) the ending parameter as cell array;
% (2) the 'IgnoreCase' option to explicitly determine case sensitivy.
%
% Syntax: TF = endsWith(str, ending)
%
% Inputs
%   str    - char array string whose ending is compared against the
%            second input, or cell array of char array strings
%   ending - char array string that is compared against the ending of the
%            first input
% 
% Outputs
%   TF - true if first input ends with second input, otherwise false
%
% Examples
%   >> endsWith('hello', 'bar')            % ans = false
%   >> endsWith('hello', 'lo')             % ans = true
%   >> endsWith({'pete', 'paul'}, 'ul')    % ans = [false, true]
