% self = more_hashtable(['PropertyName', PropertyValue, ...])
%
% properties:
%   'size'    - initial capacity of the hash table (default = 100)
%
%   'load'    - initial load factor (ratio of # contents / size
%               above which the size will automatically be increased,
%               default = 0.75)
%
%   'equals'  - the function (handle) to use for testing key equality.
%               The default works for integers, reals, complex numbers, 
%               strings, matrices, structs, and cell arrays of the above,
%               but of course may not be efficient or suitable for your
%               particular data structure.  If you supply a new equality 
%               function, you should probably also supply a new hashcode 
%               function.  Equality functions should take two inputs and
%               return a boolean.
%
%   'hash'    - the hashcode function to use to generate hash values
%               for keys of the table.  The default works well only
%               with numbers, strings, and matrices.
%               Structs, cell arrays, etc. will get a very weak hash, so
%               you'll need to supply a better hashcode function if you
%               want to use these as keys.
%
%   'grow'    - factor by which to increase the size of the hashtable
%               when needed (default = 1.5)
%
% Notes:
%   The hashcode function is further enhanced by a simple internal hashing
%   function which tries to help ensure even spreading over the available
%   slots; however, no attempt has been made to provide a "perfect" hash.
%
%   The default equality function may or may not define equality in a way
%   that you will like.  In general, if you use keys that are all of the
%   same type, the equality function should distinguish keys that are
%   different.  Numerical values are compared using ==, so double(1)
%   "equals" int8(1).  Cell arrays and matrices are compared recursively,
%   element by element.  Structs are compared first by field names, then
%   recursively by individual fields.  Objects (instances of a class) are
%   compared if the method 'eq' is properly defined for the class,
%   otherwise they are assumed non-equal.
%
