/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.lismo3_0.internal;

import com.modelengineers.lismo3_0.internal.FlexeraApi;
import com.modelengineers.lismo3_0.internal.ReconnectCallback;
import com.modelengineers.lismo3_0.internal.ReconnectDoneCallback;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class FlexeraApiAccess {
    private static final String NATIVE_LIBRARY_VERSION = "3.4";
    private static final String FLEXERA_API = "FlexeraApi";
    private static final String FLEXERA_API_DLL = "FlexeraApi.dll";
    private static final String FLEXERA_API_SO = "libFlexeraApi.so";
    static final FlexeraApi INSTANCE = (FlexeraApi)Native.synchronizedLibrary(Native.loadLibrary(FlexeraApiAccess.getLibraryPath(), FlexeraApi.class));
    public static final String NATIVE_LIBRARY_PATH_VAR = "lismoNativeLibraryPath";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getLibraryPath() {
        Object object;
        String string = null;
        if (Platform.isWindows()) {
            string = FLEXERA_API_DLL;
        } else if (Platform.isLinux()) {
            string = FLEXERA_API_SO;
        }
        if (string == null) return FLEXERA_API;
        String string2 = System.getProperty(NATIVE_LIBRARY_PATH_VAR);
        if (string2 != null && ((File)(object = new File(string2, string).getAbsoluteFile())).isFile()) {
            return ((File)object).getPath();
        }
        try {
            object = FlexeraApiAccess.class.getClassLoader().getResourceAsStream(string);
            try {
                Object object2;
                if (object == null) return FLEXERA_API;
                Path path = null;
                Path path2 = FlexeraApiAccess.getLismoLibraryDirectory();
                if (path2 != null) {
                    object2 = path2.toFile();
                    if (!((File)object2).isDirectory()) {
                        ((File)object2).mkdirs();
                    }
                    path = path2.resolve(string);
                } else {
                    path2 = Files.createTempDirectory("lismoNatives", new FileAttribute[0]);
                    path2.toFile().deleteOnExit();
                    path = path2.resolve(string);
                    path.toFile().deleteOnExit();
                }
                if (!path.toFile().isFile()) {
                    Files.copy((InputStream)object, path, StandardCopyOption.REPLACE_EXISTING);
                }
                object2 = path.toAbsolutePath().toString();
                return object2;
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return FLEXERA_API;
    }

    public static Path getGlobalLicenseConfigDirectory() {
        Path path = FlexeraApiAccess.getLismoLibraryDirectory();
        if (path == null) {
            return null;
        }
        return path.getParent();
    }

    public static Path getLismoLibraryDirectory() {
        String string = FlexeraApiAccess.getUserHome();
        if (string != null) {
            if (Platform.isWindows()) {
                return Paths.get(FlexeraApiAccess.getUserHome(), "MES", "LISMO", NATIVE_LIBRARY_VERSION);
            }
            if (Platform.isLinux()) {
                return Paths.get(FlexeraApiAccess.getUserHome(), ".mes", "lismo", NATIVE_LIBRARY_VERSION);
            }
        }
        return null;
    }

    private static String getUserHome() {
        String string = null;
        if (Platform.isWindows()) {
            string = System.getenv("APPDATA");
        }
        if (string == null || string.trim().isEmpty()) {
            string = System.getProperty("user.home");
        }
        return string;
    }

    private FlexeraApiAccess() {
    }

    public static void registerReconnectCallbacks(ReconnectCallback reconnectCallback, ReconnectDoneCallback reconnectDoneCallback) {
        INSTANCE.registerReconnectCallback(reconnectCallback);
        INSTANCE.registerReconnectDoneCallback(reconnectDoneCallback);
    }
}

