/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.lismo3_0.internal;

import com.modelengineers.lismo3_0.api.LicenseInformation;
import com.modelengineers.lismo3_0.api.LicenseStatus;
import com.modelengineers.lismo3_0.internal.ConfigType;
import com.modelengineers.lismo3_0.internal.FLEXlmErrorCode;
import com.modelengineers.lismo3_0.internal.FLEXlmSetupParameter;
import com.modelengineers.lismo3_0.internal.Feature;
import com.modelengineers.lismo3_0.internal.FlexeraApi;
import com.modelengineers.lismo3_0.internal.FlexeraApiAccess;
import com.modelengineers.lismo3_0.internal.InternalLicenseChangeListener;
import com.modelengineers.lismo3_0.internal.exceptions.FLEXlmException;
import java.text.MessageFormat;

public class FLEXlmSession {
    private final long handle;
    private final InternalLicenseChangeListener listener;
    private boolean alive = true;

    public FLEXlmSession(InternalLicenseChangeListener internalLicenseChangeListener) throws FLEXlmException {
        this.listener = internalLicenseChangeListener;
        this.handle = FlexeraApiAccess.INSTANCE.createNewJob();
        if (this.handle == 0L) {
            throw new FLEXlmException("Failed to initialize FLEXlm session.", 0);
        }
        FlexeraApiAccess.INSTANCE.setReconnectCallback(this.handle);
        FlexeraApiAccess.INSTANCE.setReconnectDoneCallback(this.handle);
    }

    public FLEXlmSession setAttribute(FLEXlmSetupParameter fLEXlmSetupParameter, Object object) throws FLEXlmException {
        if (object == null) {
            object = fLEXlmSetupParameter.getDefaultValue();
        }
        return this.setAttribute(fLEXlmSetupParameter.getID(), fLEXlmSetupParameter.name(), object);
    }

    public FLEXlmSession setAttribute(int n, String string, Object object) throws FLEXlmException {
        int n2 = 0;
        if (object instanceof Boolean) {
            n2 = FlexeraApiAccess.INSTANCE.setBooleanAttribute(this.handle, n, (Boolean)object);
        } else if (object instanceof Integer) {
            n2 = FlexeraApiAccess.INSTANCE.setIntegerAttribute(this.handle, n, (Integer)object);
        } else if (object instanceof String) {
            n2 = FlexeraApiAccess.INSTANCE.setStringAttribute(this.handle, n, (String)object);
        } else {
            throw new IllegalArgumentException(MessageFormat.format("Value ''{0}'' for parameter ''{1}'' could not be set, because the type is not supported.", object, string));
        }
        if (n2 != 0) {
            throw this.exceptionWithLastError();
        }
        return this;
    }

    public void checkOut(Feature feature, int n, int n2, int n3) throws FLEXlmException {
        int n4 = FlexeraApiAccess.INSTANCE.checkOut(this.handle, feature.getName(), feature.getVersion(), n, n2, n3);
        if (n4 != 0) {
            throw this.exceptionWithLastError();
        }
    }

    public void checkIn(Feature feature) {
        FlexeraApiAccess.INSTANCE.checkIn(this.handle, feature.getName());
    }

    public void checkInAll() {
        FlexeraApiAccess.INSTANCE.checkInAll(this.handle);
        this.listener.checkedInAllLicenses();
    }

    public synchronized void tearDown() {
        this.checkInAll();
        FlexeraApiAccess.INSTANCE.freeJob(this.handle);
        this.alive = false;
    }

    public int getLastErrorNumber() {
        return FlexeraApiAccess.INSTANCE.getErrorNumber(this.handle);
    }

    public String getLastErrorText() {
        return FlexeraApiAccess.INSTANCE.getErrorText(this.handle);
    }

    public LicenseStatus getStatus(Feature feature) {
        return LicenseStatus.get(FlexeraApiAccess.INSTANCE.getStatus(this.handle, feature.getName()));
    }

    public boolean isSessionFor(long l) {
        return this.handle == l;
    }

    public void notifyReconnecting(String string, int n, int n2, int n3) {
        if (n > 3) {
            this.listener.licenseValidationFailed(string);
        } else {
            this.listener.licenseValidationPending(string);
        }
    }

    public void notifyReconnected(String string, int n, int n2, int n3) {
        this.listener.licenseValidationSuccessful(string);
    }

    public LicenseInformation getLicenseInformation(Feature feature) throws FLEXlmException {
        FlexeraApi.LicenseInformation.ByValue byValue = FlexeraApiAccess.INSTANCE.getLicenseInformation(this.handle, feature.getName());
        if (byValue.isValid) {
            long l = byValue.daysUntilExpiration;
            if (l == (long)FLEXlmErrorCode.LM_LONGGONE.errNr) {
                l = Long.MIN_VALUE;
            }
            return new LicenseInformation(byValue.version, byValue.feature, byValue.startDate, byValue.expirationDate, l, byValue.vendor, byValue.notice, byValue.fromServer, byValue.numberUsers, ConfigType.valueOf(byValue.type));
        }
        throw this.exceptionWithLastError();
    }

    public void setIdle(boolean bl) {
        FlexeraApiAccess.INSTANCE.setIdle(this.handle, bl ? 1 : 0);
    }

    private FLEXlmException exceptionWithLastError() {
        return new FLEXlmException(this.getLastErrorText(), this.getLastErrorNumber());
    }

    public void returnBorrowedLicense(String string) throws FLEXlmException {
        int n = FlexeraApiAccess.INSTANCE.returnBorrowedLicense(this.handle, string);
        if (n != 0) {
            throw this.exceptionWithLastError();
        }
    }

    public synchronized boolean isAlive() {
        return this.alive;
    }
}

