/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.license;

import com.modelengineers.license.LicenseManagerUI;
import com.modelengineers.license.ToolVersion;
import com.modelengineers.lismo3_0.api.LismoSettings;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ToolLicenseInformation {
    private static final String LISMO_CONFIG_DIR = "lismo";
    public static final String LISMO_CONFIG_FILE_NAME = "lismo.config";
    private static final String TOOL_IDENTIFIER_PATTERN = "%s [%s]";
    private static final String PROFILE_FILE_NAME = "profiles.ini";
    private static final String INSTALL_PATH_KEY = "installation_path";
    private static final String VERSION_KEY = "version";
    private final ToolInformation centralToolInformation = new ToolInformation(new File(LismoSettings.getCurrentLismoGlobalConfigDirectory()), true);
    private ToolInformation toolInformationOfCurrentSelectedTool;
    private String currentSelectedToolKey;
    private final Map<String, ToolInformation> informations = new HashMap<String, ToolInformation>();
    public static final String CENTRAL_CONFIG = "Central Configuration";
    public static final String CURRENT_INSTALLATION_CONFIG = "(current tool)";
    private List<String> keys;
    private ToolInformation currentUserDirToolInformation;

    public ToolLicenseInformation(File userDir) {
        String mesUserDirectory = this.getMESUserDirectory();
        File userRootDir = new File(mesUserDirectory);
        this.initiateToolVersionMap(userRootDir);
        this.markCurrentActiveToolInformation(userDir);
    }

    private void markCurrentActiveToolInformation(File userDir) {
        if (userDir != null && userDir.isDirectory()) {
            this.currentUserDirToolInformation = this.createToolInformation(userDir, true);
            this.markToolInformationOfCurrentSelectedTool(this.currentUserDirToolInformation);
        } else {
            this.markToolInformationOfCurrentSelectedTool();
        }
    }

    public ToolInformation getCentralToolInformation() {
        return this.centralToolInformation;
    }

    public ToolInformation getCurrentUserDirToolInformation() {
        return this.currentUserDirToolInformation;
    }

    private void markToolInformationOfCurrentSelectedTool() {
        this.markToolInformationOfCurrentSelectedTool(null);
    }

    private void markToolInformationOfCurrentSelectedTool(ToolInformation customizedToolInformation) {
        if (customizedToolInformation != null) {
            this.toolInformationOfCurrentSelectedTool = customizedToolInformation;
            this.informations.remove(customizedToolInformation.toolKey);
            this.currentSelectedToolKey = customizedToolInformation.toolKey + " " + CURRENT_INSTALLATION_CONFIG;
            this.informations.put(this.currentSelectedToolKey, this.toolInformationOfCurrentSelectedTool);
        } else {
            Map.Entry<String, ToolInformation> entry = this.getToolInformationForUILocation();
            if (entry != null) {
                this.currentUserDirToolInformation = this.toolInformationOfCurrentSelectedTool = entry.getValue();
                this.informations.remove(entry.getKey());
                this.currentSelectedToolKey = entry.getKey() + " " + CURRENT_INSTALLATION_CONFIG;
                this.informations.put(this.currentSelectedToolKey, this.toolInformationOfCurrentSelectedTool);
            }
        }
    }

    private Map.Entry<String, ToolInformation> getToolInformationForUILocation() {
        File licenseManagerUILocation = this.getLicenseManagerUILocation();
        if (licenseManagerUILocation != null) {
            for (Map.Entry<String, ToolInformation> entry : this.informations.entrySet()) {
                File installationFile = entry.getValue().toolInstallationFile;
                if (installationFile == null || !installationFile.equals(licenseManagerUILocation)) continue;
                return entry;
            }
        }
        return null;
    }

    public ToolInformation getCurrentSelectedToolInformation() {
        return this.toolInformationOfCurrentSelectedTool;
    }

    private File getLicenseManagerUILocation() {
        CodeSource codeSource = LicenseManagerUI.class.getProtectionDomain().getCodeSource();
        try {
            String path = codeSource.getLocation().toURI().getPath();
            return codeSource != null ? new File(path).getParentFile() : null;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private String getMESUserDirectory() {
        String appDataDirectory = System.getenv("APPDATA");
        if (appDataDirectory == null || appDataDirectory.trim().length() == 0) {
            appDataDirectory = System.getProperty("user.home");
        }
        return appDataDirectory + "/MES/";
    }

    private void initiateToolVersionMap(File folder) {
        if (!folder.isDirectory()) {
            return;
        }
        if (folder.getName().equals(LISMO_CONFIG_DIR)) {
            File versionFolder = folder.getParentFile();
            this.createToolInformation(versionFolder);
        } else {
            for (File subFolder : folder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            })) {
                this.initiateToolVersionMap(subFolder);
            }
        }
    }

    private ToolInformation createToolInformation(File toolVersionFile) {
        return this.createToolInformation(toolVersionFile, false);
    }

    private ToolInformation createToolInformation(File toolVersionFile, boolean ignoreDuplicate) {
        ToolInformation toolInformation = new ToolInformation(toolVersionFile);
        if (this.informations.containsKey(toolInformation.toolKey) && !ignoreDuplicate) {
            LicenseManagerUI.logWarn("Tool key is already existing: " + toolInformation.toolKey, null);
        }
        this.informations.put(toolInformation.toolKey, toolInformation);
        return toolInformation;
    }

    public ToolInformation getToolInformation(File toolInstallationFile) {
        if (toolInstallationFile == null || !toolInstallationFile.exists()) {
            return null;
        }
        for (ToolInformation toolInformation : this.informations.values()) {
            if (toolInformation.toolInstallationFile == null || !toolInformation.toolInstallationFile.equals(toolInstallationFile)) continue;
            return toolInformation;
        }
        return null;
    }

    public ToolInformation getToolInformation(String toolKey) {
        if (toolKey.contains(CURRENT_INSTALLATION_CONFIG)) {
            return this.toolInformationOfCurrentSelectedTool;
        }
        return this.informations.get(toolKey);
    }

    public List<String> getAllKeys() {
        if (this.keys == null) {
            if (!this.informations.containsKey(CENTRAL_CONFIG)) {
                this.informations.put(CENTRAL_CONFIG, this.centralToolInformation);
            }
            String[] arraykeys = this.informations.keySet().toArray(new String[this.informations.size()]);
            Arrays.sort(arraykeys, new MyComparator());
            this.keys = Arrays.asList(arraykeys);
        }
        return this.keys;
    }

    public boolean containsToolInformation(String toolKey) {
        return this.informations.containsKey(toolKey);
    }

    private static enum Tool {
        MXAM,
        MXAM_DRIVE,
        MoRe,
        MXRAY,
        MTEST,
        MQC;

        public static final String DEFAULT = "MES TOOL";

        public static String getToolName(File toolVersionFile) {
            if (toolVersionFile == null || !toolVersionFile.isDirectory()) {
                return DEFAULT;
            }
            File parentFile = toolVersionFile.getParentFile();
            if (parentFile == null) {
                return DEFAULT;
            }
            String parentFilename = parentFile.getName();
            for (Tool tool : Tool.values()) {
                if (!parentFilename.equalsIgnoreCase(tool.name())) continue;
                return tool.name();
            }
            return DEFAULT;
        }
    }

    public static class ToolInformation {
        public static final String DEFAULT_VERSION = "1.0";
        public final String toolKey;
        public final File toolVersionFile;
        public File toolInstallationFile;
        public String version = "1.0";
        public final File configFile;

        public ToolInformation(File toolVersionFile) {
            this(toolVersionFile, false);
        }

        public ToolInformation(File toolVersionFile, boolean central) {
            this.toolVersionFile = toolVersionFile;
            this.toolKey = this.createToolIdentifier();
            this.readFromProfileFile();
            this.configFile = this.getConfigFile(central);
        }

        private File getConfigFile(boolean central) {
            if (central) {
                return Paths.get(this.toolVersionFile.toString(), ToolLicenseInformation.LISMO_CONFIG_FILE_NAME).toFile();
            }
            return Paths.get(this.toolVersionFile.toString(), ToolLicenseInformation.LISMO_CONFIG_DIR, ToolLicenseInformation.LISMO_CONFIG_FILE_NAME).toFile();
        }

        protected String createToolIdentifier() {
            if (!this.toolVersionFile.isDirectory()) {
                return "[not resolved]";
            }
            String version = this.toolVersionFile.getName().replace("_", ".");
            String tool = Tool.getToolName(this.toolVersionFile);
            return String.format(ToolLicenseInformation.TOOL_IDENTIFIER_PATTERN, tool, version);
        }

        private void readFromProfileFile() {
            File profilesFile = new File(this.toolVersionFile.toString(), ToolLicenseInformation.PROFILE_FILE_NAME);
            if (!profilesFile.exists()) {
                this.toolInstallationFile = null;
                return;
            }
            String installationDirectory = null;
            try (FileInputStream profilesFileInputStream = new FileInputStream(profilesFile);){
                Properties profilesConfig = new Properties();
                profilesConfig.load(profilesFileInputStream);
                installationDirectory = profilesConfig.getProperty(ToolLicenseInformation.INSTALL_PATH_KEY);
                this.version = profilesConfig.getProperty(ToolLicenseInformation.VERSION_KEY);
                profilesConfig.clear();
            }
            catch (Exception e) {
                LicenseManagerUI.logCrit(null, e);
            }
            this.toolInstallationFile = installationDirectory != null ? new File(installationDirectory) : null;
        }

        public String getToolInstallationDirectory() {
            if (this.toolInstallationFile == null) {
                return "-";
            }
            if (!this.toolInstallationFile.exists()) {
                return "(not existing) " + this.toolInstallationFile.toString();
            }
            return this.toolInstallationFile.toString();
        }
    }

    private class MyComparator
    implements Comparator<String> {
        private MyComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (ToolLicenseInformation.this.currentSelectedToolKey != null && o1.equals(ToolLicenseInformation.this.currentSelectedToolKey)) {
                if (o2.equals(ToolLicenseInformation.CENTRAL_CONFIG)) {
                    return 1;
                }
                return -1;
            }
            if (ToolLicenseInformation.this.currentSelectedToolKey != null && o2.equals(ToolLicenseInformation.this.currentSelectedToolKey)) {
                if (o1.equals(ToolLicenseInformation.CENTRAL_CONFIG)) {
                    return -1;
                }
                return 1;
            }
            if (o1 == null || o1.equals(ToolLicenseInformation.CENTRAL_CONFIG)) {
                return -1;
            }
            if (o2 == null || o2.equals(ToolLicenseInformation.CENTRAL_CONFIG)) {
                return 1;
            }
            return new ToolVersion(o2).compareTo(new ToolVersion(o1));
        }
    }
}

