/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.license;

import com.modelengineers.license.FlexeraInformation;
import com.modelengineers.license.LicenseManagerCliParameters;
import com.modelengineers.license.ToolLicenseInformation;
import com.modelengineers.lismo3_0.api.Lismo;
import com.modelengineers.lismo3_0.api.LismoSettings;
import com.modelengineers.lismo3_0.api.exceptions.LismoException;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LicenseServerTester {
    private static final String FLEXNET_OUTPUT_REGEXP = "FlexNet Licensing error:";
    private static final String VERSION_REGEXP = "(\\d+)[_\\.](\\d+).*";
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)[_\\.](\\d+).*");
    private static final List<String> WHITELIST_ACCEPTED_FLEXERA_ERROR = Arrays.asList("-4", "-24", "-35", "-87", "-194");
    private final ToolLicenseInformation licenseInformation;
    private final LicenseManagerCliParameters parameters;
    private String flexeraVariableValue;

    public LicenseServerTester(LicenseManagerCliParameters parameters, ToolLicenseInformation licenseInformation, String flexeraVariableValue) {
        this.parameters = parameters;
        this.licenseInformation = licenseInformation;
        this.flexeraVariableValue = flexeraVariableValue;
    }

    public void testLicenseConfig() {
        this.handleTestLicenseConfig(this.parameters.getLicenseConfigForTest());
        this.handleTestActiveLicenseConfig(this.parameters.isTestActiveLicenseConfig());
        this.handleTestCheckoutLicenses(this.parameters.isTestCheckoutLicenses());
    }

    private void handleTestLicenseConfig(String licenseConfigForTest) {
        if (licenseConfigForTest == null || licenseConfigForTest.isEmpty()) {
            return;
        }
        this.testLicenseServer(licenseConfigForTest);
    }

    private void handleTestActiveLicenseConfig(boolean testActiveLicenseConfig) {
        if (!testActiveLicenseConfig) {
            return;
        }
        String activeLicenseConfig = this.getActiveLicenseConfig();
        if (activeLicenseConfig == null || activeLicenseConfig.isEmpty()) {
            System.out.println("No active license server configuration found for your license setup.");
            System.exit(-1);
        }
        this.testLicenseServer(activeLicenseConfig);
    }

    private void handleTestCheckoutLicenses(boolean testCheckoutLicenses) {
        if (!testCheckoutLicenses) {
            return;
        }
        String activeLicenseConfig = this.getActiveLicenseConfig();
        if (activeLicenseConfig == null || activeLicenseConfig.isEmpty()) {
            System.out.println("No active license server configuration found for your license setup.");
            System.exit(-1);
        }
        this.checkoutLicenseServer(activeLicenseConfig);
    }

    private String getActiveLicenseConfig() {
        String activeLicenseConfig = this.flexeraVariableValue;
        if (activeLicenseConfig != null) {
            return activeLicenseConfig;
        }
        LismoSettings lismoSettings = this.getNeededLismoSettings();
        return lismoSettings.getLicenseServerIds() + File.pathSeparator + lismoSettings.getLicenseFilePaths();
    }

    private LismoSettings getNeededLismoSettings() {
        ToolLicenseInformation.ToolInformation toolInformation = this.licenseInformation.getCurrentUserDirToolInformation();
        if (toolInformation == null) {
            toolInformation = this.licenseInformation.getCentralToolInformation();
        }
        File configFile = toolInformation.configFile;
        try {
            return new LismoSettings(configFile.getAbsolutePath());
        }
        catch (Exception e) {
            System.err.println("Error while reading lismo settings from config file '" + configFile + "'.");
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    private void checkoutLicenseServer(String activeLicenseConfig) {
        LismoSettings lismoSettings = this.getNeededLismoSettings();
        String centralLismoConfigDir = this.licenseInformation.getCentralToolInformation().configFile.getParent();
        Lismo lismo = new Lismo("LICENSE_SERVER_TEST", Arrays.asList(lismoSettings.getLicenseServerIds(), lismoSettings.getLicenseFilePaths()), centralLismoConfigDir);
        try {
            lismo.checkout("MXAM", this.getMxamVersion());
            lismo.checkout("MXAM_CAL", "1.0");
            lismo.checkinAllLicenses();
        }
        catch (LismoException e) {
            this.handleLismoException(e);
        }
        System.out.println("Test license checkout succeeded for " + activeLicenseConfig);
        System.exit(0);
    }

    private void handleLismoException(LismoException e) {
        String causeMessage;
        Throwable cause = e.getCause();
        if (cause == null) {
            System.err.println(e.getMessage());
            System.exit(-1);
        }
        if (this.containsCriticalError(causeMessage = cause.getMessage())) {
            System.err.println(causeMessage);
            System.exit(-1);
        }
    }

    private boolean containsCriticalError(String causeMessage) {
        String[] lines = causeMessage.split("\n");
        for (String line : Arrays.asList(lines)) {
            if (!line.startsWith(FLEXNET_OUTPUT_REGEXP)) continue;
            return this.isCritical(line);
        }
        return false;
    }

    private boolean isCritical(String causeLine) {
        for (String acceptedFlexeraError : WHITELIST_ACCEPTED_FLEXERA_ERROR) {
            if (!causeLine.contains(acceptedFlexeraError + ",")) continue;
            return false;
        }
        return true;
    }

    private String getMxamVersion() {
        ToolLicenseInformation.ToolInformation customizedToolInformation = this.licenseInformation.getCurrentUserDirToolInformation();
        if (customizedToolInformation == null) {
            return "1.0";
        }
        String origVersion = customizedToolInformation.version;
        Matcher matcher = VERSION_PATTERN.matcher(origVersion);
        return matcher.matches() ? matcher.group(1) + ".0" : "1.0";
    }

    private void testLicenseServer(String licenseServer) {
        try {
            FlexeraInformation flexInfoWithCustomInformer = new FlexeraInformation(new SysoutProgressListener(), new SysOutLmUtilInformer());
            flexInfoWithCustomInformer.testLicenseServer(licenseServer);
        }
        catch (FlexeraInformation.LmUtilFileNotFoundException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            System.exit(-1);
        }
        while (true) {
            try {
                while (true) {
                    Thread.sleep(500L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private class SysOutLmUtilInformer
    implements FlexeraInformation.LmUtilInformer {
        private SysOutLmUtilInformer() {
        }

        @Override
        public void showHostIds(String hostids) {
            System.out.println(hostids);
        }

        @Override
        public void showResultOfTestServer(String testServerResult) {
            System.out.println(testServerResult);
        }
    }

    private class SysoutProgressListener
    implements FlexeraInformation.ProgressListener {
        private SysoutProgressListener() {
        }

        @Override
        public void showProgressBar() {
        }

        @Override
        public void hideProgressBar() {
            System.exit(0);
        }
    }
}

