/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.license;

import com.beust.jcommander.JCommander;
import com.modelengineers.license.EnvironmentVariablesHandler;
import com.modelengineers.license.FlexeraInformation;
import com.modelengineers.license.JavaUtilities;
import com.modelengineers.license.LicenseManagerCliParameters;
import com.modelengineers.license.LicenseServerTester;
import com.modelengineers.license.ToolLicenseInformation;
import com.modelengineers.lismo3_0.api.LismoConfig;
import com.modelengineers.lismo3_0.api.LismoSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;

public class LicenseManagerUI {
    private static final String LICENSE_MANAGER_VERSION = "2.5";
    private static final Logger LOG = Logger.getLogger(LicenseManagerUI.class.getName());
    private static final int UI_WIDTH = 800;
    private static final int UI_HEIGHT = 450;
    private static final String LICENSE_FILE_SUFFIX = ".lic";
    private static final String LICENSE_SERVER_ID_KEY = "license_server_id";
    private static final String LICENSE_FILE_DIR_KEY = "license_file_dir";
    private static final String MESSAGE_LOCAL_CONFIGURATION_FOUND = "Warning: Your tool specific configuration %s is not empty. It takes precedence over this central configuration, and therefore deactivates it." + System.lineSeparator() + System.lineSeparator() + "If you want to use the central configuration instead, please empty the configuration fields of the tool specific configuration.";
    private static final String MESSAGE_LICENSE_DIRECTORY_INVALID = "Warning: Invalid MES license file or directory without valid license file(s) configured: " + System.lineSeparator() + "'%s'" + System.lineSeparator() + System.lineSeparator() + "If the configured directory is empty, the central configuration will be used instead.";
    private static final String MESSAGE_LICENSE_EMPTY_FIELDS = "Nothing was configured, therefore the central configuration will be used.";
    private static final String MESSAGE_LICENSE_VALID = "Found a valid MES license at the given location.";
    private static final String CONFIG_BORDER_TEXT = "Configuration%s";
    private final Properties configuration;
    private final ToolLicenseInformation toolInformation;
    private final FlexeraInformation licenseInformation = new FlexeraInformation(new LicenseManagerProgressListener(), new LicenseManagerInformer());
    private EnvironmentVariablesHandler envHandler;
    public static final String MES_ENVIRONMENT_VARIABLE_CONFIG = "MES Environment Variable";
    private ToolLicenseInformation.ToolInformation selectedToolInformation;
    private JTextField configrationDirField = new JTextField();
    private JTextField toolInstallationDirField = new JTextField();
    private JLabel licenseServerLabel = new JLabel();
    private JTextField licenseServerField = new JTextField();
    private JLabel licenseDirLabel = new JLabel();
    private JTextField licenseDirField = new JTextField();
    private JButton fileChooserButton = new JButton();
    private JButton saveButton = new JButton();
    private JTextArea outputTextArea = new JTextArea();
    private JButton revertButton = new JButton();
    private JComponent advancedArea;
    private JComboBox<String> toolCombo;
    private JFrame mainFrame;
    private JButton testServerButton;
    private JTextArea hostListArea;
    private JProgressBar progressBar;
    private JPanel configPanel;

    public LicenseManagerUI(String[] args) {
        LicenseManagerCliParameters parameters = new LicenseManagerCliParameters();
        JCommander jc = new JCommander(parameters);
        jc.setCaseSensitiveOptions(false);
        try {
            jc.parse(args);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            jc.usage();
            System.exit(-1);
        }
        this.handleHelp(parameters, jc);
        String userDir = parameters.getUserDir();
        this.toolInformation = new ToolLicenseInformation(userDir != null && !userDir.isEmpty() ? new File(userDir) : null);
        this.configuration = new Properties();
        this.envHandler = new EnvironmentVariablesHandler(this);
        new LicenseServerTester(parameters, this.toolInformation, this.envHandler.getFlexeraVariableValue()).testLicenseConfig();
        this.handleLicenseSetup(parameters);
        this.createFrame();
        this.preselectToolInformation();
        this.enableFields();
    }

    private void handleHelp(LicenseManagerCliParameters parameters, JCommander jc) {
        if (parameters.isHelp()) {
            jc.usage();
            System.exit(0);
        }
        if (parameters.isGetLicenseConfigPath()) {
            System.out.println(LismoSettings.getCurrentLismoGlobalConfigDirectory());
            System.exit(0);
        }
    }

    private void handleLicenseSetup(LicenseManagerCliParameters parameters) {
        List<String> licenseFiles = parameters.getLicenseFiles();
        List<String> licenseServers = parameters.getLicenseServers();
        if (licenseFiles.isEmpty() && licenseServers.isEmpty()) {
            return;
        }
        this.setConfigProperty(LICENSE_FILE_DIR_KEY, licenseFiles);
        this.setConfigProperty(LICENSE_SERVER_ID_KEY, licenseServers);
        ToolLicenseInformation.ToolInformation customizedToolInformation = this.toolInformation.getCurrentUserDirToolInformation();
        ToolLicenseInformation.ToolInformation usedToolInformation = customizedToolInformation != null ? customizedToolInformation : this.toolInformation.getCentralToolInformation();
        this.saveConfigFile(usedToolInformation);
        System.exit(0);
    }

    public JFrame getFrame() {
        return this.mainFrame;
    }

    private void createFrame() {
        this.mainFrame = new JFrame();
        this.mainFrame.setDefaultCloseOperation(2);
        this.mainFrame.setTitle("MES License Manager");
        this.mainFrame.getContentPane().setLayout(new GridBagLayout());
        this.mainFrame.setSize(800, 450);
        this.mainFrame.setMinimumSize(new Dimension(800, 450));
        this.mainFrame.setLocationRelativeTo(null);
        this.mainFrame.setResizable(true);
        this.mainFrame.setContentPane(this.createMainPanel());
    }

    private void show() {
        this.mainFrame.setVisible(true);
    }

    private JComponent createMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.setBackground(Color.WHITE);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 11;
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.insets = new Insets(0, 5, 0, 5);
        c.gridx = 0;
        c.gridy = 0;
        mainPanel.add((Component)this.createConfigPanel(), c);
        c.fill = 1;
        c.insets = new Insets(0, 5, 0, 5);
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 1;
        mainPanel.add((Component)this.createMessagesArea(), c);
        c.fill = 2;
        c.anchor = 15;
        c.insets = new Insets(0, 5, 10, 5);
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 2;
        mainPanel.add((Component)this.createBottomPanel(), c);
        return mainPanel;
    }

    private JComponent createTxtAreaToolInstallDir() {
        this.toolInstallationDirField.setEditable(false);
        this.toolInstallationDirField.setBackground(Color.WHITE);
        this.toolInstallationDirField.setToolTipText("Installation Directory");
        this.toolInstallationDirField.setBorder(null);
        return this.toolInstallationDirField;
    }

    private JComponent createTxtAreaConfigDir() {
        this.configrationDirField.setEditable(false);
        this.configrationDirField.setBackground(Color.WHITE);
        this.configrationDirField.setToolTipText("Configuration Directory");
        this.configrationDirField.setBorder(null);
        return this.configrationDirField;
    }

    private JComponent createConfigPanel() {
        this.configPanel = new JPanel();
        this.configPanel.setBackground(Color.WHITE);
        this.configPanel.setBorder(BorderFactory.createTitledBorder("Configuration"));
        this.configPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.licenseServerLabel.setText("License Server (PORT@SERVER_IP):");
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.insets = new Insets(15, 10, 5, 10);
        c.gridx = 0;
        c.gridy = 0;
        this.configPanel.add((Component)this.licenseServerLabel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(0, 10, 5, 10);
        this.configPanel.add((Component)this.createLicenseServerField(), c);
        c.weightx = 0.005;
        c.gridx = 1;
        c.gridy = 1;
        this.configPanel.add(this.createTestServerButton(), c);
        this.licenseDirLabel.setText("OR License File (Path to license folder or file):");
        c.weightx = 0.5;
        c.gridx = 0;
        c.gridy = 2;
        this.configPanel.add((Component)this.licenseDirLabel, c);
        c.insets = new Insets(0, 10, 15, 10);
        c.gridx = 0;
        c.gridy = 3;
        this.configPanel.add((Component)this.createLicenseDirField(), c);
        c.weightx = 0.005;
        c.gridx = 1;
        c.gridy = 3;
        this.configPanel.add((Component)this.createFileChooserButton(), c);
        c.fill = 0;
        c.anchor = 17;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 4;
        this.configPanel.add((Component)this.createShowAdvancedOptionsButton(), c);
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 0.5;
        c.gridwidth = 2;
        c.gridx = 0;
        c.gridy = 4;
        this.advancedArea = this.createAdvancedArea();
        this.configPanel.add((Component)this.advancedArea, c);
        this.advancedArea.setVisible(false);
        if (this.isFlexeraVariableInEnvironment()) {
            this.configPanel.setEnabled(false);
        }
        return this.configPanel;
    }

    private JButton createShowAdvancedOptionsButton() {
        final JButton showAdvancedOptionsButton = new JButton("Advanced >>>");
        showAdvancedOptionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                showAdvancedOptionsButton.setVisible(false);
                LicenseManagerUI.this.advancedArea.setVisible(true);
            }
        });
        return showAdvancedOptionsButton;
    }

    private JComponent createAdvancedArea() {
        this.advancedArea = new JPanel();
        this.advancedArea.setBackground(Color.WHITE);
        this.advancedArea.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.anchor = 17;
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridwidth = 2;
        c.insets = new Insets(0, 0, 8, 10);
        c.gridx = 0;
        c.gridy = 0;
        this.advancedArea.add((Component)this.createToolCombo(), c);
        c.anchor = 17;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 2;
        this.advancedArea.add((Component)new JLabel("Configuration Directory:"), c);
        c.fill = 2;
        c.weightx = 0.5;
        c.gridx = 1;
        c.gridy = 2;
        this.advancedArea.add((Component)this.createTxtAreaConfigDir(), c);
        c.fill = 0;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 0, 10);
        c.gridx = 0;
        c.gridy = 3;
        this.advancedArea.add((Component)new JLabel("Tool Installation Directory:"), c);
        c.fill = 2;
        c.weightx = 0.5;
        c.gridx = 1;
        c.gridy = 3;
        this.advancedArea.add((Component)this.createTxtAreaToolInstallDir(), c);
        return this.advancedArea;
    }

    private JComponent createToolCombo() {
        this.toolCombo = new JComboBox();
        this.toolCombo.setModel(new DefaultComboBoxModel<String>(this.getToolListContent()));
        this.toolCombo.setToolTipText("Choose an MES tool.");
        this.toolCombo.setBackground(Color.WHITE);
        this.toolCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String borderTitle = "";
                String selectedTool = LicenseManagerUI.this.getSelectedTool();
                if (LicenseManagerUI.MES_ENVIRONMENT_VARIABLE_CONFIG.equals(selectedTool)) {
                    LicenseManagerUI.this.selectEnvironmentConfigurations();
                    if (LicenseManagerUI.this.getLicenseServer().isEmpty() && LicenseManagerUI.this.getLicenseDir().isEmpty()) {
                        LicenseManagerUI.this.writeWarning(LicenseManagerUI.this.envHandler.getEmptyEnvironmentLicenseDefinedWarning());
                    } else if (LicenseManagerUI.this.envHandler.getFlexeraVariableValue("LM_LICENSE_FILE") != null && LicenseManagerUI.this.envHandler.getFlexeraVariableValue("MES_LICENSE_FILE") == null) {
                        LicenseManagerUI.this.writeWarning(EnvironmentVariablesHandler.MESSAGE_GENERAL_FLEXERA_VALUE_DEFINED_MESSAGE);
                    } else {
                        LicenseManagerUI.this.resetOutput();
                    }
                } else {
                    LicenseManagerUI.this.chooseMESToolAction();
                    LicenseManagerUI.this.warnIfEnvironmentLicenseDefined();
                    if (!selectedTool.isEmpty()) {
                        if ("Central Configuration".equals(selectedTool)) {
                            if (LicenseManagerUI.this.localLicenseValidConfigured()) {
                                LicenseManagerUI.this.writeWarning(String.format(MESSAGE_LOCAL_CONFIGURATION_FOUND, LicenseManagerUI.this.getFormattedInstallationInfo(LicenseManagerUI.this.toolInformation.getCurrentSelectedToolInformation())));
                            }
                        } else {
                            borderTitle = LicenseManagerUI.this.getFormattedInstallationInfo();
                        }
                    }
                }
                LicenseManagerUI.this.configPanel.setBorder(BorderFactory.createTitledBorder(String.format(LicenseManagerUI.CONFIG_BORDER_TEXT, (borderTitle.isEmpty() ? "" : " ") + borderTitle)));
            }
        });
        return this.toolCombo;
    }

    private String getSelectedTool() {
        return (String)this.toolCombo.getSelectedItem();
    }

    private void chooseMESToolAction() {
        this.selectConfigurations(this.getSelectedTool());
    }

    private void selectEnvironmentConfigurations() {
        String envVariableValue = this.envHandler.getFlexeraVariableValue();
        this.licenseServerField.setText(EnvironmentVariablesHandler.parseServerIPValues(envVariableValue));
        this.licenseDirField.setText(EnvironmentVariablesHandler.parseLicenseFileValues(envVariableValue));
        this.configrationDirField.setText("-");
        this.configrationDirField.setToolTipText("You have selected the configuration for the environment variable MES_LICENSE_FILE. In that case, no configuration dir is existing and necessary.");
        this.toolInstallationDirField.setText("-");
        this.toolInstallationDirField.setToolTipText("You have selected the configuration for the environment variable MES_LICENSE_FILE. In that case, no installation dir is existing and necessary.");
        this.selectedToolInformation = null;
        this.switchEnabledState(true);
    }

    private String getFormattedInstallationInfo(ToolLicenseInformation.ToolInformation toolInformation) {
        if (toolInformation == null) {
            toolInformation = this.selectedToolInformation;
        }
        return "(" + toolInformation.createToolIdentifier() + ")";
    }

    private String getFormattedInstallationInfo() {
        return this.getFormattedInstallationInfo(null);
    }

    private JComponent createLicenseServerField() {
        this.setLicenseServerField(this.getLicenseIPFromProperties());
        this.licenseServerField.setToolTipText("Enter the port number and IP or server name of the floating license server. For example, 28000@192.168.1.101 or 27000@license.server.com");
        this.licenseServerField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                LicenseManagerUI.this.revertButton.setEnabled(true);
            }
        });
        return this.licenseServerField;
    }

    private JComponent createFileChooserButton() {
        this.fileChooserButton.setText("Browse...");
        this.fileChooserButton.setToolTipText("Select the file or directory to the license file.");
        this.fileChooserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LicenseManagerUI.this.fileChooserButtonActionPerformed();
            }
        });
        return this.fileChooserButton;
    }

    private JComponent createLicenseDirField() {
        this.licenseDirField.setText(this.getLicenseDirFromProperties());
        this.licenseDirField.setToolTipText("Enter the path to the license file or directory.");
        this.licenseDirField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                LicenseManagerUI.this.validateLicenseDirectory();
                LicenseManagerUI.this.revertButton.setEnabled(true);
            }
        });
        return this.licenseDirField;
    }

    private Component createTestServerButton() {
        this.testServerButton = new JButton();
        this.testServerButton.setText("Test Server");
        this.testServerButton.setToolTipText("Check the connection to configured License Server.");
        this.testServerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LicenseManagerUI.this.checkLicenseServerConfig();
            }
        });
        return this.testServerButton;
    }

    private void checkLicenseServerConfig() {
        String licenseServer = this.getLicenseServer();
        if (licenseServer.isEmpty()) {
            this.writeWarning("No license server configured.");
        } else {
            try {
                this.licenseInformation.testLicenseServer(licenseServer);
            }
            catch (FlexeraInformation.LmUtilFileNotFoundException e) {
                this.writeWarning("Server could not be checked because of missing lmutil.");
            }
        }
    }

    private String getLicenseServer() {
        ArrayList<String> cleanedServers = new ArrayList<String>();
        for (String server : this.getUniqueFormattedServerList()) {
            cleanedServers.add(this.formatRedundancyServerList(server));
        }
        return new JavaUtilities.StringJoiner(File.pathSeparator).join(cleanedServers);
    }

    private String getLicenseDir() {
        return new JavaUtilities.StringJoiner(File.pathSeparator).join(this.getUniqueFormattedLicenseDirList());
    }

    private List<String> getUniqueFormattedServerList() {
        return this.getUniqueFormattedServerList(this.licenseServerField.getText());
    }

    private String formatRedundancyServerList(String input) {
        return new JavaUtilities.StringJoiner(",").join(new JavaUtilities.StringSplitter(",").withTrim().split(input));
    }

    private List<String> getUniqueFormattedServerList(String input) {
        return new JavaUtilities.StringSplitter(File.pathSeparator).withTrim().withUniqueHandling().split(input);
    }

    private List<String> getUniqueFormattedLicenseDirList() {
        return new JavaUtilities.StringSplitter(File.pathSeparator).withTrim().withUniqueHandling().split(this.licenseDirField.getText());
    }

    private JComponent createMessagesArea() {
        JPanel messagesArea = new JPanel();
        messagesArea.setBackground(Color.WHITE);
        messagesArea.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 0.8;
        c.weighty = 0.5;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        messagesArea.add((Component)this.createOutputPanel(), c);
        c.anchor = 13;
        c.weightx = 0.2;
        c.gridx = 1;
        c.gridy = 0;
        messagesArea.add(this.createHostListPanel(), c);
        return messagesArea;
    }

    private Component createHostListPanel() {
        JPanel hostListPanel = new JPanel();
        hostListPanel.setBackground(Color.WHITE);
        hostListPanel.setBorder(BorderFactory.createTitledBorder("Host and Dongle Ids"));
        hostListPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBackground(Color.WHITE);
        scrollPane.setBorder(null);
        scrollPane.setEnabled(false);
        scrollPane.setFocusable(false);
        scrollPane.setPreferredSize(new Dimension(50, 50));
        scrollPane.setHorizontalScrollBar(null);
        this.hostListArea = new JTextArea();
        this.hostListArea.setEditable(false);
        this.hostListArea.setColumns(20);
        this.hostListArea.setLineWrap(true);
        this.hostListArea.setRequestFocusEnabled(true);
        this.hostListArea.setVerifyInputWhenFocusTarget(false);
        scrollPane.setViewportView(this.hostListArea);
        try {
            this.licenseInformation.getHostIds();
        }
        catch (FlexeraInformation.LmUtilFileNotFoundException e) {
            this.writeWarning("Host ids not determined because of missing lmutil.");
        }
        this.hostListArea.setToolTipText("Here you see all available host ids for your license. Double click to copy this list into your clipboard.");
        this.hostListArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    LicenseManagerUI.this.copyHostidsIntoClipboard(LicenseManagerUI.this.hostListArea);
                    LicenseManagerUI.this.writeOutput("List of Host ids copied into Clipboard.");
                }
            }
        });
        c.fill = 1;
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(5, 10, 5, 10);
        hostListPanel.add((Component)scrollPane, c);
        return hostListPanel;
    }

    private void copyHostidsIntoClipboard(JTextComponent area) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(area.getText()), null);
    }

    private JPanel createOutputPanel() {
        JPanel outputPanel = new JPanel();
        outputPanel.setBackground(Color.WHITE);
        outputPanel.setBorder(BorderFactory.createTitledBorder("Output"));
        outputPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBackground(Color.WHITE);
        scrollPane.setBorder(null);
        scrollPane.setEnabled(false);
        scrollPane.setFocusable(false);
        scrollPane.setHorizontalScrollBar(null);
        this.outputTextArea.setEditable(false);
        this.outputTextArea.setColumns(20);
        this.outputTextArea.setBorder(null);
        this.outputTextArea.setLineWrap(true);
        this.outputTextArea.setWrapStyleWord(true);
        this.outputTextArea.setDisabledTextColor(new Color(111, 111, 111));
        this.outputTextArea.setRequestFocusEnabled(true);
        this.outputTextArea.setVerifyInputWhenFocusTarget(false);
        scrollPane.setViewportView(this.outputTextArea);
        this.outputTextArea.setToolTipText("Double click to copy this output into your clipboard.");
        this.outputTextArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    LicenseManagerUI.this.copyHostidsIntoClipboard(LicenseManagerUI.this.outputTextArea);
                }
            }
        });
        c.fill = 1;
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.anchor = 10;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(5, 10, 5, 10);
        outputPanel.add((Component)scrollPane, c);
        return outputPanel;
    }

    private JComponent createBottomPanel() {
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new GridBagLayout());
        bottomPanel.setBackground(Color.WHITE);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.weightx = 0.05;
        c.weighty = 0.5;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(5, 10, 0, 0);
        bottomPanel.add((Component)this.createVersionLabel(), c);
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.progressBar.setString(null);
        this.progressBar.setVisible(false);
        c.insets = new Insets(5, 0, 0, 0);
        c.weightx = 0.75;
        c.gridx = 1;
        bottomPanel.add((Component)this.progressBar, c);
        c.anchor = 13;
        c.weightx = 0.0;
        c.gridx = 2;
        c.insets = new Insets(5, 15, 0, 0);
        bottomPanel.add((Component)this.createSaveButton(), c);
        c.gridx = 3;
        bottomPanel.add((Component)this.createRevertButton(), c);
        c.gridx = 4;
        c.insets = new Insets(5, 15, 0, 2);
        bottomPanel.add((Component)this.createCloseButton(), c);
        return bottomPanel;
    }

    private JComponent createVersionLabel() {
        JLabel versionLabel = new JLabel();
        versionLabel.setText("v2.5");
        versionLabel.setForeground(Color.GRAY);
        return versionLabel;
    }

    private JComponent createSaveButton() {
        this.saveButton.setText("Save");
        this.saveButton.setToolTipText("Save your current configuration.");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LicenseManagerUI.this.saveAction();
            }
        });
        return this.saveButton;
    }

    private JComponent createRevertButton() {
        this.revertButton.setText("Revert");
        this.revertButton.setToolTipText("Revert your changes.");
        this.revertButton.setEnabled(false);
        this.revertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LicenseManagerUI.this.revertAction();
            }
        });
        return this.revertButton;
    }

    private JComponent createCloseButton() {
        JButton closeButton = new JButton();
        closeButton.setText("Close");
        closeButton.setToolTipText("Close the license manager without saving.");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LicenseManagerUI.this.closeAction();
            }
        });
        return closeButton;
    }

    private void preselectToolInformation() {
        if (this.isFlexeraVariableInEnvironment()) {
            this.selectEnvironmentConfigurations();
            this.toolCombo.setSelectedIndex(0);
        } else if (this.localLicenseValidConfigured()) {
            this.selectConfigurations("(current tool)");
            this.toolCombo.setSelectedIndex(1);
        } else {
            this.selectConfigurations("Central Configuration");
            this.toolCombo.setSelectedIndex(0);
        }
    }

    private boolean localLicenseValidConfigured() {
        ToolLicenseInformation.ToolInformation currentSelectedToolInformation = this.toolInformation.getCurrentSelectedToolInformation();
        if (currentSelectedToolInformation != null) {
            return LismoSettings.isValidConfiguration(currentSelectedToolInformation.configFile);
        }
        return false;
    }

    private boolean propertyValuesAreChanged() {
        if (this.isFlexeraVariableInEnvironment()) {
            return true;
        }
        return !this.getLicenseDirFromProperties().equals(this.getLicenseDir()) || !this.getLicenseIPFromProperties().equals(this.getLicenseServer());
    }

    private void saveAction() {
        if (!this.propertyValuesAreChanged()) {
            this.writeOutput("No values have been changed.");
            return;
        }
        this.saveSettings();
    }

    private void saveSettings() {
        if (0 == this.showDialogIfInvalidPathFound()) {
            this.doSaveSettings();
        }
    }

    private int showDialogIfInvalidPathFound() {
        if (this.getLicenseServer().isEmpty() && this.getLicenseDir().isEmpty()) {
            return 0;
        }
        String invalidLicensePath = this.getInvalidLicensePath();
        if (invalidLicensePath != null && this.getLicenseServer().isEmpty()) {
            return JOptionPane.showConfirmDialog(null, String.format(MESSAGE_LICENSE_DIRECTORY_INVALID, invalidLicensePath) + "\n\n Would you like to save the configuration anyways?", "Invalid License Configuration", 0);
        }
        return 0;
    }

    private void doSaveSettings() {
        if (MES_ENVIRONMENT_VARIABLE_CONFIG.equals(this.getSelectedTool())) {
            this.envHandler.setLicenseVariable(this.getLicenseServer(), this.getLicenseDir());
        } else if (this.selectedToolInformation != null) {
            if (!this.isLocalConfigured()) {
                try {
                    this.validateAndReformatInput();
                }
                catch (InvalidPathException ipe) {
                    this.writeWarning("Not saved due to invalid path found. " + ipe.getInput());
                    return;
                }
            }
            this.refreshLicenseConfigProperties();
            this.saveConfigFile();
        }
    }

    private void validateAndReformatInput() throws InvalidPathException {
        this.licenseServerField.setText(this.getLicenseServer());
        this.replaceConfiguredFileToAbsolutePath();
        this.licenseDirField.setText(this.getLicenseDir());
    }

    private void replaceConfiguredFileToAbsolutePath() throws InvalidPathException {
        ArrayList<String> filesWithAbsolutePath = new ArrayList<String>();
        for (String dir : this.getUniqueFormattedLicenseDirList()) {
            String absoluteDir = Paths.get(dir, new String[0]).toAbsolutePath().toString();
            filesWithAbsolutePath.add(absoluteDir);
        }
        this.licenseDirField.setText(new JavaUtilities.StringJoiner(File.pathSeparator).join(filesWithAbsolutePath));
    }

    private void selectConfigurations(String toolKey) {
        this.selectedToolInformation = this.toolInformation.getToolInformation(toolKey);
        this.selectConfiguration();
    }

    private void selectConfiguration() {
        if (this.selectedToolInformation != null) {
            this.loadConfigFile();
            this.setLicenseFields();
            this.setToolPathField();
            this.enableFields();
        } else {
            this.clearLicenseFields();
            this.clearToolPathField();
            this.resetOutput();
            this.disableFields();
        }
    }

    private void closeAction() {
        this.mainFrame.dispose();
    }

    private void revertAction() {
        if (this.isFlexeraVariableInEnvironment()) {
            this.selectEnvironmentConfigurations();
            this.writeOutput("Your changes have been reverted.");
        } else if (this.propertyValuesAreChanged()) {
            this.setLicenseFields();
            this.writeOutput("Your changes have been reverted.");
        } else {
            this.writeOutput("No values have been changed.");
        }
        this.revertButton.setEnabled(false);
    }

    private void fileChooserButtonActionPerformed() {
        JFileChooser fileChooser = new JFileChooser();
        FileFilter filter = new FileFilter(){

            @Override
            public String getDescription() {
                return "License file (*.lic)";
            }

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.isFile() && f.getName().endsWith(LicenseManagerUI.LICENSE_FILE_SUFFIX);
            }
        };
        fileChooser.setFileFilter(filter);
        fileChooser.setFileSelectionMode(2);
        int result = fileChooser.showOpenDialog(this.mainFrame.getContentPane());
        if (result == 0) {
            this.licenseDirField.setText(fileChooser.getSelectedFile().getAbsolutePath());
        }
        this.validateLicenseDirectory();
    }

    private String getInvalidLicensePath() {
        for (String singleLicenseDirFile : this.getUniqueFormattedLicenseDirList()) {
            if (this.isLicensePathValid(new File(singleLicenseDirFile))) continue;
            return singleLicenseDirFile;
        }
        return null;
    }

    private boolean isLocalConfigured() {
        return !this.getSelectedTool().contains("Central Configuration");
    }

    private boolean isLicensePathValid(File licenseFile) {
        if (!licenseFile.exists()) {
            if (this.selectedToolInformation == null) {
                return false;
            }
            File installationFile = this.selectedToolInformation.toolInstallationFile;
            if (installationFile == null || !installationFile.exists()) {
                return false;
            }
            if (!(licenseFile = new File(installationFile, licenseFile.getPath())).exists()) {
                return false;
            }
        }
        if (licenseFile.isDirectory()) {
            File[] listOfFiles;
            for (File file : listOfFiles = licenseFile.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(LicenseManagerUI.LICENSE_FILE_SUFFIX);
                }
            })) {
                if (!this.isLismoLicenseFile(file)) continue;
                return true;
            }
        } else if (licenseFile.isFile() && this.isLismoLicenseFile(licenseFile)) {
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isLismoLicenseFile(File licenseFile) {
        try (BufferedReader br = new BufferedReader(new FileReader(licenseFile));){
            String line = "";
            do {
                if ((line = br.readLine()) == null) return false;
            } while (!line.startsWith("FEATURE") && !line.startsWith("INCREMENT") && !line.startsWith("USE_SERVER"));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LicenseManagerUI.logCrit(null, e);
        }
        return false;
    }

    private void validateLicenseDirectory() {
        this.resetOutput();
        String licenseDir = this.getLicenseDir();
        if (this.selectedToolInformation != null && this.selectedToolInformation.toolKey != null) {
            if (licenseDir.isEmpty()) {
                if (this.getLicenseServer().isEmpty() && this.isLocalConfigured()) {
                    this.writeOutput(MESSAGE_LICENSE_EMPTY_FIELDS);
                }
            } else {
                String invalidLicensePath = this.getInvalidLicensePath();
                if (invalidLicensePath != null) {
                    this.writeOutput(String.format(MESSAGE_LICENSE_DIRECTORY_INVALID, invalidLicensePath));
                } else {
                    this.writeOutput(MESSAGE_LICENSE_VALID);
                }
            }
        }
    }

    private void warnIfEnvironmentLicenseDefined() {
        String environmentLicenseDefinedWarning = this.envHandler.getEnvironmentLicenseDefinedWarning();
        if (!environmentLicenseDefinedWarning.isEmpty()) {
            this.writeWarning(environmentLicenseDefinedWarning);
            this.disableFields();
        }
    }

    public void resetOutput() {
        this.writeOutput("");
    }

    public void writeOutput(String text) {
        this.writeOutput(text, Color.BLACK);
    }

    public void writeWarning(String text) {
        this.writeOutput(text, new Color(200, 0, 0));
    }

    private void writeOutput(String text, Color color) {
        this.outputTextArea.setForeground(color);
        this.outputTextArea.setText(text);
    }

    private boolean isFlexeraVariableInEnvironment() {
        return this.envHandler.getFlexeraVariableValue() != null;
    }

    private void loadConfigFile() {
        if (this.selectedToolInformation == null) {
            return;
        }
        File configFile = this.selectedToolInformation.configFile;
        if (configFile.exists()) {
            try (InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(configFile), StandardCharsets.UTF_8);){
                this.configuration.load(in);
            }
            catch (IOException ex) {
                LicenseManagerUI.logCrit(null, ex);
            }
            this.resetOutput();
        } else {
            this.writeOutput("Config file does not exist [" + configFile.getAbsolutePath() + "].");
            this.configuration.clear();
        }
    }

    private void saveConfigFile() {
        this.saveConfigFile(this.selectedToolInformation);
    }

    private void saveConfigFile(ToolLicenseInformation.ToolInformation selectedToolInformation) {
        File configFile = selectedToolInformation.configFile;
        if (!configFile.getParentFile().exists() && !configFile.getParentFile().mkdirs()) {
            this.writeWarning("Configuration could not be saved because parent directory 'lismo' could not be created (configFile='" + configFile.getAbsolutePath() + "').");
        }
        this.trySaveConfigFile(configFile);
    }

    private void trySaveConfigFile(File configFile) {
        try {
            this.saveConfigFile(configFile);
            if (this.outputTextArea.getText().isEmpty()) {
                this.writeOutput("Config file saved [" + configFile.getAbsolutePath() + "].");
            }
        }
        catch (Exception ex) {
            Logger.getLogger(LicenseManagerUI.class.getName()).log(Level.SEVERE, null, ex);
            this.writeOutput("Config file could not be saved [" + configFile.getAbsolutePath() + "].");
        }
    }

    private void saveConfigFile(File configFile) throws IOException {
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(configFile), StandardCharsets.UTF_8);){
            this.configuration.store(out, LismoConfig.getLicenseFileHelpText());
        }
    }

    private String getConfigProperty(String key) {
        if (key != null && this.configuration != null) {
            return this.configuration.getProperty(key);
        }
        return "";
    }

    private void setConfigProperty(String key, List<String> entries) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String entry : entries) {
            if (first) {
                first = false;
            } else {
                builder.append(File.pathSeparator);
            }
            builder.append(entry);
        }
        this.setConfigProperty(key, builder.toString());
    }

    private void setConfigProperty(String key, String value) {
        if (key != null) {
            this.configuration.setProperty(key, value);
        }
    }

    private String getLicenseDirFromProperties() {
        String licenseDir = this.getConfigProperty(LICENSE_FILE_DIR_KEY);
        if (licenseDir == null) {
            licenseDir = "";
        }
        return licenseDir;
    }

    private String getLicenseIPFromProperties() {
        String licenseIP = this.getConfigProperty(LICENSE_SERVER_ID_KEY);
        if (licenseIP == null) {
            licenseIP = "";
        }
        return licenseIP;
    }

    private void setLicenseDirToProperties(String value) {
        this.setConfigProperty(LICENSE_FILE_DIR_KEY, value);
    }

    private void setLicenseIPToProperties(String value) {
        this.setConfigProperty(LICENSE_SERVER_ID_KEY, value);
    }

    private String[] getToolListContent() {
        ArrayList<String> toolList = new ArrayList<String>();
        String envVariableValue = this.envHandler.getFlexeraVariableValue();
        if (envVariableValue != null) {
            toolList.add(MES_ENVIRONMENT_VARIABLE_CONFIG);
        }
        toolList.addAll(this.toolInformation.getAllKeys());
        if (toolList.size() == 0) {
            toolList.add("");
        }
        return toolList.toArray(new String[toolList.size()]);
    }

    private void setLicenseFields() {
        this.licenseDirField.setText(this.getLicenseDirFromProperties());
        this.setLicenseServerField(this.getLicenseIPFromProperties());
    }

    private void setLicenseServerField(String text) {
        this.licenseServerField.setText(text);
    }

    private void clearLicenseFields() {
        this.licenseDirField.setText("");
        this.setLicenseServerField("");
    }

    private void setToolPathField() {
        String pathToConfigDir = this.selectedToolInformation.toolVersionFile.toString();
        this.configrationDirField.setText(pathToConfigDir);
        this.configrationDirField.setToolTipText(pathToConfigDir);
        String installationDirectory = this.selectedToolInformation.getToolInstallationDirectory();
        this.toolInstallationDirField.setText(installationDirectory);
        this.toolInstallationDirField.setToolTipText(installationDirectory);
    }

    private void clearToolPathField() {
        this.configrationDirField.setText(null);
        this.toolInstallationDirField.setText(null);
    }

    private void refreshLicenseConfigProperties() {
        this.setLicenseDirToProperties(this.getLicenseDir());
        this.setLicenseIPToProperties(this.getLicenseServer());
    }

    private void switchEnabledState(boolean state) {
        this.licenseDirField.setEnabled(state);
        this.licenseServerField.setEnabled(state);
        this.saveButton.setEnabled(state);
        this.fileChooserButton.setEnabled(state);
        this.licenseDirLabel.setEnabled(state);
        this.licenseServerLabel.setEnabled(state);
    }

    public int warnDialog(String title, String warnMessage) {
        return JOptionPane.showConfirmDialog(this.mainFrame, warnMessage, title, 2);
    }

    private void enableFields() {
        this.switchEnabledState(true);
    }

    private void disableFields() {
        this.switchEnabledState(false);
    }

    static void logWarn(String text, Throwable t) {
        LOG.log(Level.WARNING, text, t);
    }

    static void logCrit(String text, Throwable t) {
        LOG.log(Level.SEVERE, text, t);
    }

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                LicenseManagerUI licenseManagerUi = new LicenseManagerUI(args);
                licenseManagerUi.show();
            }
        });
    }

    private class LicenseManagerInformer
    implements FlexeraInformation.LmUtilInformer {
        private LicenseManagerInformer() {
        }

        @Override
        public void showHostIds(String hostids) {
            LicenseManagerUI.this.hostListArea.setText(hostids);
        }

        @Override
        public void showResultOfTestServer(String testServerResult) {
            LicenseManagerUI.this.writeOutput(testServerResult);
        }
    }

    private class LicenseManagerProgressListener
    implements FlexeraInformation.ProgressListener {
        private LicenseManagerProgressListener() {
        }

        @Override
        public void showProgressBar() {
            if (LicenseManagerUI.this.progressBar != null && !LicenseManagerUI.this.progressBar.isVisible()) {
                LicenseManagerUI.this.progressBar.setVisible(true);
            }
        }

        @Override
        public void hideProgressBar() {
            if (LicenseManagerUI.this.progressBar != null && LicenseManagerUI.this.progressBar.isVisible()) {
                LicenseManagerUI.this.progressBar.setVisible(false);
            }
        }
    }
}

